/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

class CugValidatorProvider
extends ValidatorProvider
implements CugConstants {
    private TypePredicate isMixCug;

    CugValidatorProvider() {
    }

    protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        this.isMixCug = new TypePredicate(after, "rep:CugMixin");
        return new CugValidator("", after, false);
    }

    private static CommitFailedException accessViolation(int code, String message) {
        return new CommitFailedException("AccessControl", code, message);
    }

    private void validateCugNode(@Nonnull NodeState parent, @Nonnull NodeState nodeState) throws CommitFailedException {
        if (!"rep:CugPolicy".equals(NodeStateUtils.getPrimaryTypeName((NodeState)nodeState))) {
            throw CugValidatorProvider.accessViolation(21, "Reserved name 'rep:cugPolicy' must only be used for nodes of type 'rep:CugPolicy'.");
        }
        if (!this.isMixCug.apply(parent)) {
            throw CugValidatorProvider.accessViolation(22, "Parent node not of mixin type 'rep:CugMixin'.");
        }
    }

    private static boolean isNodetypeTree(CugValidator parentValidator, String name) {
        if (parentValidator.isNodetypeTree) {
            return true;
        }
        return "jcr:nodeTypes".equals(name) && "jcr:system".equals(parentValidator.parentName);
    }

    private final class CugValidator
    extends DefaultValidator {
        private final NodeState parentAfter;
        private final String parentName;
        private final boolean isNodetypeTree;

        private CugValidator(@Nonnull String parentName, @Nonnull NodeState parentAfter, boolean isNodetypeTree) {
            this.parentAfter = parentAfter;
            this.parentName = parentName;
            this.isNodetypeTree = isNodetypeTree;
        }

        public void propertyAdded(PropertyState after) throws CommitFailedException {
            String name = after.getName();
            if ("jcr:primaryType".equals(name) && "rep:CugPolicy".equals(after.getValue(Type.STRING)) && !"rep:cugPolicy".equals(this.parentName)) {
                throw CugValidatorProvider.accessViolation(23, "Attempt create Cug node with different name than 'rep:cugPolicy'.");
            }
        }

        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            String name = after.getName();
            if ("jcr:primaryType".equals(name) && ("rep:CugPolicy".equals(before.getValue(Type.STRING)) || "rep:CugPolicy".equals(after.getValue(Type.STRING)))) {
                throw CugValidatorProvider.accessViolation(20, "Attempt to change primary type of/to CUG policy.");
            }
        }

        public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
            if (!this.isNodetypeTree && "rep:cugPolicy".equals(name)) {
                CugValidatorProvider.this.validateCugNode(this.parentAfter, after);
            }
            return new VisibleValidator((Validator)new CugValidator(name, after, CugValidatorProvider.isNodetypeTree(this, name)), true, true);
        }

        public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
            if (!this.isNodetypeTree && after.hasChildNode("rep:cugPolicy")) {
                CugValidatorProvider.this.validateCugNode(after, after.getChildNode("rep:cugPolicy"));
            }
            return new VisibleValidator((Validator)new CugValidator(name, after, CugValidatorProvider.isNodetypeTree(this, name)), true, true);
        }
    }
}

