/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import java.security.Principal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugExclude;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugPolicy;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CugPolicyImpl
implements CugPolicy {
    private static final Logger log = LoggerFactory.getLogger(CugPolicyImpl.class);
    private static final String IMMUTABLE_ERR = "Immutable CUG. Use getApplicablePolicies or getPolicies in order to obtain a modifiable policy.";
    private final String oakPath;
    private final NamePathMapper namePathMapper;
    private final PrincipalManager principalManager;
    private final int importBehavior;
    private final CugExclude cugExclude;
    private final boolean immutable;
    private final Map<String, Principal> principals = new LinkedHashMap<String, Principal>();

    CugPolicyImpl(@NotNull String oakPath, @NotNull NamePathMapper namePathMapper, @NotNull PrincipalManager principalManager, int importBehavior, @NotNull CugExclude cugExclude) {
        this(oakPath, namePathMapper, principalManager, importBehavior, cugExclude, Collections.emptySet(), false);
    }

    CugPolicyImpl(@NotNull String oakPath, @NotNull NamePathMapper namePathMapper, @NotNull PrincipalManager principalManager, int importBehavior, @NotNull CugExclude cugExclude, @NotNull Iterable<Principal> principals, boolean immutable) {
        ImportBehavior.nameFromValue((int)importBehavior);
        this.oakPath = oakPath;
        this.namePathMapper = namePathMapper;
        this.principalManager = principalManager;
        this.importBehavior = importBehavior;
        this.cugExclude = cugExclude;
        for (Principal principal : principals) {
            this.principals.put(principal.getName(), principal);
        }
        this.immutable = immutable;
    }

    private void checkIsMutable() throws AccessControlException {
        if (this.immutable) {
            throw new AccessControlException(IMMUTABLE_ERR);
        }
    }

    @NotNull
    public Set<Principal> getPrincipals() {
        return Sets.newHashSet(this.principals.values());
    }

    public boolean addPrincipals(Principal ... principals) throws AccessControlException {
        this.checkIsMutable();
        boolean modified = false;
        for (Principal principal : principals) {
            if (!this.isValidPrincipal(principal) || this.principals.containsKey(principal.getName())) continue;
            this.principals.put(principal.getName(), principal);
            modified = true;
        }
        return modified;
    }

    public boolean removePrincipals(Principal ... principals) throws AccessControlException {
        this.checkIsMutable();
        boolean modified = false;
        for (Principal principal : principals) {
            if (principal == null || !this.principals.containsKey(principal.getName())) continue;
            this.principals.remove(principal.getName());
            modified = true;
        }
        return modified;
    }

    @NotNull
    public String getPath() {
        return this.namePathMapper.getJcrPath(this.oakPath);
    }

    Iterable<String> getPrincipalNames() {
        return Sets.newHashSet(this.principals.keySet());
    }

    private boolean isValidPrincipal(@Nullable Principal principal) throws AccessControlException {
        if (principal == null) {
            log.debug("Ignoring null principal.");
            return false;
        }
        String name = principal.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            throw new AccessControlException("Invalid principal " + name);
        }
        if (this.cugExclude.isExcluded(Collections.singleton(principal))) {
            log.warn("Attempt to add excluded principal {} to CUG.", (Object)principal);
            return false;
        }
        boolean isValid = true;
        switch (this.importBehavior) {
            case 1: {
                if (this.principalManager.hasPrincipal(name)) break;
                log.debug("Ignoring unknown principal {}", (Object)name);
                isValid = false;
                break;
            }
            case 2: {
                log.debug("Best effort: don't verify existence of principals.");
                break;
            }
            default: {
                if (this.principalManager.hasPrincipal(name)) break;
                throw new AccessControlException("Unknown principal " + name);
            }
        }
        return isValid;
    }
}

