/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;

class TopLevelPaths
implements CugConstants {
    private static final long NONE = -1L;
    static final long MAX_CNT = 10L;
    private final Root root;
    private Boolean hasAny;
    private Long cnt;
    private String[] paths = new String[0];

    TopLevelPaths(Root root) {
        this.root = root;
    }

    boolean hasAny() {
        if (this.hasAny == null) {
            Tree rootTree = this.root.getTree("/");
            this.hasAny = rootTree.hasProperty(":topCugCnt") || CugUtil.hasCug(rootTree);
        }
        return this.hasAny;
    }

    boolean contains(@NotNull String path) {
        if (!this.hasAny()) {
            return false;
        }
        if (PathUtils.denotesRoot((String)path)) {
            return true;
        }
        if (this.cnt == null) {
            this.computeCntAndPaths();
        }
        if (this.cnt == -1L) {
            return false;
        }
        if (this.cnt > 10L) {
            return true;
        }
        for (String p : this.paths) {
            if (!Text.isDescendantOrEqual((String)path, (String)p)) continue;
            return true;
        }
        return false;
    }

    private void computeCntAndPaths() {
        Tree rootTree = this.root.getTree("/");
        PropertyState hiddenTopCnt = rootTree.getProperty(":topCugCnt");
        if (hiddenTopCnt != null) {
            PropertyState hidden;
            this.cnt = (Long)hiddenTopCnt.getValue(Type.LONG);
            this.paths = this.cnt <= 10L ? ((hidden = this.root.getTree("/").getProperty(":nestedCugs")) == null ? new String[]{} : (String[])Iterables.toArray((Iterable)((Iterable)hidden.getValue(Type.STRINGS)), String.class)) : new String[0];
        } else {
            this.cnt = -1L;
        }
    }
}

