/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug;

import java.security.Principal;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.security.principal.AdminPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.SystemUserPrincipal;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface CugExclude {
    public boolean isExcluded(@NotNull Set<Principal> var1);

    public static class Default
    implements CugExclude {
        @Override
        public boolean isExcluded(@NotNull Set<Principal> principals) {
            if (principals.isEmpty()) {
                return true;
            }
            if (principals.contains(SystemPrincipal.INSTANCE)) {
                return true;
            }
            for (Principal p : principals) {
                if (!(p instanceof AdminPrincipal) && !(p instanceof SystemUserPrincipal)) continue;
                return true;
            }
            return false;
        }
    }
}

