/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeTypeRegistry;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugExclude;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugContext;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugImporter;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.NestedCugHook;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.EmptyPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;

@Component(metatype=true, label="Apache Jackrabbit Oak CUG Configuration", description="Authorization configuration dedicated to setup and evaluate 'Closed User Group' permissions.", policy=ConfigurationPolicy.REQUIRE)
@Service(value={AuthorizationConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="cugSupportedPaths", label="Supported Paths", description="Paths under which CUGs can be created and will be evaluated.", cardinality=0x7FFFFFFF), @Property(name="cugEnabled", label="CUG Evaluation Enabled", description="Flag to enable the evaluation of the configured CUG policies.", boolValue={false}), @Property(name="configurationRanking", label="Ranking", description="Ranking of this configuration in a setup with multiple authorization configurations.", intValue={200})})
public class CugConfiguration
extends ConfigurationBase
implements AuthorizationConfiguration,
CugConstants {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private CugExclude exclude;
    @Reference
    private MountInfoProvider mountInfoProvider;
    private Set<String> supportedPaths = ImmutableSet.of();

    public CugConfiguration() {
    }

    public CugConfiguration(@Nonnull SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authorization"));
        this.mountInfoProvider = (MountInfoProvider)this.getParameters().getConfigValue("mountInfoProvider", (Object)Mounts.defaultMountInfoProvider(), MountInfoProvider.class);
        this.supportedPaths = CugUtil.getSupportedPaths(this.getParameters(), this.mountInfoProvider);
    }

    @Nonnull
    public AccessControlManager getAccessControlManager(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper) {
        return new CugAccessControlManager(root, namePathMapper, this.getSecurityProvider(), this.supportedPaths);
    }

    @Nonnull
    public RestrictionProvider getRestrictionProvider() {
        return RestrictionProvider.EMPTY;
    }

    @Nonnull
    public PermissionProvider getPermissionProvider(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals) {
        ConfigurationParameters params = this.getParameters();
        boolean enabled = (Boolean)params.getConfigValue("cugEnabled", (Object)false);
        if (!enabled || this.supportedPaths.isEmpty() || this.getExclude().isExcluded(principals)) {
            return EmptyPermissionProvider.getInstance();
        }
        return new CugPermissionProvider(root, workspaceName, principals, this.supportedPaths, ((AuthorizationConfiguration)this.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class)).getContext());
    }

    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.authorization";
    }

    @Nonnull
    public RepositoryInitializer getRepositoryInitializer() {
        return builder -> {
            NodeState base = builder.getNodeState();
            MemoryNodeStore store = new MemoryNodeStore(base);
            Root root = RootFactory.createSystemRoot((NodeStore)store, (CommitHook)new EditorHook((EditorProvider)new CompositeEditorProvider(new EditorProvider[]{new NamespaceEditorProvider(), new TypeEditorProvider()})), null, null, null, null);
            if (CugConfiguration.registerCugNodeTypes(root)) {
                NodeState target = store.getRoot();
                target.compareAgainstBaseState(base, (NodeStateDiff)new ApplyDiff(builder));
            }
        };
    }

    @Nonnull
    public List<? extends CommitHook> getCommitHooks(@Nonnull String workspaceName) {
        return Collections.singletonList(new NestedCugHook());
    }

    @Nonnull
    public List<? extends ValidatorProvider> getValidators(@Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull MoveTracker moveTracker) {
        return ImmutableList.of((Object)new CugValidatorProvider());
    }

    @Nonnull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.singletonList(new CugImporter(this.mountInfoProvider));
    }

    @Nonnull
    public Context getContext() {
        return CugContext.INSTANCE;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        ConfigurationParameters params = ConfigurationParameters.of(properties);
        this.setParameters(params);
        this.supportedPaths = CugUtil.getSupportedPaths(params, this.mountInfoProvider);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.activate(properties);
    }

    @Nonnull
    private CugExclude getExclude() {
        return this.exclude == null ? new CugExclude.Default() : this.exclude;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean registerCugNodeTypes(final @Nonnull Root root) {
        try {
            ReadOnlyNodeTypeManager ntMgr = new ReadOnlyNodeTypeManager(){

                protected Tree getTypes() {
                    return root.getTree("/jcr:system/jcr:nodeTypes");
                }
            };
            if (ntMgr.hasNodeType("rep:CugPolicy")) return false;
            try (InputStream stream = CugConfiguration.class.getResourceAsStream("cug_nodetypes.cnd");){
                NodeTypeRegistry.register((Root)root, (InputStream)stream, (String)"cug node types");
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException | RepositoryException e) {
            throw new IllegalStateException("Unable to read cug node types", e);
        }
    }

    protected void bindExclude(CugExclude cugExclude) {
        this.exclude = cugExclude;
    }

    protected void unbindExclude(CugExclude cugExclude) {
        if (this.exclude == cugExclude) {
            this.exclude = null;
        }
    }

    protected void bindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    protected void unbindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        if (this.mountInfoProvider == mountInfoProvider) {
            this.mountInfoProvider = null;
        }
    }
}

