/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.jetbrains.annotations.NotNull;

class SupportedPaths {
    private final String[] supportedPaths;
    private final String[] supportedAltPaths;
    private final boolean includesRootPath;

    SupportedPaths(@NotNull Set<String> supportedPaths) {
        this.supportedPaths = supportedPaths.toArray(new String[supportedPaths.size()]);
        this.supportedAltPaths = new String[supportedPaths.size()];
        boolean foundRootPath = false;
        int i = 0;
        for (String p : supportedPaths) {
            if (PathUtils.denotesRoot((String)p)) {
                foundRootPath = true;
                continue;
            }
            this.supportedAltPaths[i++] = p + '/';
        }
        this.includesRootPath = foundRootPath;
    }

    boolean includes(@NotNull String path) {
        if (this.supportedPaths.length == 0) {
            return false;
        }
        if (this.includesRootPath) {
            return true;
        }
        for (String p : this.supportedAltPaths) {
            if (!path.startsWith(p)) continue;
            return true;
        }
        for (String p : this.supportedPaths) {
            if (!path.equals(p)) continue;
            return true;
        }
        return false;
    }

    boolean mayContainCug(@NotNull String path) {
        if (this.supportedPaths.length == 0) {
            return false;
        }
        if (this.includesRootPath || PathUtils.denotesRoot((String)path)) {
            return true;
        }
        String path2 = path + '/';
        for (String sp : this.supportedPaths) {
            if (!sp.startsWith(path2)) continue;
            return true;
        }
        return false;
    }
}

