/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.Filter;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.FilterProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.SystemUserPrincipal;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FilterProvider.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class FilterProviderImpl
implements FilterProvider {
    private static final Logger log = LoggerFactory.getLogger(FilterProviderImpl.class);
    private String oakPath;
    private final Map<String, String> validatedPrincipalNamesPathMap = Maps.newConcurrentMap();
    private final Map<String, String> unsupportedPrincipalNames = Maps.newConcurrentMap();

    @Override
    public boolean handlesPath(@NotNull String oakPath) {
        return Text.isDescendantOrEqual((String)this.oakPath, (String)oakPath);
    }

    @Override
    @NotNull
    public String getFilterRoot() {
        return this.oakPath;
    }

    @Override
    @NotNull
    public Filter getFilter(@NotNull SecurityProvider securityProvider, @NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        PrincipalProvider principalProvider = ((PrincipalConfiguration)securityProvider.getConfiguration(PrincipalConfiguration.class)).getPrincipalProvider(root, namePathMapper);
        return new FilterImpl(root, principalProvider, namePathMapper);
    }

    @Activate
    protected void activate(Configuration configuration, Map<String, Object> properties) {
        this.setPath(configuration);
    }

    @Modified
    protected void modified(Configuration configuration, Map<String, Object> properties) {
        this.setPath(configuration);
    }

    private void setPath(@NotNull Configuration configuration) {
        Preconditions.checkState((boolean)FilterProviderImpl.isValidPath(configuration.path()), (Object)"Configured path must be a valid absolute path.");
        this.oakPath = configuration.path();
    }

    private static boolean isValidPath(@Nullable String path) {
        return !Strings.isNullOrEmpty((String)path) && PathUtils.isAbsolute((String)path);
    }

    private final class FilterImpl
    implements Filter {
        private final Root root;
        private final PrincipalProvider principalProvider;
        private final NamePathMapper namePathMapper;

        private FilterImpl(@NotNull Root root, @NotNull PrincipalProvider principalProvider, NamePathMapper namePathMapper) {
            this.root = root;
            this.principalProvider = principalProvider;
            this.namePathMapper = namePathMapper;
        }

        @Override
        public boolean canHandle(@NotNull Set<Principal> principals) {
            if (principals.isEmpty()) {
                return false;
            }
            for (Principal p : principals) {
                if (this.isValidPrincipal(p)) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public String getOakPath(@NotNull Principal validPrincipal) {
            String principalPath = (String)FilterProviderImpl.this.validatedPrincipalNamesPathMap.get(validPrincipal.getName());
            if (principalPath == null) {
                throw new IllegalArgumentException("Invalid principal " + validPrincipal.getName());
            }
            return principalPath;
        }

        @Override
        @Nullable
        public Principal getValidPrincipal(@NotNull String oakPath) {
            ItemBasedPrincipal principal = this.principalProvider.getItemBasedPrincipal(oakPath);
            if (principal != null && this.isValidPrincipal((Principal)principal)) {
                return principal;
            }
            return null;
        }

        private boolean isValidPrincipal(@NotNull Principal principal) {
            if (!(principal instanceof SystemUserPrincipal)) {
                return false;
            }
            String principalName = principal.getName();
            String path = (String)FilterProviderImpl.this.validatedPrincipalNamesPathMap.get(principalName);
            if (path != null && this.isValidMapEntry(principal, path)) {
                return true;
            }
            path = (String)FilterProviderImpl.this.unsupportedPrincipalNames.get(principalName);
            if (path != null && this.isValidMapEntry(principal, path)) {
                return false;
            }
            String principalPath = this.getPrincipalPath(principal);
            if (principalPath != null && FilterProviderImpl.this.handlesPath(principalPath)) {
                FilterProviderImpl.this.unsupportedPrincipalNames.remove(principalName);
                FilterProviderImpl.this.validatedPrincipalNamesPathMap.put(principalName, principalPath);
                return true;
            }
            FilterProviderImpl.this.validatedPrincipalNamesPathMap.remove(principalName);
            FilterProviderImpl.this.unsupportedPrincipalNames.put(principalName, Strings.nullToEmpty((String)principalPath));
            return false;
        }

        private boolean isValidMapEntry(@NotNull Principal principal, @NotNull String oakPath) {
            if (principal instanceof ItemBasedPrincipal) {
                return oakPath.equals(this.getOakPath((ItemBasedPrincipal)principal));
            }
            return true;
        }

        @Nullable
        private String getPrincipalPath(@NotNull Principal principal) {
            String prinicpalOakPath = null;
            if (principal instanceof ItemBasedPrincipal) {
                prinicpalOakPath = this.getOakPath((ItemBasedPrincipal)principal);
            }
            if (prinicpalOakPath == null || !this.root.getTree(prinicpalOakPath).exists()) {
                Principal p = this.principalProvider.getPrincipal(principal.getName());
                prinicpalOakPath = p instanceof ItemBasedPrincipal ? this.getOakPath((ItemBasedPrincipal)p) : null;
            }
            return prinicpalOakPath;
        }

        @Nullable
        private String getOakPath(@NotNull ItemBasedPrincipal principal) {
            try {
                return this.namePathMapper.getOakPath(principal.getPath());
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving path from ItemBasedPrincipal {}, {}", (Object)principal.getName(), (Object)e.getMessage());
                return null;
            }
        }
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak Filter for Principal Based Authorization")
    static @interface Configuration {
        @AttributeDefinition(name="Path", description="Required path underneath which all filtered system-user-principals must be located in the repository.")
        public String path();
    }
}

