/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.security.Principal;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregationFilter;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedPermissionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationFilterImpl
implements AggregationFilter {
    private static final Logger log = LoggerFactory.getLogger(AggregationFilterImpl.class);

    public boolean stop(@NotNull AggregatedPermissionProvider permissionProvider, @NotNull Set<Principal> principals) {
        return permissionProvider instanceof PrincipalBasedPermissionProvider;
    }

    public boolean stop(@NotNull JackrabbitAccessControlManager accessControlManager, @NotNull Set<Principal> principals) {
        try {
            return accessControlManager instanceof PrincipalBasedAccessControlManager && ((PrincipalBasedAccessControlManager)accessControlManager).canHandle(principals);
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public boolean stop(@NotNull AccessControlManager accessControlManager, @Nullable String absPath) {
        return false;
    }
}

