/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlList;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.AbstractEntry;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.MgrProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Utils;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrincipalPolicyImpl
extends AbstractAccessControlList
implements PrincipalAccessControlList {
    private static final Logger log = LoggerFactory.getLogger(PrincipalPolicyImpl.class);
    private final List<EntryImpl> entries = new ArrayList<EntryImpl>();
    private final Principal principal;
    private final RestrictionProvider restrictionProvider;
    private final PrivilegeManager privilegeManager;
    private final PrivilegeBitsProvider privilegeBitsProvider;

    PrincipalPolicyImpl(@NotNull Principal principal, @NotNull String oakPath, @NotNull MgrProvider mgrProvider) {
        super(oakPath, mgrProvider.getNamePathMapper());
        this.principal = principal;
        this.restrictionProvider = mgrProvider.getRestrictionProvider();
        this.privilegeManager = mgrProvider.getPrivilegeManager();
        this.privilegeBitsProvider = mgrProvider.getPrivilegeBitsProvider();
    }

    boolean addEntry(@NotNull Tree entryTree) throws AccessControlException {
        String oakPath = Strings.emptyToNull((String)TreeUtil.getString((Tree)entryTree, (String)"rep:effectivePath"));
        PrivilegeBits bits = this.privilegeBitsProvider.getBits((Iterable)entryTree.getProperty("rep:privileges").getValue(Type.NAMES));
        Set restrictions = this.restrictionProvider.readRestrictions(oakPath, entryTree);
        return this.addEntry(new EntryImpl(oakPath, bits, restrictions));
    }

    @NotNull
    public List<EntryImpl> getEntries() {
        return this.entries;
    }

    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        return this.restrictionProvider;
    }

    @NotNull
    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean addEntry(@Nullable String effectivePath, @NotNull Privilege[] privileges) throws RepositoryException {
        return this.addEntry(effectivePath, privileges, Collections.emptyMap(), Collections.emptyMap());
    }

    public boolean addEntry(@Nullable String effectivePath, @NotNull Privilege[] privileges, @NotNull Map<String, Value> restrictions, @NotNull Map<String, Value[]> mvRestrictions) throws RepositoryException {
        String oakPath;
        String string = oakPath = effectivePath == null ? null : this.getNamePathMapper().getOakPath(effectivePath);
        if (oakPath != null && !PathUtils.isAbsolute((String)oakPath)) {
            throw new AccessControlException("Absolute path expected. Instead was " + effectivePath);
        }
        Set<Restriction> rs = this.validateRestrictions(oakPath, restrictions, mvRestrictions);
        PrivilegeBits privilegeBits = this.validatePrivileges(privileges);
        return this.addEntry(new EntryImpl(oakPath, privilegeBits, rs));
    }

    public boolean addEntry(@NotNull Principal principal, @NotNull Privilege[] privileges, boolean isAllow, @Nullable Map<String, Value> restrictions, @Nullable Map<String, Value[]> mvRestrictions) throws RepositoryException {
        if (!this.principal.equals(principal)) {
            throw new AccessControlException("Principal must be the one associated with the principal based policy.");
        }
        if (!isAllow) {
            throw new AccessControlException("Principal based access control does not support DENY access control entries.");
        }
        String jcrNodePathName = this.getNamePathMapper().getJcrName("rep:nodePath");
        String path = this.extractPathFromRestrictions(restrictions, jcrNodePathName);
        Map filteredRestrictions = Maps.filterEntries(restrictions, entry -> !jcrNodePathName.equals(entry.getKey()));
        return this.addEntry(path, privileges, filteredRestrictions, mvRestrictions == null ? Collections.emptyMap() : mvRestrictions);
    }

    public void orderBefore(@NotNull AccessControlEntry srcEntry, @Nullable AccessControlEntry destEntry) throws RepositoryException {
        EntryImpl dest;
        EntryImpl src = PrincipalPolicyImpl.validateEntry(srcEntry);
        EntryImpl entryImpl = dest = destEntry == null ? null : PrincipalPolicyImpl.validateEntry(destEntry);
        if (src.equals((Object)dest)) {
            log.debug("'srcEntry' equals 'destEntry' -> no reordering.");
            return;
        }
        int index = -1;
        if (dest != null && (index = this.entries.indexOf((Object)dest)) < 0) {
            throw new AccessControlException("Destination entry not contained in this AccessControlList.");
        }
        if (this.entries.remove((Object)src)) {
            if (index != -1) {
                this.entries.add(index, src);
            } else {
                this.entries.add(src);
            }
        } else {
            throw new AccessControlException("Source entry not contained in this AccessControlList");
        }
    }

    public void removeAccessControlEntry(AccessControlEntry ace) throws RepositoryException {
        PrincipalPolicyImpl.validateEntry(ace);
        if (!this.entries.remove(ace)) {
            throw new AccessControlException("AccessControlEntry " + ace + " not contained in AccessControlList");
        }
    }

    @NotNull
    private String getOakName(@NotNull String jcrName) throws RepositoryException {
        return this.getNamePathMapper().getOakName(jcrName);
    }

    @NotNull
    private Set<Restriction> validateRestrictions(@Nullable String effectiveOakPath, @NotNull Map<String, Value> restrictions, @NotNull Map<String, Value[]> mvRestrictions) throws RepositoryException {
        for (RestrictionDefinition def : this.getRestrictionProvider().getSupportedRestrictions(this.getOakPath())) {
            boolean containsMandatory;
            String jcrName = this.getNamePathMapper().getJcrName(def.getName());
            if (!def.isMandatory() || (containsMandatory = def.getRequiredType().isArray() ? mvRestrictions.containsKey(jcrName) : restrictions.containsKey(jcrName))) continue;
            throw new AccessControlException("Mandatory restriction " + jcrName + " is missing.");
        }
        return this.computeRestrictions(effectiveOakPath, restrictions, mvRestrictions);
    }

    @NotNull
    private Set<Restriction> computeRestrictions(@Nullable String effectiveOakPath, @NotNull Map<String, Value> restrictions, @NotNull Map<String, Value[]> mvRestrictions) throws RepositoryException {
        Set<Restriction> rs;
        if (restrictions.isEmpty() && mvRestrictions.isEmpty()) {
            rs = Collections.emptySet();
        } else {
            RestrictionProvider rp = this.getRestrictionProvider();
            rs = new HashSet();
            for (Map.Entry<String, Value> entry : restrictions.entrySet()) {
                rs.add(rp.createRestriction(effectiveOakPath, this.getOakName(entry.getKey()), entry.getValue()));
            }
            for (Map.Entry<String, Value> entry : mvRestrictions.entrySet()) {
                rs.add(rp.createRestriction(effectiveOakPath, this.getOakName(entry.getKey()), (Value[])entry.getValue()));
            }
        }
        return rs;
    }

    @Nullable
    private String extractPathFromRestrictions(@Nullable Map<String, Value> restrictions, @NotNull String jcrName) throws RepositoryException {
        if (restrictions == null || !restrictions.containsKey(jcrName)) {
            throw new AccessControlException("Entries in principal based access control need to have a path specified. Add rep:nodePath restriction or use PrincipalAccessControlList.addEntry(String, Privilege[], Map, Map) instead.");
        }
        return Strings.emptyToNull((String)restrictions.get(jcrName).getString());
    }

    @NotNull
    private PrivilegeBits validatePrivileges(@NotNull Privilege[] privileges) throws RepositoryException {
        if (privileges.length == 0) {
            throw new AccessControlException("Privileges may not be an empty array");
        }
        for (Privilege p : privileges) {
            Privilege pv = this.privilegeManager.getPrivilege(p.getName());
            if (!pv.isAbstract()) continue;
            throw new AccessControlException("Privilege " + p + " is abstract.");
        }
        return this.privilegeBitsProvider.getBits(privileges, (NameMapper)this.getNamePathMapper());
    }

    @NotNull
    private static EntryImpl validateEntry(@Nullable AccessControlEntry entry) throws AccessControlException {
        if (entry instanceof EntryImpl) {
            return (EntryImpl)entry;
        }
        throw new AccessControlException("Invalid AccessControlEntry " + entry);
    }

    private boolean addEntry(@NotNull EntryImpl entry) {
        if (this.entries.contains((Object)entry)) {
            return false;
        }
        return this.entries.add(entry);
    }

    final class EntryImpl
    extends AbstractEntry {
        private EntryImpl(@NotNull String oakPath, @NotNull PrivilegeBits privilegeBits, Set<Restriction> restrictions) throws AccessControlException {
            super(oakPath, PrincipalPolicyImpl.this.principal, privilegeBits, restrictions, PrincipalPolicyImpl.this.getNamePathMapper());
        }

        public Privilege[] getPrivileges() {
            Set names = PrincipalPolicyImpl.this.privilegeBitsProvider.getPrivilegeNames(this.getPrivilegeBits());
            return Utils.privilegesFromOakNames(names, PrincipalPolicyImpl.this.privilegeManager, this.getNamePathMapper());
        }

        @Override
        @NotNull
        NamePathMapper getNamePathMapper() {
            return PrincipalPolicyImpl.this.getNamePathMapper();
        }
    }
}

