/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedPermissionProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

abstract class AbstractTreePermission
implements TreePermission {
    private final Tree tree;
    private final TreeType type;

    AbstractTreePermission(@NotNull Tree tree, @NotNull TreeType type) {
        this.tree = tree;
        this.type = type;
    }

    abstract PrincipalBasedPermissionProvider getPermissionProvider();

    @NotNull
    Tree getTree() {
        return this.tree;
    }

    @NotNull
    TreeType getType() {
        return this.type;
    }

    @NotNull
    public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
        return this.getPermissionProvider().getTreePermission(childName, childState, this);
    }

    public boolean canRead() {
        long permission = this.type == TreeType.ACCESS_CONTROL ? 128L : 1L;
        return this.getPermissionProvider().isGranted(this.tree, null, permission);
    }

    public boolean canRead(@NotNull PropertyState property) {
        long permission = this.type == TreeType.ACCESS_CONTROL ? 128L : 2L;
        return this.getPermissionProvider().isGranted(this.tree, property, permission);
    }

    public boolean canReadAll() {
        return false;
    }

    public boolean canReadProperties() {
        return false;
    }

    public boolean isGranted(long permissions) {
        return this.getPermissionProvider().isGranted(this.tree, null, permissions);
    }

    public boolean isGranted(long permissions, @NotNull PropertyState property) {
        return this.getPermissionProvider().isGranted(this.tree, property, permissions);
    }
}

