/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import com.google.common.base.Objects;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlList;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ImmutableACL;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalPolicyImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutablePrincipalPolicy
extends ImmutableACL
implements PrincipalAccessControlList {
    private final Principal principal;
    private int hashCode;

    public ImmutablePrincipalPolicy(@NotNull Principal principal, @NotNull String oakPath, @NotNull List<? extends PrincipalAccessControlList.Entry> entries, @NotNull RestrictionProvider restrictionProvider, @NotNull NamePathMapper namePathMapper) {
        super(oakPath, entries, restrictionProvider, namePathMapper);
        this.principal = principal;
    }

    public ImmutablePrincipalPolicy(@NotNull PrincipalPolicyImpl accessControlList) {
        super((AbstractAccessControlList)accessControlList);
        this.principal = accessControlList.getPrincipal();
    }

    @NotNull
    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean addEntry(@Nullable String effectivePath, @NotNull Privilege[] privileges) throws RepositoryException {
        throw new AccessControlException("Immutable PrincipalAccessControlList.");
    }

    public boolean addEntry(@Nullable String effectivePath, @NotNull Privilege[] privileges, @NotNull Map<String, Value> restrictions, @NotNull Map<String, Value[]> mvRestrictions) throws RepositoryException {
        throw new AccessControlException("Immutable PrincipalAccessControlList.");
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hashCode((Object[])new Object[]{this.principal, this.getOakPath(), this.getEntries()});
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutablePrincipalPolicy) {
            ImmutablePrincipalPolicy other = (ImmutablePrincipalPolicy)((Object)obj);
            return Objects.equal((Object)this.getOakPath(), (Object)other.getOakPath()) && this.principal.equals(other.principal) && this.getEntries().equals(other.getEntries());
        }
        return false;
    }
}

