/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.Filter;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Constants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Utils
implements Constants {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static boolean isPrincipalPolicyTree(@NotNull Tree tree) {
        return tree.exists() && "rep:principalPolicy".equals(tree.getName()) && "rep:PrincipalPolicy".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    public static boolean isPrincipalEntry(@NotNull Tree tree) {
        return "rep:PrincipalEntry".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    public static boolean canHandle(@NotNull Principal principal, @NotNull Filter filter, int importBehavior) throws AccessControlException {
        String name = principal.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            throw new AccessControlException("Invalid principal " + name);
        }
        boolean canHandle = filter.canHandle(Collections.singleton(principal));
        switch (importBehavior) {
            case 3: {
                if (canHandle) break;
                throw new AccessControlException("Unsupported principal " + name);
            }
            case 1: 
            case 2: {
                log.debug("Ignoring unsupported principal {}", (Object)name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported import behavior " + importBehavior);
            }
        }
        return canHandle;
    }

    public static Privilege[] privilegesFromOakNames(@NotNull Set<String> privilegeNames, @NotNull PrivilegeManager privilegeManager, @NotNull NamePathMapper namePathMapper) {
        return Collections2.filter((Collection)Collections2.transform(privilegeNames, privilegeName -> {
            try {
                return privilegeManager.getPrivilege(namePathMapper.getJcrName(privilegeName));
            }
            catch (RepositoryException e) {
                log.error("Unknown privilege in access control entry : {}", privilegeName);
                return null;
            }
        }), (Predicate)Predicates.notNull()).toArray(new Privilege[0]);
    }

    public static boolean hasModAcPermission(@NotNull PermissionProvider permissionProvider, @NotNull String effectivePath) {
        if ("".equals(effectivePath)) {
            return permissionProvider.getRepositoryPermission().isGranted(256L);
        }
        return permissionProvider.isGranted(effectivePath, Permissions.getString((long)256L));
    }

    public static boolean hasRestrictions(@NotNull Tree aceTree) {
        return aceTree.hasChild("rep:restrictions");
    }

    public static boolean hasValidRestrictions(@Nullable String oakPath, @NotNull Tree aceTree, @NotNull RestrictionProvider restrictionProvider) {
        if (Utils.hasRestrictions(aceTree)) {
            try {
                restrictionProvider.validateRestrictions(oakPath, aceTree);
                return true;
            }
            catch (RepositoryException e) {
                log.warn("Access control entry at {} contains unsupported restrictions: {}", (Object)oakPath, (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    public static Set<Restriction> readRestrictions(@NotNull RestrictionProvider provider, @Nullable String effectivePath, @NotNull Tree aceTree) {
        if (Utils.hasRestrictions(aceTree)) {
            return provider.readRestrictions(effectivePath, aceTree);
        }
        return Collections.emptySet();
    }
}

