/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.util.Collections;
import java.util.Iterator;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.EntryCache;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PermissionEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EntryIterator
extends AbstractLazyIterator<PermissionEntry> {
    private final Predicate<PermissionEntry> predicate;
    private final EntryCache entryCache;
    private Iterator<PermissionEntry> nextEntries = Collections.emptyIterator();
    private String nextPath;

    EntryIterator(@NotNull String path, @NotNull Predicate<PermissionEntry> predicate, @NotNull EntryCache entryCache) {
        this.nextPath = path;
        this.predicate = predicate;
        this.entryCache = entryCache;
    }

    protected PermissionEntry getNext() {
        PermissionEntry next = null;
        while (next == null) {
            if (this.nextEntries.hasNext()) {
                PermissionEntry pe = this.nextEntries.next();
                if (!this.predicate.apply((Object)pe)) continue;
                next = pe;
                continue;
            }
            if (this.nextPath == null) break;
            this.nextEntries = this.entryCache.getEntries(this.nextPath);
            this.nextPath = EntryIterator.getParentPathOrNull(this.nextPath);
        }
        return next;
    }

    @Nullable
    private static String getParentPathOrNull(@NotNull String path) {
        String parentPath = PathUtils.getParentPath((String)path);
        return path.equals(parentPath) ? null : parentPath;
    }
}

