/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.MgrProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedAuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.jetbrains.annotations.NotNull;

final class MgrProviderImpl
implements MgrProvider {
    private final PrincipalBasedAuthorizationConfiguration config;
    private NamePathMapper namePathMapper;
    private Root root;
    private Context ctx;
    private RestrictionProvider restrictionProvider;
    private PrincipalManager principalManager;
    private PrivilegeManager privilegeManager;
    private PrivilegeBitsProvider privilegeBitsProvider;

    MgrProviderImpl(@NotNull PrincipalBasedAuthorizationConfiguration config) {
        this.config = config;
        this.namePathMapper = NamePathMapper.DEFAULT;
    }

    MgrProviderImpl(@NotNull PrincipalBasedAuthorizationConfiguration config, @NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        this.config = config;
        this.reset(root, namePathMapper);
    }

    @Override
    @NotNull
    public SecurityProvider getSecurityProvider() {
        return this.config.getSecurityProvider();
    }

    @Override
    public void reset(@NotNull Root root, NamePathMapper namePathMapper) {
        this.root = root;
        this.namePathMapper = namePathMapper;
        this.ctx = null;
        this.restrictionProvider = null;
        this.principalManager = null;
        this.privilegeManager = null;
        this.privilegeBitsProvider = null;
    }

    @Override
    @NotNull
    public Root getRoot() {
        this.checkRootInitialized();
        return this.root;
    }

    @Override
    @NotNull
    public NamePathMapper getNamePathMapper() {
        return this.namePathMapper;
    }

    @Override
    @NotNull
    public Context getContext() {
        if (this.ctx == null) {
            this.ctx = ((AuthorizationConfiguration)this.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class)).getContext();
        }
        return this.ctx;
    }

    @Override
    @NotNull
    public PrivilegeManager getPrivilegeManager() {
        this.checkRootInitialized();
        if (this.privilegeManager == null) {
            this.privilegeManager = ((PrivilegeConfiguration)this.getSecurityProvider().getConfiguration(PrivilegeConfiguration.class)).getPrivilegeManager(this.root, this.namePathMapper);
        }
        return this.privilegeManager;
    }

    @Override
    @NotNull
    public PrivilegeBitsProvider getPrivilegeBitsProvider() {
        this.checkRootInitialized();
        if (this.privilegeBitsProvider == null) {
            this.privilegeBitsProvider = new PrivilegeBitsProvider(this.root);
        }
        return this.privilegeBitsProvider;
    }

    @Override
    @NotNull
    public PrincipalManager getPrincipalManager() {
        this.checkRootInitialized();
        if (this.principalManager == null) {
            this.principalManager = ((PrincipalConfiguration)this.getSecurityProvider().getConfiguration(PrincipalConfiguration.class)).getPrincipalManager(this.root, this.namePathMapper);
        }
        return this.principalManager;
    }

    @Override
    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        if (this.restrictionProvider == null) {
            this.restrictionProvider = ((AuthorizationConfiguration)this.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class)).getRestrictionProvider();
        }
        return this.restrictionProvider;
    }

    @Override
    @NotNull
    public TreeProvider getTreeProvider() {
        return this.config.getTreeProvider();
    }

    @Override
    @NotNull
    public RootProvider getRootProvider() {
        return this.config.getRootProvider();
    }

    private void checkRootInitialized() {
        Preconditions.checkState((this.root != null ? 1 : 0) != 0);
    }
}

