/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Constants;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PermissionEntry;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Utils;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EntryCache
implements Constants {
    private final RestrictionProvider restrictionProvider;
    private final PrivilegeBitsProvider bitsProvider;
    private final Map<String, List<PermissionEntry>> entries = new HashMap<String, List<PermissionEntry>>();

    EntryCache(@NotNull Root root, @NotNull Iterable<String> principalPathSet, @NotNull RestrictionProvider restrictionProvider) {
        this.restrictionProvider = restrictionProvider;
        this.bitsProvider = new PrivilegeBitsProvider(root);
        for (String principalPath : principalPathSet) {
            Tree policyTree = root.getTree(PathUtils.concat((String)principalPath, (String)"rep:principalPolicy"));
            if (!policyTree.exists()) continue;
            for (Tree child : policyTree.getChildren()) {
                if (!"rep:PrincipalEntry".equals(TreeUtil.getPrimaryTypeName((Tree)child))) continue;
                PermissionEntryImpl entry = new PermissionEntryImpl(child);
                String key = Strings.nullToEmpty((String)entry.effectivePath);
                List list = this.entries.computeIfAbsent(key, k -> new ArrayList());
                list.add(entry);
            }
        }
    }

    @NotNull
    Iterator<PermissionEntry> getEntries(@NotNull String path) {
        Iterable list = this.entries.get(path);
        return list == null ? Collections.emptyIterator() : list.iterator();
    }

    private final class PermissionEntryImpl
    implements PermissionEntry {
        private final String effectivePath;
        private final PrivilegeBits privilegeBits;
        private final RestrictionPattern pattern;

        private PermissionEntryImpl(Tree entryTree) {
            this.effectivePath = Strings.emptyToNull((String)TreeUtil.getString((Tree)entryTree, (String)"rep:effectivePath"));
            this.privilegeBits = EntryCache.this.bitsProvider.getBits((Iterable)entryTree.getProperty("rep:privileges").getValue(Type.NAMES));
            this.pattern = Utils.hasRestrictions(entryTree) ? EntryCache.this.restrictionProvider.getPattern(this.effectivePath, EntryCache.this.restrictionProvider.readRestrictions(this.effectivePath, entryTree)) : RestrictionPattern.EMPTY;
        }

        @Override
        @NotNull
        public PrivilegeBits getPrivilegeBits() {
            return this.privilegeBits;
        }

        @Override
        public boolean appliesTo(@NotNull String path) {
            return Text.isDescendantOrEqual((String)this.effectivePath, (String)path);
        }

        @Override
        public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
            return this.pattern.matches(tree, property);
        }

        @Override
        public boolean matches(@NotNull String oakPath) {
            return this.pattern.matches(oakPath);
        }

        @Override
        public boolean matches(@NotNull String oakPath, boolean isProperty) {
            return this.pattern.matches(oakPath, isProperty);
        }

        @Override
        public boolean matches() {
            return this.pattern.matches();
        }
    }
}

