/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeTypeRegistry;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregationFilter;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.EmptyPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.Filter;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.FilterProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.AggregationFilterImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.ContextImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.MgrProviderImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalPolicyImporter;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalPolicyValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={AuthorizationConfiguration.class, SecurityConfiguration.class}, property={"oak.security.name=org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedAuthorizationConfiguration"})
@Designate(ocd=Configuration.class)
public class PrincipalBasedAuthorizationConfiguration
extends ConfigurationBase
implements AuthorizationConfiguration {
    private FilterProvider filterProvider;
    private MountInfoProvider mountInfoProvider;
    private ServiceRegistration aggregationFilterRegistration;

    @NotNull
    public AccessControlManager getAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        return new PrincipalBasedAccessControlManager(new MgrProviderImpl(this, root, namePathMapper), this.filterProvider);
    }

    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        return (RestrictionProvider)this.getParameters().getConfigValue("restrictionProvider", (Object)RestrictionProvider.EMPTY, RestrictionProvider.class);
    }

    @NotNull
    public PermissionProvider getPermissionProvider(@NotNull Root root, @NotNull String workspaceName, @NotNull Set<Principal> principals) {
        Filter f = this.filterProvider.getFilter(this.getSecurityProvider(), this.getRootProvider().createReadOnlyRoot(root), NamePathMapper.DEFAULT);
        if (!f.canHandle(principals)) {
            return EmptyPermissionProvider.getInstance();
        }
        Iterable principalPaths = Iterables.transform(principals, f::getOakPath);
        return new PrincipalBasedPermissionProvider(root, workspaceName, principalPaths, this);
    }

    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.authorization";
    }

    @NotNull
    public RepositoryInitializer getRepositoryInitializer() {
        return builder -> {
            NodeState base = builder.getNodeState();
            MemoryNodeStore store = new MemoryNodeStore(base);
            Root root = this.getRootProvider().createSystemRoot((NodeStore)store, null);
            if (PrincipalBasedAuthorizationConfiguration.registerNodeTypes(root)) {
                NodeState target = store.getRoot();
                target.compareAgainstBaseState(base, (NodeStateDiff)new ApplyDiff(builder));
            }
        };
    }

    @NotNull
    public List<? extends CommitHook> getCommitHooks(@NotNull String workspaceName) {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        return ImmutableList.of((Object)new PrincipalPolicyValidatorProvider(new MgrProviderImpl(this), principals, workspaceName));
    }

    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.singletonList(new PrincipalPolicyImporter(this.filterProvider, new MgrProviderImpl(this)));
    }

    @NotNull
    public Context getContext() {
        return ContextImpl.INSTANCE;
    }

    @Activate
    public void activate(@NotNull BundleContext context, @NotNull Configuration configuration) {
        this.checkConflictingMount();
        this.setParameters(ConfigurationParameters.of((String)"configurationRanking", (Object)configuration.configurationRanking(), (String)"enableAggregationFilter", (Object)configuration.enableAggregationFilter()));
        if (configuration.enableAggregationFilter()) {
            this.registerAggregationFilter(context);
        } else {
            this.unregisterAggregationFilter();
        }
    }

    @Modified
    public void modified(@NotNull BundleContext context, @NotNull Configuration configuration) {
        this.activate(context, configuration);
    }

    @Deactivate
    public void deactivate(@NotNull BundleContext context, @NotNull Configuration configuration) {
        this.unregisterAggregationFilter();
    }

    @Reference(name="filterProvider", cardinality=ReferenceCardinality.MANDATORY)
    public void bindFilterProvider(@NotNull FilterProvider filterProvider) {
        this.filterProvider = filterProvider;
    }

    public void unbindFilterProvider(@NotNull FilterProvider filterProvider) {
        this.filterProvider = null;
    }

    @Reference(name="mountInfoProvider", cardinality=ReferenceCardinality.MANDATORY)
    public void bindMountInfoProvider(@NotNull MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    public void unbindMountInfoProvider(@NotNull MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = null;
    }

    private void checkConflictingMount() {
        String filterRoot = this.filterProvider.getFilterRoot();
        for (Mount mount : this.mountInfoProvider.getNonDefaultMounts()) {
            if (!mount.isUnder(filterRoot)) continue;
            throw new IllegalStateException("Mount found below filter root " + filterRoot);
        }
    }

    private static boolean registerNodeTypes(final @NotNull Root root) {
        block8: {
            boolean bl;
            block9: {
                ReadOnlyNodeTypeManager ntMgr = new ReadOnlyNodeTypeManager(){

                    @NotNull
                    protected Tree getTypes() {
                        return root.getTree("/jcr:system/jcr:nodeTypes");
                    }
                };
                if (ntMgr.hasNodeType("rep:PrincipalPolicy")) break block8;
                InputStream stream = PrincipalBasedAuthorizationConfiguration.class.getResourceAsStream("nodetypes.cnd");
                try {
                    NodeTypeRegistry.register((Root)root, (InputStream)stream, (String)"node types for principal based authorization");
                    bl = true;
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | RepositoryException e) {
                        throw new IllegalStateException("Unable to read node types for principal based authorization", e);
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    private void registerAggregationFilter(@NotNull BundleContext context) {
        if (this.aggregationFilterRegistration == null) {
            this.aggregationFilterRegistration = context.registerService(AggregationFilter.class.getName(), (Object)new AggregationFilterImpl(), new Hashtable());
        }
    }

    private void unregisterAggregationFilter() {
        if (this.aggregationFilterRegistration != null) {
            this.aggregationFilterRegistration.unregister();
            this.aggregationFilterRegistration = null;
        }
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak Principal Based AuthorizationConfiguration")
    static @interface Configuration {
        @AttributeDefinition(name="Ranking", description="Ranking of this configuration in a setup with multiple authorization configurations.")
        public int configurationRanking() default 500;

        @AttributeDefinition(name="Enable AggregationFilter", description="If enabled effective permission evaluation will stop after this module.")
        public boolean enableAggregationFilter() default false;
    }
}

