/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.Filter;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.FilterProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Constants;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.MgrProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalPolicyImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Utils;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.apache.jackrabbit.oak.spi.xml.NodeInfo;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.oak.spi.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrincipalPolicyImporter
implements ProtectedNodeImporter,
ProtectedPropertyImporter,
Constants {
    private static final Logger log = LoggerFactory.getLogger(PrincipalPolicyImporter.class);
    private Session session;
    private final MgrProvider mgrProvider;
    private final FilterProvider filterProvider;
    private Filter filter;
    private AuthorizationConfiguration authorizationConfiguration;
    private int importBehavior;
    private boolean initialized;
    private PrincipalPolicyImpl policy;
    private Entry entry;

    PrincipalPolicyImporter(@NotNull FilterProvider filterProvider, @NotNull MgrProvider mgrProvider) {
        this.filterProvider = filterProvider;
        this.mgrProvider = mgrProvider;
    }

    public boolean init(@NotNull Session session, @NotNull Root root, @NotNull NamePathMapper namePathMapper, boolean isWorkspaceImport, int uuidBehavior, @NotNull ReferenceChangeTracker referenceTracker, @NotNull SecurityProvider securityProvider) {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.session = session;
        this.mgrProvider.reset(root, namePathMapper);
        this.filter = this.filterProvider.getFilter(this.mgrProvider.getSecurityProvider(), root, namePathMapper);
        this.authorizationConfiguration = (AuthorizationConfiguration)securityProvider.getConfiguration(AuthorizationConfiguration.class);
        this.importBehavior = ImportBehavior.valueFromString((String)((String)this.authorizationConfiguration.getParameters().getConfigValue("importBehavior", (Object)"abort")));
        this.initialized = true;
        return this.initialized;
    }

    public void processReferences() {
    }

    public boolean handlePropInfo(@NotNull Tree parent, @NotNull PropInfo protectedPropInfo, @NotNull PropertyDefinition def) throws RepositoryException {
        Preconditions.checkState((boolean)this.initialized);
        if (!Utils.isPrincipalPolicyTree(parent) || !this.isValidPrincipalProperty(protectedPropInfo, def)) {
            return false;
        }
        String accessControlledPath = PathUtils.getParentPath((String)parent.getPath());
        if (!this.filterProvider.handlesPath(accessControlledPath)) {
            log.debug("Unable to import principal policy. Access controlled path '{}' outside of path supported by FilterProvider.", (Object)accessControlledPath);
            return false;
        }
        String principalName = protectedPropInfo.getTextValue().getString();
        Principal principal = this.filter.getValidPrincipal(accessControlledPath);
        if (principal == null) {
            log.debug("Unable to lookup principal by path = {}. Creating by name {}.", (Object)accessControlledPath, (Object)principalName);
            principal = new PrincipalImpl(principalName);
        } else if (!principalName.equals(principal.getName())) {
            log.error("Principal name mismatch expected '{}' but was '{}'.", (Object)principalName, (Object)principal.getName());
            throw new ConstraintViolationException("Principal name mismatch.");
        }
        if (!Utils.canHandle(principal, this.filter, this.importBehavior)) {
            log.debug("Cannot handle principal {} with name = {}", (Object)principal, (Object)principalName);
            return false;
        }
        this.session.checkPermission(accessControlledPath, Permissions.getString((long)128L));
        this.policy = new PrincipalPolicyImpl(principal, accessControlledPath, this.mgrProvider);
        return true;
    }

    public void propertiesCompleted(@NotNull Tree protectedParent) throws RepositoryException {
        Preconditions.checkState((boolean)this.initialized);
        if (this.policy != null) {
            if (PrincipalPolicyImporter.isValidProtectedParent(protectedParent, this.policy)) {
                this.getAccessControlManager().setPolicy(this.policy.getPath(), (AccessControlPolicy)this.policy);
            } else {
                log.warn("Protected parent {} does not match path of PrincipalAccessControlList {}.", (Object)protectedParent.getPath(), (Object)this.policy.getOakPath());
                this.getAccessControlManager().removePolicy(this.policy.getPath(), (AccessControlPolicy)this.policy);
            }
        }
    }

    public boolean start(@NotNull Tree protectedParent) {
        Preconditions.checkState((boolean)this.initialized);
        return this.policy != null && PrincipalPolicyImporter.isValidProtectedParent(protectedParent, this.policy);
    }

    public void end(@NotNull Tree protectedParent) throws RepositoryException {
        Preconditions.checkState((this.policy != null ? 1 : 0) != 0);
        if (PrincipalPolicyImporter.isValidProtectedParent(protectedParent, this.policy)) {
            this.getAccessControlManager().setPolicy(this.policy.getPath(), (AccessControlPolicy)this.policy);
        } else {
            log.warn("Protected parent {} does not match path of PrincipalAccessControlList {}.", (Object)protectedParent.getPath(), (Object)this.policy.getOakPath());
            this.getAccessControlManager().removePolicy(this.policy.getPath(), (AccessControlPolicy)this.policy);
        }
        this.policy = null;
    }

    public void startChildInfo(@NotNull NodeInfo childInfo, @NotNull List<PropInfo> propInfos) throws RepositoryException {
        Preconditions.checkState((this.policy != null ? 1 : 0) != 0);
        String ntName = this.getOakName(childInfo.getPrimaryTypeName());
        if ("rep:PrincipalEntry".equals(ntName)) {
            if (this.entry != null) {
                throw new ConstraintViolationException("Invalid child node sequence: Entries must not be nested.");
            }
            this.entry = new Entry(propInfos);
        } else if ("rep:Restrictions".equals(ntName)) {
            if (this.entry == null) {
                throw new ConstraintViolationException("Invalid child node sequence: Restriction must be associated with an Entry");
            }
            this.entry.addRestrictions(propInfos);
        } else {
            throw new ConstraintViolationException("Invalid child node '" + childInfo.getName() + "' with type " + ntName);
        }
    }

    public void endChildInfo() throws RepositoryException {
        Preconditions.checkState((this.policy != null ? 1 : 0) != 0);
        if (this.entry != null) {
            this.entry.applyTo(this.policy);
            this.entry = null;
        }
    }

    private boolean isValidPrincipalProperty(@NotNull PropInfo propertyInfo, @NotNull PropertyDefinition def) {
        return "rep:principalName".equals(this.getOakName(propertyInfo.getName())) && !def.isMultiple() && "rep:PrincipalPolicy".equals(this.getOakName(def.getDeclaringNodeType().getName()));
    }

    private static boolean isValidProtectedParent(@NotNull Tree protectedParent, @NotNull PrincipalPolicyImpl policy) {
        String accessControlledPath = PathUtils.getParentPath((String)protectedParent.getPath());
        return accessControlledPath.equals(policy.getOakPath());
    }

    @Nullable
    private String getOakName(@Nullable String name) {
        return name == null ? null : this.getNamePathMapper().getOakNameOrNull(name);
    }

    private AccessControlManager getAccessControlManager() {
        return this.authorizationConfiguration.getAccessControlManager(this.mgrProvider.getRoot(), this.mgrProvider.getNamePathMapper());
    }

    private NamePathMapper getNamePathMapper() {
        return this.mgrProvider.getNamePathMapper();
    }

    private final class Entry {
        private String effectivePath;
        private final Iterable<Privilege> privileges;
        private final Map<String, Value> restrictions = new HashMap<String, Value>();
        private final Map<String, Value[]> mvRestrictions = new HashMap<String, Value[]>();

        private Entry(List<PropInfo> propInfos) throws RepositoryException {
            List<Privilege> privs = null;
            for (PropInfo prop : propInfos) {
                String oakName = PrincipalPolicyImporter.this.getOakName(prop.getName());
                if ("rep:effectivePath".equals(oakName) && 8 == prop.getType()) {
                    this.effectivePath = this.extractEffectivePath(prop);
                    continue;
                }
                if ("rep:privileges".equals(oakName) && 7 == prop.getType()) {
                    privs = this.getPrivileges(Iterables.transform((Iterable)prop.getTextValues(), TextValue::getString));
                    continue;
                }
                throw new ConstraintViolationException("Unsupported property '" + oakName + "' with type " + prop.getType() + " within policy entry of type rep:PrincipalEntry");
            }
            if (privs == null) {
                throw new ConstraintViolationException("Entries for PrincipalAccessControlList must specify the privileges to be granted.");
            }
            this.privileges = privs;
        }

        private List<Privilege> getPrivileges(@NotNull Iterable<String> jcrPrivNames) throws RepositoryException {
            ArrayList<Privilege> privs = new ArrayList<Privilege>();
            PrivilegeManager privilegeManager = PrincipalPolicyImporter.this.mgrProvider.getPrivilegeManager();
            for (String privName : jcrPrivNames) {
                privs.add(privilegeManager.getPrivilege(privName));
            }
            return privs;
        }

        private void addRestrictions(@NotNull List<PropInfo> propInfos) throws RepositoryException {
            Preconditions.checkState((this.restrictions.isEmpty() && this.mvRestrictions.isEmpty() ? 1 : 0) != 0, (Object)"Multiple restriction nodes.");
            for (PropInfo prop : propInfos) {
                String restrictionName = prop.getName();
                if ("rep:nodePath".equals(PrincipalPolicyImporter.this.getOakName(restrictionName))) {
                    Preconditions.checkState((this.effectivePath == null ? 1 : 0) != 0, (Object)"Attempt to overwrite rep:effectivePath property with rep:nodePath restriction.");
                    log.debug("Extracting rep:effectivePath from rep:nodePath restriction.");
                    this.effectivePath = this.extractEffectivePath(prop);
                    continue;
                }
                int targetType = PrincipalPolicyImporter.this.policy.getRestrictionType(restrictionName);
                List values = prop.getValues(targetType);
                if (PrincipalPolicyImporter.this.policy.isMultiValueRestriction(restrictionName)) {
                    this.mvRestrictions.put(restrictionName, values.toArray(new Value[0]));
                    continue;
                }
                this.restrictions.put(restrictionName, (Value)values.get(0));
            }
        }

        private String extractEffectivePath(@NotNull PropInfo prop) throws RepositoryException {
            String ep = prop.getTextValue().getString();
            return PathUtils.denotesCurrent((String)ep) ? "" : ep;
        }

        private void applyTo(@NotNull PrincipalPolicyImpl policy) throws RepositoryException {
            if (this.effectivePath == null) {
                log.error("Missing rep:effectivePath for entry {} of policy at {}", (Object)this, (Object)policy.getOakPath());
                throw new ConstraintViolationException("Entries for PrincipalAccessControlList must specify an effective path.");
            }
            policy.addEntry(Strings.emptyToNull((String)this.effectivePath), (Privilege[])Iterables.toArray(this.privileges, Privilege.class), this.restrictions, this.mvRestrictions);
        }
    }
}

