/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.security.Principal;
import java.util.Objects;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ACE;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractEntry
extends ACE
implements PrincipalAccessControlList.Entry {
    private final String oakPath;
    private int hashCode;

    AbstractEntry(@Nullable String oakPath, @NotNull Principal principal, @NotNull PrivilegeBits privilegeBits, @NotNull Set<Restriction> restrictions, @NotNull NamePathMapper namePathMapper) throws AccessControlException {
        super(principal, privilegeBits, true, restrictions, namePathMapper);
        this.oakPath = oakPath;
    }

    @Nullable
    String getOakPath() {
        return this.oakPath;
    }

    @NotNull
    abstract NamePathMapper getNamePathMapper();

    @Nullable
    public String getEffectivePath() {
        return this.oakPath == null ? null : this.getNamePathMapper().getJcrPath(this.oakPath);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.oakPath, this.getPrincipal().getName(), this.getPrivilegeBits(), Boolean.TRUE, this.getRestrictions());
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractEntry) {
            AbstractEntry other = (AbstractEntry)((Object)obj);
            return this.equivalentPath(other.oakPath) && super.equals(obj);
        }
        return false;
    }

    private boolean equivalentPath(@Nullable String otherPath) {
        return this.oakPath == null ? otherPath == null : this.oakPath.equals(otherPath);
    }
}

