/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Constants;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Utils;
import org.jetbrains.annotations.NotNull;

final class ContextImpl
implements Context,
Constants {
    static final Context INSTANCE = new ContextImpl();
    private static final String[] NODE_NAMES = new String[]{"rep:principalPolicy", "rep:restrictions"};
    private static final String[] PROPERTY_NAMES = new String[]{"rep:principalName", "rep:effectivePath", "rep:privileges"};
    private static final String[] NT_NAMES = new String[]{"rep:PrincipalPolicy", "rep:PrincipalEntry", "rep:Restrictions"};

    private ContextImpl() {
    }

    public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
        return this.definesTree(parent);
    }

    public boolean definesContextRoot(@NotNull Tree tree) {
        return Utils.isPrincipalPolicyTree(tree);
    }

    public boolean definesTree(@NotNull Tree tree) {
        return tree.exists() && (ContextImpl.isNodeName(tree.getName()) || ContextImpl.isNtName(tree));
    }

    public boolean definesLocation(@NotNull TreeLocation location) {
        Tree tree;
        PropertyState p = location.getProperty();
        Tree tree2 = tree = p == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            return p == null ? this.definesTree(tree) : this.definesProperty(tree, p);
        }
        if (ContextImpl.isItemName(location.getName())) {
            return true;
        }
        TreeLocation parent = location.getParent();
        String parentName = parent.getName();
        return "rep:principalPolicy".equals(parentName) || "rep:restrictions".equals(parentName);
    }

    public boolean definesInternal(@NotNull Tree tree) {
        return false;
    }

    private static boolean isNodeName(@NotNull String name) {
        for (String n : NODE_NAMES) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPropertyName(@NotNull String name) {
        for (String n : PROPERTY_NAMES) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isItemName(@NotNull String name) {
        return ContextImpl.isNodeName(name) || ContextImpl.isPropertyName(name);
    }

    private static boolean isNtName(@NotNull Tree tree) {
        String ntName = TreeUtil.getPrimaryTypeName((Tree)tree);
        for (String n : NT_NAMES) {
            if (!n.equals(ntName)) continue;
            return true;
        }
        return false;
    }
}

