/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PermissionEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EntryPredicate {
    private EntryPredicate() {
    }

    @NotNull
    protected static Predicate<PermissionEntry> ALWAYS_FALSE() {
        return x -> false;
    }

    @NotNull
    static Predicate<PermissionEntry> create() {
        return permissionEntry -> permissionEntry.matches();
    }

    @NotNull
    static Predicate<PermissionEntry> create(@NotNull String oakPath) {
        return permissionEntry -> permissionEntry.matches(oakPath);
    }

    @NotNull
    static Predicate<PermissionEntry> create(@NotNull String oakPath, boolean isProperty) {
        return permissionEntry -> permissionEntry.matches(oakPath, isProperty);
    }

    @NotNull
    static Predicate<PermissionEntry> create(@NotNull Tree tree, @Nullable PropertyState property) {
        if (!tree.exists()) {
            String predicatePath = property == null ? tree.getPath() : PathUtils.concat((String)tree.getPath(), (String)property.getName());
            return EntryPredicate.create(predicatePath, property != null);
        }
        return permissionEntry -> permissionEntry.matches(tree, property);
    }

    @NotNull
    static Predicate<PermissionEntry> createParent(@NotNull String treePath, @Nullable Tree parentTree, long permissions) {
        if (!Permissions.respectParentPermissions((long)permissions)) {
            return EntryPredicate.ALWAYS_FALSE();
        }
        if (treePath.isEmpty() || PathUtils.denotesRoot((String)treePath)) {
            return EntryPredicate.ALWAYS_FALSE();
        }
        if (parentTree != null && parentTree.exists()) {
            return permissionEntry -> permissionEntry.appliesTo(parentTree.getPath()) && permissionEntry.matches(parentTree, null);
        }
        String parentPath = PathUtils.getParentPath((String)treePath);
        return permissionEntry -> permissionEntry.appliesTo(parentPath) && permissionEntry.matches(parentPath, false);
    }

    @NotNull
    static Predicate<PermissionEntry> createParent(@NotNull Tree tree, long permissions) {
        if (!Permissions.respectParentPermissions((long)permissions)) {
            return EntryPredicate.ALWAYS_FALSE();
        }
        if (!tree.exists()) {
            return EntryPredicate.createParent(tree.getPath(), tree.getParent(), permissions);
        }
        if (!tree.isRoot()) {
            Tree parentTree = tree.getParent();
            return permissionEntry -> permissionEntry.appliesTo(parentTree.getPath()) && permissionEntry.matches(parentTree, null);
        }
        return EntryPredicate.ALWAYS_FALSE();
    }
}

