/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.QueryUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ReadPolicy;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.Filter;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.FilterProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.AbstractEntry;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Constants;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.ImmutablePrincipalPolicy;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.MgrProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalPolicyImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Utils;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.apache.jackrabbit.util.ISO9075;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrincipalBasedAccessControlManager
extends AbstractAccessControlManager
implements PolicyOwner,
Constants {
    private static final Logger log = LoggerFactory.getLogger(PrincipalBasedAccessControlManager.class);
    private final MgrProvider mgrProvider;
    private final int importBehavior;
    private final Set<String> readPaths;
    private final PrincipalManager principalManager;
    private final PrivilegeBitsProvider privilegeBitsProvider;
    private final FilterProvider filterProvider;
    private final Filter filter;

    PrincipalBasedAccessControlManager(@NotNull MgrProvider mgrProvider, @NotNull FilterProvider filterProvider) {
        super(mgrProvider.getRoot(), mgrProvider.getNamePathMapper(), mgrProvider.getSecurityProvider());
        this.mgrProvider = mgrProvider;
        ConfigurationParameters configParams = this.getConfig().getParameters();
        this.importBehavior = ImportBehavior.valueFromString((String)((String)configParams.getConfigValue("importBehavior", (Object)"abort")));
        this.readPaths = (Set)configParams.getConfigValue("readPaths", (Object)PermissionConstants.DEFAULT_READ_PATHS);
        this.principalManager = mgrProvider.getPrincipalManager();
        this.privilegeBitsProvider = mgrProvider.getPrivilegeBitsProvider();
        this.filterProvider = filterProvider;
        this.filter = filterProvider.getFilter(mgrProvider.getSecurityProvider(), mgrProvider.getRoot(), mgrProvider.getNamePathMapper());
    }

    @NotNull
    protected PrivilegeBitsProvider getPrivilegeBitsProvider() {
        return this.mgrProvider.getPrivilegeBitsProvider();
    }

    @NotNull
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(@NotNull Principal principal) throws RepositoryException {
        String oakPath;
        Tree tree;
        if (this.canHandle(principal) && !(tree = this.getTree(oakPath = this.filter.getOakPath(principal), 128L, true)).hasChild("rep:principalPolicy")) {
            return new JackrabbitAccessControlPolicy[]{new PrincipalPolicyImpl(principal, oakPath, this.mgrProvider)};
        }
        return new JackrabbitAccessControlPolicy[0];
    }

    @NotNull
    public JackrabbitAccessControlPolicy[] getPolicies(@NotNull Principal principal) throws RepositoryException {
        JackrabbitAccessControlPolicy[] jackrabbitAccessControlPolicyArray;
        JackrabbitAccessControlPolicy policy = null;
        if (this.canHandle(principal)) {
            policy = this.createPolicy(principal, false, Collections.emptyList());
        }
        if (policy == null) {
            jackrabbitAccessControlPolicyArray = new JackrabbitAccessControlPolicy[]{};
        } else {
            JackrabbitAccessControlPolicy[] jackrabbitAccessControlPolicyArray2 = new JackrabbitAccessControlPolicy[1];
            jackrabbitAccessControlPolicyArray = jackrabbitAccessControlPolicyArray2;
            jackrabbitAccessControlPolicyArray2[0] = policy;
        }
        return jackrabbitAccessControlPolicyArray;
    }

    @NotNull
    public AccessControlPolicy[] getEffectivePolicies(@NotNull Set<Principal> principals) throws RepositoryException {
        if (this.canHandle(principals)) {
            ArrayList<Object> effective = new ArrayList<Object>(principals.size());
            for (Principal principal : principals) {
                JackrabbitAccessControlPolicy policy = this.createPolicy(principal, true, Collections.emptyList());
                if (policy == null) continue;
                effective.add(policy);
            }
            if (ReadPolicy.canAccessReadPolicy((PermissionProvider)this.getPermissionProvider(), (String[])this.readPaths.toArray(new String[0]))) {
                effective.add(ReadPolicy.INSTANCE);
            }
            return effective.toArray(new AccessControlPolicy[0]);
        }
        return new JackrabbitAccessControlPolicy[0];
    }

    @NotNull
    public Iterator<AccessControlPolicy> getEffectivePolicies(@NotNull Set<Principal> principals, String ... absPaths) throws RepositoryException {
        if (this.canHandle(principals)) {
            boolean hasReadPolicy;
            Collection oakPaths = this.getOakPaths(absPaths);
            ArrayList<Object> effective = new ArrayList<Object>(principals.size());
            for (Principal principal : principals) {
                JackrabbitAccessControlPolicy policy = this.createPolicy(principal, true, oakPaths);
                if (policy == null) continue;
                effective.add(policy);
            }
            boolean bl = hasReadPolicy = oakPaths.isEmpty() || oakPaths.stream().anyMatch(p -> ReadPolicy.hasEffectiveReadPolicy(this.readPaths, (String)p));
            if (hasReadPolicy) {
                effective.add(ReadPolicy.INSTANCE);
            }
            return effective.iterator();
        }
        return Collections.emptyIterator();
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
        this.getTree(this.getOakPath(absPath), 128L, true);
        log.debug("Editing access control policies by path is not supported. Use JackrabbitAccessControlManager.getPolicies(Principal principal)");
        return new AccessControlPolicy[0];
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        this.getTree(oakPath, 128L, true);
        StringBuilder stmt = new StringBuilder("/jcr:root");
        stmt.append(this.filterProvider.getFilterRoot());
        stmt.append("//element(*,").append("rep:PrincipalEntry").append(")[");
        String cond = "";
        for (String effectivePath : PrincipalBasedAccessControlManager.getEffectivePaths(oakPath)) {
            stmt.append(cond);
            stmt.append("@").append(ISO9075.encode((String)"rep:effectivePath"));
            stmt.append("='").append(QueryUtils.escapeForQuery((String)effectivePath));
            stmt.append("'");
            cond = " or ";
        }
        stmt.append("] order by jcr:path option (traversal ok)");
        try {
            QueryEngine queryEngine = this.getLatestRoot().getQueryEngine();
            Result result = queryEngine.executeQuery(stmt.toString(), "xpath", QueryEngine.NO_BINDINGS, QueryEngine.NO_MAPPINGS);
            HashMap<Principal, List> m = new HashMap<Principal, List>();
            for (ResultRow row : result.getRows()) {
                Tree entryTree = row.getTree(null);
                AbstractEntry entry2 = this.createEffectiveEntry(entryTree);
                if (entry2 == null) continue;
                List entries = m.computeIfAbsent(entry2.getPrincipal(), s -> new ArrayList());
                entries.add(entry2);
            }
            Iterable acls = Iterables.transform(m.entrySet(), entry -> new ImmutablePrincipalPolicy((Principal)entry.getKey(), this.filter.getOakPath((Principal)entry.getKey()), (List)entry.getValue(), this.mgrProvider.getRestrictionProvider(), this.getNamePathMapper()));
            if (ReadPolicy.hasEffectiveReadPolicy(this.readPaths, (String)oakPath)) {
                Iterable iterable = Iterables.concat((Iterable)acls, Collections.singleton(ReadPolicy.INSTANCE));
                return (AccessControlPolicy[])Iterables.toArray((Iterable)iterable, AccessControlPolicy.class);
            }
            return (AccessControlPolicy[])Iterables.toArray((Iterable)acls, PrincipalAccessControlList.class);
        }
        catch (ParseException e) {
            String msg = "Error while collecting effective policies at " + absPath;
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        this.getTree(this.getOakPath(absPath), 128L, true);
        log.debug("Editing access control policies by path is not supported. Use JackrabbitAccessControlManager.getApplicablePolicies(Principal principal)");
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        PrincipalPolicyImpl pp = this.checkValidPolicy(absPath, policy);
        String oakPath = pp.getOakPath();
        Tree tree = this.getTree(oakPath, 256L, true);
        Tree policyTree = PrincipalBasedAccessControlManager.getPolicyTree(tree);
        if (policyTree.exists()) {
            policyTree.remove();
        }
        TreeUtil.addMixin((Tree)tree, (String)"rep:PrincipalBasedMixin", (Tree)this.getRoot().getTree("/jcr:system/jcr:nodeTypes"), (String)this.getRoot().getContentSession().getAuthInfo().getUserID());
        policyTree = TreeUtil.addChild((Tree)tree, (String)"rep:principalPolicy", (String)"rep:PrincipalPolicy");
        policyTree.setOrderableChildren(true);
        policyTree.setProperty("rep:principalName", (Object)pp.getPrincipal().getName());
        int i = 0;
        RestrictionProvider restrictionProvider = this.mgrProvider.getRestrictionProvider();
        for (PrincipalPolicyImpl.EntryImpl entry : pp.getEntries()) {
            String effectiveOakPath = Objects.toString(entry.getOakPath(), "");
            Tree entryTree = TreeUtil.addChild((Tree)policyTree, (String)("entry" + i++), (String)"rep:PrincipalEntry");
            if (!Utils.hasModAcPermission(this.getPermissionProvider(), effectiveOakPath)) {
                throw new AccessDeniedException("Access denied.");
            }
            entryTree.setProperty("rep:effectivePath", (Object)effectiveOakPath, Type.PATH);
            entryTree.setProperty("rep:privileges", (Object)this.privilegeBitsProvider.getPrivilegeNames(entry.getPrivilegeBits()), Type.NAMES);
            restrictionProvider.writeRestrictions(oakPath, entryTree, entry.getRestrictions());
        }
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        PrincipalPolicyImpl pp = this.checkValidPolicy(absPath, policy);
        Tree policyTree = PrincipalBasedAccessControlManager.getPolicyTree(this.getTree(pp.getOakPath(), 256L, true));
        if (policyTree.exists()) {
            for (Tree child : policyTree.getChildren()) {
                if (!Utils.isPrincipalEntry(child)) continue;
                PropertyState effectivePath = child.getProperty("rep:effectivePath");
                if (effectivePath == null) {
                    throw new AccessControlException("Missing mandatory property rep:effectivePath; cannot validate permissions to modify policy.");
                }
                if (Utils.hasModAcPermission(this.getPermissionProvider(), (String)effectivePath.getValue(Type.PATH))) continue;
                throw new AccessDeniedException("Access denied.");
            }
        } else {
            throw new AccessControlException("No policy to remove at " + absPath);
        }
        policyTree.remove();
    }

    public boolean defines(@Nullable String absPath, @NotNull AccessControlPolicy accessControlPolicy) {
        String oakPath;
        String string = oakPath = absPath == null ? null : this.getNamePathMapper().getOakPath(absPath);
        if (oakPath == null || !this.filterProvider.handlesPath(oakPath) || !(accessControlPolicy instanceof PrincipalPolicyImpl)) {
            return false;
        }
        return oakPath.equals(((PrincipalPolicyImpl)accessControlPolicy).getOakPath());
    }

    private boolean canHandle(@Nullable Principal principal) throws AccessControlException {
        String name;
        String string = name = principal == null ? null : principal.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            throw new AccessControlException("Invalid principal " + name);
        }
        if ((this.importBehavior == 3 || this.importBehavior == 1) && (principal = this.principalManager.getPrincipal(name)) == null) {
            if (this.importBehavior == 1) {
                log.debug("Ignoring unknown principal {}", (Object)name);
                return false;
            }
            throw new AccessControlException("Unsupported principal " + name);
        }
        return this.filter.canHandle(Collections.singleton(principal));
    }

    boolean canHandle(@NotNull Set<Principal> principals) throws AccessControlException {
        for (Principal principal : principals) {
            if (this.canHandle(principal)) continue;
            return false;
        }
        return true;
    }

    private PrincipalPolicyImpl checkValidPolicy(@Nullable String absPath, @NotNull AccessControlPolicy policy) throws AccessControlException {
        if (!this.defines(absPath, policy)) {
            throw new AccessControlException("Invalid policy " + policy + " at path " + absPath);
        }
        return (PrincipalPolicyImpl)policy;
    }

    @NotNull
    private static Tree getPolicyTree(@NotNull Tree accessControlledTree) {
        return accessControlledTree.getChild("rep:principalPolicy");
    }

    @Nullable
    private JackrabbitAccessControlPolicy createPolicy(@NotNull Principal principal, boolean isEffectivePolicy, @NotNull Collection<String> oakPaths) throws RepositoryException {
        String oakPath = this.filter.getOakPath(principal);
        Tree tree = this.getTree(oakPath, 128L, true);
        if (isEffectivePolicy) {
            Root r = this.getRoot().getContentSession().getLatestRoot();
            tree = r.getTree(tree.getPath());
        }
        if (!this.isAccessControlled(tree)) {
            return null;
        }
        PrincipalPolicyImpl policy = null;
        Tree policyTree = PrincipalBasedAccessControlManager.getPolicyTree(tree);
        if (Utils.isPrincipalPolicyTree(policyTree)) {
            policy = new PrincipalPolicyImpl(principal, oakPath, this.mgrProvider);
            for (Tree child : policyTree.getChildren()) {
                if (!Utils.isPrincipalEntry(child)) continue;
                policy.addEntry(child, oakPaths);
            }
        }
        if (isEffectivePolicy && policy != null) {
            return policy.isEmpty() ? null : new ImmutablePrincipalPolicy(policy);
        }
        return policy;
    }

    private boolean isAccessControlled(@NotNull Tree tree) {
        Tree typeRoot = this.getRoot().getTree("/jcr:system/jcr:nodeTypes");
        return tree.exists() && TreeUtil.isNodeType((Tree)tree, (String)"rep:PrincipalBasedMixin", (Tree)typeRoot);
    }

    private static Iterable<String> getEffectivePaths(@Nullable String oakPath) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(Objects.toString(oakPath, ""));
        String effectivePath = oakPath;
        while (effectivePath != null && !PathUtils.denotesRoot((String)effectivePath)) {
            effectivePath = PathUtils.getParentPath((String)effectivePath);
            paths.add(effectivePath);
        }
        return paths;
    }

    @Nullable
    private AbstractEntry createEffectiveEntry(@NotNull Tree entryTree) throws AccessControlException {
        String principalName = TreeUtil.getString((Tree)entryTree.getParent(), (String)"rep:principalName");
        Principal principal = this.principalManager.getPrincipal(principalName);
        if (principal == null || !this.filter.canHandle(Collections.singleton(principal))) {
            return null;
        }
        String oakPath = Strings.emptyToNull((String)TreeUtil.getString((Tree)entryTree, (String)"rep:effectivePath"));
        PrivilegeBits bits = this.privilegeBitsProvider.getBits((Iterable)entryTree.getProperty("rep:privileges").getValue(Type.NAMES));
        RestrictionProvider rp = this.mgrProvider.getRestrictionProvider();
        if (!Utils.hasValidRestrictions(oakPath, entryTree, rp)) {
            return null;
        }
        Set<Restriction> restrictions = Utils.readRestrictions(rp, oakPath, entryTree);
        final NamePathMapper npMapper = this.getNamePathMapper();
        return new AbstractEntry(oakPath, principal, bits, restrictions, npMapper){

            @Override
            @NotNull
            NamePathMapper getNamePathMapper() {
                return npMapper;
            }

            @NotNull
            protected PrivilegeBitsProvider getPrivilegeBitsProvider() {
                return PrincipalBasedAccessControlManager.this.privilegeBitsProvider;
            }

            public Privilege[] getPrivileges() {
                Set names = PrincipalBasedAccessControlManager.this.privilegeBitsProvider.getPrivilegeNames(this.getPrivilegeBits());
                return Utils.privilegesFromOakNames(names, PrincipalBasedAccessControlManager.this.mgrProvider.getPrivilegeManager(), this.getNamePathMapper());
            }
        };
    }
}

