/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.ReadOnly;
import org.apache.jackrabbit.oak.plugins.tree.TreeContext;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.TreeTypeProvider;
import org.apache.jackrabbit.oak.plugins.version.ReadOnlyVersionManager;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.AbstractTreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Constants;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.EntryCache;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.EntryIterator;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.EntryPredicate;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.MgrProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.MgrProviderImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PermissionEntry;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedAuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Utils;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrincipalBasedPermissionProvider
implements AggregatedPermissionProvider,
Constants {
    private static final Logger log = LoggerFactory.getLogger(PrincipalBasedPermissionProvider.class);
    private final Root root;
    private final String workspaceName;
    private final Iterable<String> principalPaths;
    private final MgrProvider mgrProvider;
    private final TreeTypeProvider typeProvider;
    private final PrivilegeBits modAcBits;
    private Root immutableRoot;
    private RepositoryPermissionImpl repositoryPermission;
    private EntryCache entryCache;
    private ReadablePaths readablePaths;

    PrincipalBasedPermissionProvider(@NotNull Root root, @NotNull String workspaceName, @NotNull Iterable<String> principalPaths, @NotNull PrincipalBasedAuthorizationConfiguration authorizationConfiguration) {
        this.root = root;
        this.workspaceName = workspaceName;
        this.principalPaths = principalPaths;
        this.immutableRoot = authorizationConfiguration.getRootProvider().createReadOnlyRoot(root);
        this.mgrProvider = new MgrProviderImpl(authorizationConfiguration, this.immutableRoot, NamePathMapper.DEFAULT);
        this.typeProvider = new TreeTypeProvider((TreeContext)this.mgrProvider.getContext());
        this.modAcBits = this.mgrProvider.getPrivilegeBitsProvider().getBits(new String[]{"jcr:modifyAccessControl"});
        this.entryCache = new EntryCache(this.immutableRoot, principalPaths, this.mgrProvider.getRestrictionProvider());
        this.readablePaths = new ReadablePaths(this.mgrProvider);
    }

    public void refresh() {
        this.immutableRoot = this.mgrProvider.getRootProvider().createReadOnlyRoot(this.root);
        this.mgrProvider.reset(this.immutableRoot, NamePathMapper.DEFAULT);
        this.entryCache = new EntryCache(this.immutableRoot, this.principalPaths, this.mgrProvider.getRestrictionProvider());
        if (this.repositoryPermission != null) {
            this.repositoryPermission.refresh();
        }
        this.readablePaths = new ReadablePaths(this.mgrProvider);
    }

    @NotNull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        return this.mgrProvider.getPrivilegeBitsProvider().getPrivilegeNames(this.getGrantedPrivilegeBits(tree));
    }

    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        return this.getGrantedPrivilegeBits(tree).includes(this.mgrProvider.getPrivilegeBitsProvider().getBits(privilegeNames));
    }

    @NotNull
    public RepositoryPermission getRepositoryPermission() {
        if (this.repositoryPermission == null) {
            this.repositoryPermission = new RepositoryPermissionImpl();
        }
        return this.repositoryPermission;
    }

    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreePermission parentPermission) {
        Tree readOnly = this.getReadOnlyTree(tree);
        TreeType parentType = parentPermission instanceof AbstractTreePermission ? ((AbstractTreePermission)parentPermission).getType() : (tree.isRoot() ? TreeType.DEFAULT : this.typeProvider.getType(tree.getParent()));
        return this.getTreePermission(readOnly, this.typeProvider.getType(readOnly, parentType), parentPermission);
    }

    public boolean isGranted(@NotNull Tree tree, @Nullable PropertyState property, long permissions) {
        Tree readOnly = this.getReadOnlyTree(tree);
        TreeType type = this.typeProvider.getType(readOnly);
        switch (type) {
            case HIDDEN: {
                return true;
            }
            case INTERNAL: {
                return false;
            }
            case VERSION: {
                if (PrincipalBasedPermissionProvider.isVersionStoreTree(readOnly)) break;
                Tree versionableTree = this.getVersionableTree(readOnly);
                if (versionableTree == null) {
                    return false;
                }
                readOnly = versionableTree;
                break;
            }
            case ACCESS_CONTROL: {
                if (this.isGrantedOnEffective(readOnly, permissions)) break;
                return false;
            }
        }
        return this.isGranted(readOnly.getPath(), EntryPredicate.create(readOnly, property), EntryPredicate.createParent(readOnly, permissions), permissions);
    }

    public boolean isGranted(@NotNull String oakPath, @NotNull String jcrActions) {
        TreeLocation location = TreeLocation.create((Root)this.immutableRoot, (String)oakPath);
        boolean isAcContent = this.mgrProvider.getContext().definesLocation(location);
        long permissions = Permissions.getPermissions((String)jcrActions, (TreeLocation)location, (boolean)isAcContent);
        return this.isGranted(location, permissions);
    }

    @NotNull
    public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
        return privilegeBits != null ? privilegeBits : new PrivilegeBitsProvider(this.immutableRoot).getBits(new String[]{"jcr:all"});
    }

    public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
        return permissions;
    }

    public long supportedPermissions(@NotNull TreeLocation location, long permissions) {
        return permissions;
    }

    public long supportedPermissions(@NotNull TreePermission treePermission, @Nullable PropertyState property, long permissions) {
        return permissions;
    }

    public boolean isGranted(@NotNull TreeLocation location, long permissions) {
        boolean isGranted = false;
        PropertyState property = location.getProperty();
        TreeLocation tl = property == null ? location : location.getParent();
        Tree tree = tl.getTree();
        String oakPath = location.getPath();
        if (tree != null) {
            isGranted = this.isGranted(tree, property, permissions);
        } else if (!oakPath.startsWith("/jcr:system/jcr:versionStorage")) {
            Predicate<PermissionEntry> parentPredicate = EntryPredicate.createParent(tl.getPath(), tl.getParent().getTree(), permissions);
            isGranted = this.isGranted(oakPath, EntryPredicate.create(oakPath), parentPredicate, permissions);
        } else {
            log.debug("Cannot determine permissions for non-existing location {} below the version storage", (Object)location);
        }
        return isGranted;
    }

    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreePermission parentPermission) {
        Tree readOnly = this.getReadOnlyTree(tree);
        if (readOnly.isRoot()) {
            return new RegularTreePermission(readOnly, TreeType.DEFAULT);
        }
        switch (type) {
            case HIDDEN: {
                return TreePermission.ALL;
            }
            case INTERNAL: {
                return TreePermission.EMPTY;
            }
            case VERSION: {
                if (!PrincipalBasedPermissionProvider.isVersionStoreTree(readOnly)) {
                    if (parentPermission instanceof VersionTreePermission) {
                        return parentPermission.getChildPermission(readOnly.getName(), this.mgrProvider.getTreeProvider().asNodeState(readOnly));
                    }
                    Tree versionableTree = this.getVersionableTree(readOnly);
                    if (versionableTree == null) {
                        log.warn("Cannot retrieve versionable node for {}", (Object)readOnly.getPath());
                        return TreePermission.EMPTY;
                    }
                    return new VersionTreePermission(readOnly, versionableTree);
                }
                return new RegularTreePermission(readOnly, type);
            }
        }
        return new RegularTreePermission(readOnly, type);
    }

    private Iterator<PermissionEntry> getEntryIterator(@NotNull String path, @NotNull Predicate<PermissionEntry> predicate) {
        return new EntryIterator(path, predicate, this.entryCache);
    }

    private boolean isGranted(@NotNull String path, @NotNull Predicate<PermissionEntry> predicate, @NotNull Predicate<PermissionEntry> parentPredicate, long permissions) {
        long allows = 0L;
        if (this.readablePaths.isReadable(path) && PrincipalBasedPermissionProvider.isGranted(allows = 3L, permissions)) {
            return true;
        }
        PrivilegeBits bits = PrivilegeBits.getInstance();
        PrivilegeBits parentBits = PrivilegeBits.getInstance();
        Iterator<PermissionEntry> it = this.getEntryIterator(path, x -> true);
        while (it.hasNext()) {
            PermissionEntry entry = it.next();
            PrivilegeBits entryBits = entry.getPrivilegeBits();
            if (parentPredicate.test(entry)) {
                parentBits.add(entryBits);
            }
            if (predicate.test(entry)) {
                bits.add(entryBits);
            }
            if (!PrincipalBasedPermissionProvider.isGranted(allows |= PrivilegeBits.calculatePermissions((PrivilegeBits)bits, (PrivilegeBits)parentBits, (boolean)true), permissions)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGranted(long allows, long permissions) {
        return (allows | permissions ^ 0xFFFFFFFFFFFFFFFFL) == -1L;
    }

    private boolean isGrantedOnEffective(@NotNull Tree tree, long permission) {
        long toTest = permission & 0x100L;
        if (0L == toTest) {
            return Boolean.TRUE;
        }
        String effectivePath = PrincipalBasedPermissionProvider.getEffectivePath(tree);
        if (effectivePath == null) {
            return Boolean.TRUE;
        }
        if ("".equals(effectivePath)) {
            return this.getRepositoryPermission().isGranted(toTest);
        }
        Tree effectiveTree = this.immutableRoot.getTree(effectivePath);
        return this.isGranted(effectiveTree, null, toTest);
    }

    @NotNull
    private PrivilegeBits getGrantedPrivilegeBits(@Nullable Tree tree) {
        Predicate<PermissionEntry> predicate;
        String oakPath;
        Tree readOnly = tree == null ? null : this.getReadOnlyTree(tree);
        PrivilegeBits subtract = PrivilegeBits.EMPTY;
        if (readOnly != null) {
            TreeType type = this.typeProvider.getType(readOnly);
            switch (type) {
                case HIDDEN: 
                case INTERNAL: {
                    return PrivilegeBits.EMPTY;
                }
                case VERSION: {
                    if (PrincipalBasedPermissionProvider.isVersionStoreTree(readOnly)) break;
                    Tree versionableTree = this.getVersionableTree(readOnly);
                    if (versionableTree == null) {
                        return PrivilegeBits.EMPTY;
                    }
                    readOnly = versionableTree;
                    break;
                }
                case ACCESS_CONTROL: {
                    subtract = this.getBitsToSubtract(readOnly);
                    break;
                }
            }
        }
        if (readOnly == null) {
            oakPath = "";
            predicate = EntryPredicate.create();
        } else {
            oakPath = readOnly.getPath();
            predicate = EntryPredicate.create(readOnly, null);
        }
        PrivilegeBits granted = this.getGrantedPrivilegeBits(oakPath, predicate);
        return subtract.isEmpty() ? granted : granted.diff(subtract);
    }

    @NotNull
    PrivilegeBits getBitsToSubtract(@NotNull Tree tree) {
        String effectivePath = PrincipalBasedPermissionProvider.getEffectivePath(tree);
        if (effectivePath == null) {
            return PrivilegeBits.EMPTY;
        }
        return this.modAcBits.modifiable().diff(this.getGrantedPrivilegeBits(effectivePath, EntryPredicate.create(effectivePath, false)));
    }

    @NotNull
    private PrivilegeBits getGrantedPrivilegeBits(@NotNull String oakPath, @NotNull Predicate<PermissionEntry> predicate) {
        PrivilegeBits pb = PrivilegeBits.getInstance();
        Iterator<PermissionEntry> entries = this.getEntryIterator(oakPath, predicate);
        while (entries.hasNext()) {
            pb.add(entries.next().getPrivilegeBits());
        }
        if (!pb.includes(this.readablePaths.readBits) && this.readablePaths.isReadable(oakPath)) {
            pb.add(this.readablePaths.readBits);
        }
        return pb;
    }

    @NotNull
    private Tree getReadOnlyTree(@NotNull Tree tree) {
        if (tree instanceof ReadOnly) {
            return tree;
        }
        return this.immutableRoot.getTree(tree.getPath());
    }

    @Nullable
    private static String getEffectivePath(@NotNull Tree tree) {
        Tree principalEntry = null;
        if (Utils.isPrincipalEntry(tree)) {
            principalEntry = tree;
        } else if (Utils.isPrincipalEntry(tree.getParent())) {
            principalEntry = tree.getParent();
        }
        return principalEntry == null ? null : (String)principalEntry.getProperty("rep:effectivePath").getValue(Type.STRING);
    }

    @Nullable
    private Tree getVersionableTree(@NotNull Tree versionTree) {
        return ReadOnlyVersionManager.getInstance((Root)this.immutableRoot, (NamePathMapper)NamePathMapper.DEFAULT).getVersionable(versionTree, this.workspaceName);
    }

    private static boolean isVersionStoreTree(@NotNull Tree tree) {
        return ReadOnlyVersionManager.isVersionStoreTree((Tree)tree);
    }

    @NotNull
    TreePermission getTreePermission(@NotNull String name, @NotNull NodeState nodeState, @NotNull AbstractTreePermission parentTreePermission) {
        Tree readOnly = this.mgrProvider.getTreeProvider().createReadOnlyTree(parentTreePermission.getTree(), name, nodeState);
        return this.getTreePermission(readOnly, this.typeProvider.getType(readOnly, parentTreePermission.getType()), (TreePermission)parentTreePermission);
    }

    private static final class ReadablePaths {
        private final String[] paths;
        private final String[] substrPaths;
        private final PrivilegeBits readBits;

        private ReadablePaths(@NotNull MgrProvider mgrProvider) {
            this.paths = ((Set)mgrProvider.getSecurityProvider().getParameters("org.apache.jackrabbit.oak.authorization").getConfigValue("readPaths", (Object)PermissionConstants.DEFAULT_READ_PATHS)).toArray(new String[0]);
            this.substrPaths = new String[this.paths.length];
            int i = 0;
            for (String p : this.paths) {
                this.substrPaths[i++] = p + "/";
            }
            this.readBits = mgrProvider.getPrivilegeBitsProvider().getBits(new String[]{"jcr:read"});
        }

        public boolean isReadable(@NotNull String treePath) {
            for (String path : this.paths) {
                if (!treePath.equals(path)) continue;
                return true;
            }
            for (String path : this.substrPaths) {
                if (!treePath.startsWith(path)) continue;
                return true;
            }
            return false;
        }
    }

    private final class VersionTreePermission
    extends AbstractTreePermission
    implements VersionConstants {
        private final Tree versionTree;

        VersionTreePermission(@NotNull Tree versionTree, Tree versionableTree) {
            super(versionableTree, TreeType.VERSION);
            this.versionTree = versionTree;
        }

        @Override
        PrincipalBasedPermissionProvider getPermissionProvider() {
            return PrincipalBasedPermissionProvider.this;
        }

        @Override
        @NotNull
        public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
            Tree childVersionTree = PrincipalBasedPermissionProvider.this.mgrProvider.getTreeProvider().createReadOnlyTree(this.versionTree, childName, childState);
            String primaryType = NodeStateUtils.getPrimaryTypeName((NodeState)childState);
            Tree childVersionableTree = VERSION_NODE_NAMES.contains(childName) || "nt:version".equals(primaryType) ? this.getTree() : this.getTree().getChild(childName);
            return new VersionTreePermission(childVersionTree, childVersionableTree);
        }
    }

    private final class RegularTreePermission
    extends AbstractTreePermission {
        RegularTreePermission(@NotNull Tree tree, TreeType type) {
            super(tree, type);
        }

        @Override
        PrincipalBasedPermissionProvider getPermissionProvider() {
            return PrincipalBasedPermissionProvider.this;
        }
    }

    private final class RepositoryPermissionImpl
    implements RepositoryPermission {
        private long grantedPermissions = -1L;

        private RepositoryPermissionImpl() {
        }

        public boolean isGranted(long repositoryPermissions) {
            return Permissions.includes((long)this.getGranted(), (long)repositoryPermissions);
        }

        private long getGranted() {
            if (this.grantedPermissions == -1L) {
                PrivilegeBits pb = PrincipalBasedPermissionProvider.this.getGrantedPrivilegeBits("", EntryPredicate.create());
                this.grantedPermissions = PrivilegeBits.calculatePermissions((PrivilegeBits)pb, (PrivilegeBits)PrivilegeBits.EMPTY, (boolean)true);
            }
            return this.grantedPermissions;
        }

        private void refresh() {
            this.grantedPermissions = -1L;
        }
    }
}

