/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl;

import java.security.Principal;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Constants;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.MgrProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrincipalPolicyValidatorProvider
extends ValidatorProvider
implements Constants {
    private final MgrProvider mgrProvider;
    private final Set<Principal> principals;
    private final String workspaceName;
    private PermissionProvider permissionProvider;
    private TypePredicate isMixPrincipalBased;

    PrincipalPolicyValidatorProvider(@NotNull MgrProvider mgrProvider, @NotNull Set<Principal> principals, @NotNull String workspaceName) {
        this.mgrProvider = mgrProvider;
        this.principals = principals;
        this.workspaceName = workspaceName;
    }

    protected PolicyValidator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        Root rootBefore = this.mgrProvider.getRootProvider().createReadOnlyRoot(before);
        this.permissionProvider = ((AuthorizationConfiguration)this.mgrProvider.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class)).getPermissionProvider(rootBefore, this.workspaceName, this.principals);
        this.isMixPrincipalBased = new TypePredicate(after, "rep:PrincipalBasedMixin");
        return new PolicyValidator(before, after);
    }

    private final class PolicyValidator
    extends DefaultValidator {
        private final Tree parentBefore;
        private final Tree parentAfter;
        private final boolean isNodetypeTree;

        private PolicyValidator(@NotNull NodeState rootStateBefore, NodeState rootState) {
            PrincipalPolicyValidatorProvider.this.mgrProvider.reset(PrincipalPolicyValidatorProvider.this.mgrProvider.getRootProvider().createReadOnlyRoot(rootState), NamePathMapper.DEFAULT);
            this.parentBefore = PrincipalPolicyValidatorProvider.this.mgrProvider.getTreeProvider().createReadOnlyTree(rootStateBefore);
            this.parentAfter = PrincipalPolicyValidatorProvider.this.mgrProvider.getTreeProvider().createReadOnlyTree(rootState);
            this.isNodetypeTree = false;
        }

        private PolicyValidator(@NotNull PolicyValidator parentValidator, @NotNull Tree before, Tree after) {
            this.parentBefore = before;
            this.parentAfter = after;
            this.isNodetypeTree = parentValidator.isNodetypeTree ? true : "jcr:nodeTypes".equals(after.getName()) && "jcr:system".equals(parentValidator.getName());
        }

        private PolicyValidator(@NotNull PolicyValidator parentValidator, Tree tree, boolean isAfter) {
            this.parentBefore = isAfter ? null : tree;
            Object object = this.parentAfter = isAfter ? tree : null;
            this.isNodetypeTree = parentValidator.isNodetypeTree ? true : "jcr:nodeTypes".equals(tree.getName()) && "jcr:system".equals(parentValidator.getName());
        }

        @NotNull
        private String getName() {
            return this.parentBefore == null ? this.verifyNotNull(this.parentAfter).getName() : this.parentBefore.getName();
        }

        public void propertyAdded(PropertyState after) throws CommitFailedException {
            String propertyName = after.getName();
            if ("jcr:primaryType".equals(propertyName) && "rep:PrincipalPolicy".equals(after.getValue(Type.NAME)) && !"rep:principalPolicy".equals(this.verifyNotNull(this.parentAfter).getName())) {
                throw this.accessControlViolation(30, "Attempt create policy node with different name than 'rep:principalPolicy'.");
            }
        }

        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            String name = after.getName();
            if ("jcr:primaryType".equals(name) && ("rep:PrincipalPolicy".equals(before.getValue(Type.STRING)) || "rep:PrincipalPolicy".equals(after.getValue(Type.STRING)))) {
                throw this.accessControlViolation(31, "Attempt to change primary type from/to rep:PrincipalPolicy.");
            }
        }

        public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
            if (!this.isNodetypeTree) {
                if ("rep:principalPolicy".equals(name)) {
                    this.validatePolicyNode(this.verifyNotNull(this.parentAfter), after);
                } else if ("rep:restrictions".equals(name)) {
                    this.validateRestrictions(after);
                } else if ("rep:PrincipalEntry".equals(NodeStateUtils.getPrimaryTypeName((NodeState)after))) {
                    this.validateEntry(name, after);
                }
            }
            return new VisibleValidator((Validator)this.nextValidator(name, after, true), true, true);
        }

        public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
            if (!this.isNodetypeTree) {
                if (after.hasChildNode("rep:principalPolicy")) {
                    Tree parent = PrincipalPolicyValidatorProvider.this.mgrProvider.getTreeProvider().createReadOnlyTree(this.verifyNotNull(this.parentAfter), name, after);
                    this.validatePolicyNode(parent, after.getChildNode("rep:principalPolicy"));
                } else if ("rep:restrictions".equals(name)) {
                    this.validateRestrictions(after);
                } else if ("rep:PrincipalEntry".equals(NodeStateUtils.getPrimaryTypeName((NodeState)after))) {
                    this.validateEntry(name, after);
                }
            }
            return new VisibleValidator((Validator)this.nextValidator(name, before, after), true, true);
        }

        public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
            if (!this.isNodetypeTree) {
                PropertyState effectivePath = null;
                if ("rep:restrictions".equals(name)) {
                    effectivePath = this.verifyNotNull(this.parentBefore).getProperty("rep:effectivePath");
                } else if ("rep:PrincipalEntry".equals(NodeStateUtils.getPrimaryTypeName((NodeState)before))) {
                    effectivePath = before.getProperty("rep:effectivePath");
                }
                if (effectivePath != null && !Utils.hasModAcPermission(PrincipalPolicyValidatorProvider.this.permissionProvider, (String)effectivePath.getValue(Type.PATH))) {
                    throw new CommitFailedException("Access", 3, "Access denied");
                }
            }
            return new VisibleValidator((Validator)this.nextValidator(name, before, false), true, true);
        }

        private void validatePolicyNode(@NotNull Tree parent, @NotNull NodeState nodeState) throws CommitFailedException {
            if (!"rep:PrincipalPolicy".equals(NodeStateUtils.getPrimaryTypeName((NodeState)nodeState))) {
                throw this.accessControlViolation(32, "Reserved node name 'rep:principalPolicy' must only be used for nodes of type 'rep:PrincipalPolicy'.");
            }
            if (!PrincipalPolicyValidatorProvider.this.isMixPrincipalBased.test(parent)) {
                throw this.accessControlViolation(33, "Parent node not of mixin type 'rep:PrincipalBasedMixin'.");
            }
        }

        private void validateRestrictions(@NotNull NodeState nodeState) throws CommitFailedException {
            if (!"rep:Restrictions".equals(NodeStateUtils.getPrimaryTypeName((NodeState)nodeState))) {
                throw this.accessControlViolation(34, "Reserved node name 'rep:restrictions' must only be used for nodes of type 'rep:Restrictions'.");
            }
            Tree parent = this.verifyNotNull(this.parentAfter);
            if ("rep:PrincipalEntry".equals(TreeUtil.getPrimaryTypeName((Tree)parent))) {
                try {
                    String oakPath = Strings.emptyToNull((String)TreeUtil.getString((Tree)parent, (String)"rep:effectivePath"));
                    PrincipalPolicyValidatorProvider.this.mgrProvider.getRestrictionProvider().validateRestrictions(oakPath, parent);
                }
                catch (AccessControlException e) {
                    throw new CommitFailedException("AccessControl", 35, "Invalid restrictions", (Throwable)e);
                }
                catch (RepositoryException e) {
                    throw new CommitFailedException("Oak", 13, "Internal error", (Throwable)e);
                }
            } else if (!PrincipalPolicyValidatorProvider.this.mgrProvider.getContext().definesTree(parent)) {
                throw new CommitFailedException("AccessControl", 2, "Expected access control entry parent (isolated restriction).");
            }
        }

        private void validateEntry(@NotNull String name, @NotNull NodeState nodeState) throws CommitFailedException {
            Tree parent = this.verifyNotNull(this.parentAfter);
            String entryPath = PathUtils.concat((String)parent.getPath(), (String)name);
            if (!"rep:principalPolicy".equals(parent.getName())) {
                throw this.accessControlViolation(36, "Isolated entry of principal policy at " + entryPath);
            }
            Iterable privilegeNames = nodeState.getNames("rep:privileges");
            if (Iterables.isEmpty((Iterable)privilegeNames)) {
                throw this.accessControlViolation(37, "Empty rep:privileges property at " + entryPath);
            }
            PrivilegeManager privilegeManager = PrincipalPolicyValidatorProvider.this.mgrProvider.getPrivilegeManager();
            for (String privilegeName : privilegeNames) {
                try {
                    Privilege privilege = privilegeManager.getPrivilege(privilegeName);
                    if (!privilege.isAbstract()) continue;
                    throw this.accessControlViolation(38, "Abstract privilege " + privilegeName + " at " + entryPath);
                }
                catch (AccessControlException e) {
                    throw this.accessControlViolation(39, "Invalid privilege " + privilegeName + " at " + entryPath);
                }
                catch (RepositoryException e) {
                    throw new CommitFailedException("Oak", 13, "Internal error", (Throwable)e);
                }
            }
            PropertyState effectivePath = nodeState.getProperty("rep:effectivePath");
            if (effectivePath == null) {
                throw new CommitFailedException("Constraint", 21, "Missing mandatory rep:effectivePath property at " + entryPath);
            }
            if (!Utils.hasModAcPermission(PrincipalPolicyValidatorProvider.this.permissionProvider, (String)effectivePath.getValue(Type.PATH))) {
                throw new CommitFailedException("Access", 3, "Access denied");
            }
        }

        private CommitFailedException accessControlViolation(int code, String message) {
            return new CommitFailedException("AccessControl", code, message);
        }

        private PolicyValidator nextValidator(@NotNull String name, @NotNull NodeState beforeState, @NotNull NodeState afterState) {
            Tree before = PrincipalPolicyValidatorProvider.this.mgrProvider.getTreeProvider().createReadOnlyTree(this.verifyNotNull(this.parentBefore), name, beforeState);
            Tree after = PrincipalPolicyValidatorProvider.this.mgrProvider.getTreeProvider().createReadOnlyTree(this.verifyNotNull(this.parentAfter), name, afterState);
            return new PolicyValidator(this, before, after);
        }

        private PolicyValidator nextValidator(@NotNull String name, @NotNull NodeState nodeState, boolean isAfter) {
            Tree parent = isAfter ? this.parentAfter : this.parentBefore;
            Tree tree = PrincipalPolicyValidatorProvider.this.mgrProvider.getTreeProvider().createReadOnlyTree(this.verifyNotNull(parent), name, nodeState);
            return new PolicyValidator(this, tree, isAfter);
        }

        @NotNull
        private Tree verifyNotNull(@Nullable Tree tree) {
            Validate.checkState((tree != null ? 1 : 0) != 0);
            return tree;
        }
    }
}

