/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.RetryPolicy;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobInputStream;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlockEntry;
import com.microsoft.azure.storage.blob.BlockListingFilter;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.CopyStatus;
import com.microsoft.azure.storage.blob.ListBlobItem;
import com.microsoft.azure.storage.blob.SharedAccessBlobHeaders;
import com.microsoft.azure.storage.blob.SharedAccessBlobPermissions;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage.Utils;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordDownloadOptions;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUpload;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadOptions;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadToken;
import org.apache.jackrabbit.oak.spi.blob.AbstractDataRecord;
import org.apache.jackrabbit.oak.spi.blob.AbstractSharedBackend;
import org.apache.jackrabbit.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureBlobStoreBackend
extends AbstractSharedBackend {
    private static final Logger LOG = LoggerFactory.getLogger(AzureBlobStoreBackend.class);
    private static final Logger LOG_STREAMS_DOWNLOAD = LoggerFactory.getLogger((String)"oak.datastore.download.streams");
    private static final Logger LOG_STREAMS_UPLOAD = LoggerFactory.getLogger((String)"oak.datastore.upload.streams");
    private static final String META_DIR_NAME = "META";
    private static final String META_KEY_PREFIX = "META/";
    private static final String REF_KEY = "reference.key";
    private static final long BUFFERED_STREAM_THRESHHOLD = 0x100000L;
    static final long MIN_MULTIPART_UPLOAD_PART_SIZE = 0xA00000L;
    static final long MAX_MULTIPART_UPLOAD_PART_SIZE = 0x6400000L;
    static final long MAX_SINGLE_PUT_UPLOAD_SIZE = 0x10000000L;
    static final long MAX_BINARY_UPLOAD_SIZE = (long)Math.floor(5.222680231936E12);
    private static final int MAX_ALLOWABLE_UPLOAD_URIS = 50000;
    private static final int MAX_UNIQUE_RECORD_TRIES = 10;
    private Properties properties;
    private String containerName;
    private String connectionString;
    private int concurrentRequestCount = 1;
    private RetryPolicy retryPolicy;
    private Integer requestTimeout;
    private int httpDownloadURIExpirySeconds = 0;
    private int httpUploadURIExpirySeconds = 0;
    private boolean createBlobContainer = true;
    private boolean presignedDownloadURIVerifyExists = true;
    private Cache<DataIdentifier, URI> httpDownloadURICache;
    private byte[] secret;

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected CloudBlobContainer getAzureContainer() throws DataStoreException {
        CloudBlobContainer container = Utils.getBlobContainer(this.connectionString, this.containerName);
        BlobRequestOptions requestOptions = container.getServiceClient().getDefaultRequestOptions();
        if (this.retryPolicy != null) {
            requestOptions.setRetryPolicyFactory((RetryPolicyFactory)this.retryPolicy);
        }
        if (this.requestTimeout != null) {
            requestOptions.setTimeoutIntervalInMs(this.requestTimeout);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws DataStoreException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        long start = System.currentTimeMillis();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            LOG.debug("Started backend initialization");
            if (null == this.properties) {
                try {
                    this.properties = Utils.readConfig("azure.properties");
                }
                catch (IOException e) {
                    throw new DataStoreException("Unable to initialize Azure Data Store from azure.properties", (Throwable)e);
                }
            }
            try {
                String getExpiry;
                Utils.setProxyIfNeeded(this.properties);
                this.containerName = (String)this.properties.get("container");
                this.createBlobContainer = PropertiesUtil.toBoolean((Object)this.properties.getProperty("azureCreateContainer"), (boolean)true);
                this.connectionString = Utils.getConnectionStringFromProperties(this.properties);
                this.concurrentRequestCount = PropertiesUtil.toInteger((Object)this.properties.get("maxConnections"), (int)1);
                LOG.info("Using concurrentRequestsPerOperation={}", (Object)this.concurrentRequestCount);
                this.retryPolicy = Utils.getRetryPolicy((String)this.properties.get("maxErrorRetry"));
                if (this.properties.getProperty("socketTimeout") != null) {
                    this.requestTimeout = PropertiesUtil.toInteger((Object)this.properties.getProperty("socketTimeout"), (int)3);
                }
                this.presignedDownloadURIVerifyExists = PropertiesUtil.toBoolean((Object)this.properties.get("presignedHttpDownloadURIVerifyExists"), (boolean)true);
                CloudBlobContainer azureContainer = this.getAzureContainer();
                if (this.createBlobContainer && azureContainer.createIfNotExists()) {
                    LOG.info("New container created. containerName={}", (Object)this.containerName);
                } else {
                    LOG.info("Reusing existing container. containerName={}", (Object)this.containerName);
                }
                LOG.debug("Backend initialized. duration={}", (Object)(System.currentTimeMillis() - start));
                String putExpiry = this.properties.getProperty("presignedHttpUploadURIExpirySeconds");
                if (null != putExpiry) {
                    this.setHttpUploadURIExpirySeconds(Integer.parseInt(putExpiry));
                }
                if (null != (getExpiry = this.properties.getProperty("presignedHttpDownloadURIExpirySeconds"))) {
                    this.setHttpDownloadURIExpirySeconds(Integer.parseInt(getExpiry));
                    String cacheMaxSize = this.properties.getProperty("presignedHttpDownloadURICacheMaxSize");
                    if (null != cacheMaxSize) {
                        this.setHttpDownloadURICacheSize(Integer.parseInt(cacheMaxSize));
                    } else {
                        this.setHttpDownloadURICacheSize(0);
                    }
                }
            }
            catch (StorageException e) {
                throw new DataStoreException((Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public InputStream read(DataIdentifier identifier) throws DataStoreException {
        if (null == identifier) {
            throw new NullPointerException("identifier");
        }
        String key = AzureBlobStoreBackend.getKeyName(identifier);
        long start = System.currentTimeMillis();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            CloudBlockBlob blob = this.getAzureContainer().getBlockBlobReference(key);
            if (!blob.exists()) {
                throw new DataStoreException(String.format("Trying to read missing blob. identifier=%s", key));
            }
            BlobInputStream is = blob.openInputStream();
            LOG.debug("Got input stream for blob. identifier={} duration={}", (Object)key, (Object)(System.currentTimeMillis() - start));
            if (LOG_STREAMS_DOWNLOAD.isDebugEnabled()) {
                LOG_STREAMS_DOWNLOAD.debug("Binary downloaded from Azure Blob Storage - identifier={}", (Object)key, (Object)new Exception());
            }
            BlobInputStream blobInputStream = is;
            return blobInputStream;
        }
        catch (StorageException e) {
            LOG.info("Error reading blob. identifier=%s", (Object)key);
            throw new DataStoreException(String.format("Cannot read blob. identifier=%s", key), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.debug("Error reading blob. identifier=%s", (Object)key);
            throw new DataStoreException(String.format("Cannot read blob. identifier=%s", key), (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataIdentifier identifier, File file) throws DataStoreException {
        if (null == identifier) {
            throw new NullPointerException("identifier");
        }
        if (null == file) {
            throw new NullPointerException("file");
        }
        String key = AzureBlobStoreBackend.getKeyName(identifier);
        long start = System.currentTimeMillis();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            long len = file.length();
            LOG.debug("Blob write started. identifier={} length={}", (Object)key, (Object)len);
            CloudBlockBlob blob = this.getAzureContainer().getBlockBlobReference(key);
            if (!blob.exists()) {
                BlobRequestOptions options = new BlobRequestOptions();
                options.setConcurrentRequestCount(Integer.valueOf(this.concurrentRequestCount));
                boolean useBufferedStream = len < 0x100000L;
                try (InputStream in = useBufferedStream ? new BufferedInputStream(new FileInputStream(file)) : new FileInputStream(file);){
                    blob.upload(in, len, null, options, null);
                    LOG.debug("Blob created. identifier={} length={} duration={} buffered={}", new Object[]{key, len, System.currentTimeMillis() - start, useBufferedStream});
                    if (LOG_STREAMS_UPLOAD.isDebugEnabled()) {
                        LOG_STREAMS_UPLOAD.debug("Binary uploaded to Azure Blob Storage - identifier={}", (Object)key, (Object)new Exception());
                    }
                }
                return;
            }
            blob.downloadAttributes();
            if (blob.getProperties().getLength() != len) {
                throw new DataStoreException("Length Collision. identifier=" + key + " new length=" + len + " old length=" + blob.getProperties().getLength());
            }
            LOG.trace("Blob already exists. identifier={} lastModified={}", (Object)key, (Object)blob.getProperties().getLastModified().getTime());
            blob.startCopy(blob);
            if (!AzureBlobStoreBackend.waitForCopy((CloudBlob)blob)) {
                throw new DataStoreException(String.format("Cannot update lastModified for blob. identifier=%s status=%s", key, blob.getCopyState().getStatusDescription()));
            }
            LOG.debug("Blob updated. identifier={} lastModified={} duration={}", new Object[]{key, blob.getProperties().getLastModified().getTime(), System.currentTimeMillis() - start});
        }
        catch (StorageException e) {
            LOG.info("Error writing blob. identifier={}", (Object)key, (Object)e);
            throw new DataStoreException(String.format("Cannot write blob. identifier=%s", key), (Throwable)e);
        }
        catch (IOException | URISyntaxException e) {
            LOG.debug("Error writing blob. identifier={}", (Object)key, (Object)e);
            throw new DataStoreException(String.format("Cannot write blob. identifier=%s", key), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.debug("Error writing blob. identifier={}", (Object)key, (Object)e);
            throw new DataStoreException(String.format("Cannot copy blob. identifier=%s", key), (Throwable)e);
        }
        finally {
            if (null != contextClassLoader) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    private static boolean waitForCopy(CloudBlob blob) throws StorageException, InterruptedException {
        boolean continueLoop = true;
        CopyStatus status = CopyStatus.PENDING;
        while (continueLoop) {
            blob.downloadAttributes();
            status = blob.getCopyState().getStatus();
            continueLoop = status == CopyStatus.PENDING;
            if (!continueLoop) continue;
            Thread.sleep(500L);
        }
        return status == CopyStatus.SUCCESS;
    }

    public byte[] getOrCreateReferenceKey() throws DataStoreException {
        try {
            if (this.secret != null && this.secret.length != 0) {
                return this.secret;
            }
            byte[] key = this.readMetadataBytes(REF_KEY);
            if (key == null) {
                key = super.getOrCreateReferenceKey();
                this.addMetadataRecord(new ByteArrayInputStream(key), REF_KEY);
                key = this.readMetadataBytes(REF_KEY);
            }
            this.secret = key;
            return this.secret;
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to get or create key " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readMetadataBytes(String name) throws IOException, DataStoreException {
        DataRecord rec = this.getMetadataRecord(name);
        byte[] key = null;
        if (rec != null) {
            InputStream stream = null;
            try {
                stream = rec.getStream();
                byte[] byArray = IOUtils.toByteArray((InputStream)stream);
                return byArray;
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return key;
    }

    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        if (null == identifier) {
            throw new NullPointerException("identifier");
        }
        String key = AzureBlobStoreBackend.getKeyName(identifier);
        long start = System.currentTimeMillis();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            CloudBlockBlob blob = this.getAzureContainer().getBlockBlobReference(key);
            blob.downloadAttributes();
            AzureBlobStoreDataRecord record = new AzureBlobStoreDataRecord(this, this.connectionString, this.containerName, new DataIdentifier(AzureBlobStoreBackend.getIdentifierName(blob.getName())), blob.getProperties().getLastModified().getTime(), blob.getProperties().getLength());
            LOG.debug("Data record read for blob. identifier={} duration={} record={}", new Object[]{key, System.currentTimeMillis() - start, record});
            AzureBlobStoreDataRecord azureBlobStoreDataRecord = record;
            return azureBlobStoreDataRecord;
        }
        catch (StorageException e) {
            if (404 == e.getHttpStatusCode()) {
                LOG.debug("Unable to get record for blob; blob does not exist. identifier={}", (Object)key);
            } else {
                LOG.info("Error getting data record for blob. identifier={}", (Object)key, (Object)e);
            }
            throw new DataStoreException(String.format("Cannot retrieve blob. identifier=%s", key), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.debug("Error getting data record for blob. identifier={}", (Object)key, (Object)e);
            throw new DataStoreException(String.format("Cannot retrieve blob. identifier=%s", key), (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return new RecordsIterator<DataIdentifier>(new Function<AzureBlobInfo, DataIdentifier>(){

            public DataIdentifier apply(AzureBlobInfo input) {
                return new DataIdentifier(AzureBlobStoreBackend.getIdentifierName(input.getName()));
            }
        });
    }

    public Iterator<DataRecord> getAllRecords() throws DataStoreException {
        final AzureBlobStoreBackend backend = this;
        return new RecordsIterator<DataRecord>(new Function<AzureBlobInfo, DataRecord>(){

            public DataRecord apply(AzureBlobInfo input) {
                return new AzureBlobStoreDataRecord(backend, AzureBlobStoreBackend.this.connectionString, AzureBlobStoreBackend.this.containerName, new DataIdentifier(AzureBlobStoreBackend.getIdentifierName(input.getName())), input.getLastModified(), input.getLength());
            }
        });
    }

    public boolean exists(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        String key = AzureBlobStoreBackend.getKeyName(identifier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            boolean exists = this.getAzureContainer().getBlockBlobReference(key).exists();
            LOG.debug("Blob exists={} identifier={} duration={}", new Object[]{exists, key, System.currentTimeMillis() - start});
            boolean bl = exists;
            return bl;
        }
        catch (Exception e) {
            throw new DataStoreException((Throwable)e);
        }
        finally {
            if (null != contextClassLoader) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void close() throws DataStoreException {
        LOG.info("AzureBlobBackend closed.");
    }

    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        if (null == identifier) {
            throw new NullPointerException("identifier");
        }
        String key = AzureBlobStoreBackend.getKeyName(identifier);
        long start = System.currentTimeMillis();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            boolean result = this.getAzureContainer().getBlockBlobReference(key).deleteIfExists();
            LOG.debug("Blob {}. identifier={} duration={}", new Object[]{result ? "deleted" : "delete requested, but it does not exist (perhaps already deleted)", key, System.currentTimeMillis() - start});
        }
        catch (StorageException e) {
            LOG.info("Error deleting blob. identifier={}", (Object)key, (Object)e);
            throw new DataStoreException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new DataStoreException((Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetadataRecord(InputStream input, String name) throws DataStoreException {
        if (null == input) {
            throw new NullPointerException("input");
        }
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("name");
        }
        long start = System.currentTimeMillis();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.addMetadataRecordImpl(input, name, -1L);
            LOG.debug("Metadata record added. metadataName={} duration={}", (Object)name, (Object)(System.currentTimeMillis() - start));
        }
        finally {
            if (null != contextClassLoader) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void addMetadataRecord(File input, String name) throws DataStoreException {
        if (null == input) {
            throw new NullPointerException("input");
        }
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("name");
        }
        long start = System.currentTimeMillis();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.addMetadataRecordImpl(new FileInputStream(input), name, input.length());
            LOG.debug("Metadata record added. metadataName={} duration={}", (Object)name, (Object)(System.currentTimeMillis() - start));
        }
        catch (FileNotFoundException e) {
            throw new DataStoreException((Throwable)e);
        }
        finally {
            if (null != contextClassLoader) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    private void addMetadataRecordImpl(InputStream input, String name, long recordLength) throws DataStoreException {
        try {
            CloudBlobDirectory metaDir = this.getAzureContainer().getDirectoryReference(META_DIR_NAME);
            CloudBlockBlob blob = metaDir.getBlockBlobReference(name);
            blob.upload(input, recordLength);
        }
        catch (StorageException e) {
            LOG.info("Error adding metadata record. metadataName={} length={}", new Object[]{name, recordLength, e});
            throw new DataStoreException((Throwable)e);
        }
        catch (IOException | URISyntaxException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    public DataRecord getMetadataRecord(String name) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        long start = System.currentTimeMillis();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            CloudBlobDirectory metaDir = this.getAzureContainer().getDirectoryReference(META_DIR_NAME);
            CloudBlockBlob blob = metaDir.getBlockBlobReference(name);
            if (!blob.exists()) {
                LOG.warn("Trying to read missing metadata. metadataName={}", (Object)name);
                DataRecord dataRecord = null;
                return dataRecord;
            }
            blob.downloadAttributes();
            long lastModified = blob.getProperties().getLastModified().getTime();
            long length = blob.getProperties().getLength();
            AzureBlobStoreDataRecord record = new AzureBlobStoreDataRecord(this, this.connectionString, this.containerName, new DataIdentifier(name), lastModified, length, true);
            LOG.debug("Metadata record read. metadataName={} duration={} record={}", new Object[]{name, System.currentTimeMillis() - start, record});
            AzureBlobStoreDataRecord azureBlobStoreDataRecord = record;
            return azureBlobStoreDataRecord;
        }
        catch (StorageException e) {
            LOG.info("Error reading metadata record. metadataName={}", (Object)name, (Object)e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOG.debug("Error reading metadata record. metadataName={}", (Object)name, (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (null != contextClassLoader) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataRecord> getAllMetadataRecords(String prefix) {
        if (null == prefix) {
            throw new NullPointerException("prefix");
        }
        long start = System.currentTimeMillis();
        ArrayList records = Lists.newArrayList();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            CloudBlobDirectory metaDir = this.getAzureContainer().getDirectoryReference(META_DIR_NAME);
            for (ListBlobItem item : metaDir.listBlobs(prefix)) {
                if (!(item instanceof CloudBlob)) continue;
                CloudBlob blob = (CloudBlob)item;
                records.add(new AzureBlobStoreDataRecord(this, this.connectionString, this.containerName, new DataIdentifier(AzureBlobStoreBackend.stripMetaKeyPrefix(blob.getName())), blob.getProperties().getLastModified().getTime(), blob.getProperties().getLength(), true));
            }
            LOG.debug("Metadata records read. recordsRead={} metadataFolder={} duration={}", new Object[]{records.size(), prefix, System.currentTimeMillis() - start});
        }
        catch (StorageException e) {
            LOG.info("Error reading all metadata records. metadataFolder={}", (Object)prefix, (Object)e);
        }
        catch (URISyntaxException | DataStoreException e) {
            LOG.debug("Error reading all metadata records. metadataFolder={}", (Object)prefix, (Object)e);
        }
        finally {
            if (null != contextClassLoader) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteMetadataRecord(String name) {
        long start = System.currentTimeMillis();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            CloudBlockBlob blob = this.getAzureContainer().getBlockBlobReference(AzureBlobStoreBackend.addMetaKeyPrefix(name));
            boolean result = blob.deleteIfExists();
            LOG.debug("Metadata record {}. metadataName={} duration={}", new Object[]{result ? "deleted" : "delete requested, but it does not exist (perhaps already deleted)", name, System.currentTimeMillis() - start});
            boolean bl = result;
            return bl;
        }
        catch (StorageException e) {
            LOG.info("Error deleting metadata record. metadataName={}", (Object)name, (Object)e);
        }
        catch (URISyntaxException | DataStoreException e) {
            LOG.debug("Error deleting metadata record. metadataName={}", (Object)name, (Object)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllMetadataRecords(String prefix) {
        if (null == prefix) {
            throw new NullPointerException("prefix");
        }
        long start = System.currentTimeMillis();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            CloudBlobDirectory metaDir = this.getAzureContainer().getDirectoryReference(META_DIR_NAME);
            int total = 0;
            for (ListBlobItem item : metaDir.listBlobs(prefix)) {
                if (!(item instanceof CloudBlob) || !((CloudBlob)item).deleteIfExists()) continue;
                ++total;
            }
            LOG.debug("Metadata records deleted. recordsDeleted={} metadataFolder={} duration={}", new Object[]{total, prefix, System.currentTimeMillis() - start});
        }
        catch (StorageException e) {
            LOG.info("Error deleting all metadata records. metadataFolder={}", (Object)prefix, (Object)e);
        }
        catch (URISyntaxException | DataStoreException e) {
            LOG.debug("Error deleting all metadata records. metadataFolder={}", (Object)prefix, (Object)e);
        }
        finally {
            if (null != contextClassLoader) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean metadataRecordExists(String name) {
        long start = System.currentTimeMillis();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            CloudBlockBlob blob = this.getAzureContainer().getBlockBlobReference(AzureBlobStoreBackend.addMetaKeyPrefix(name));
            boolean exists = blob.exists();
            LOG.debug("Metadata record {} exists {}. duration={}", new Object[]{name, exists, System.currentTimeMillis() - start});
            boolean bl = exists;
            return bl;
        }
        catch (StorageException | URISyntaxException | DataStoreException e) {
            LOG.debug("Error checking existence of metadata record = {}", (Object)name, (Object)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return false;
    }

    private static String getKeyName(DataIdentifier identifier) {
        String key = identifier.toString();
        return key.substring(0, 4) + "-" + key.substring(4);
    }

    private static String getIdentifierName(String key) {
        if (!key.contains("-")) {
            return null;
        }
        if (key.contains(META_KEY_PREFIX)) {
            return key;
        }
        return key.substring(0, 4) + key.substring(5);
    }

    private static String addMetaKeyPrefix(String key) {
        return META_KEY_PREFIX + key;
    }

    private static String stripMetaKeyPrefix(String name) {
        if (name.startsWith(META_KEY_PREFIX)) {
            return name.substring(META_KEY_PREFIX.length());
        }
        return name;
    }

    void setHttpDownloadURIExpirySeconds(int seconds) {
        this.httpDownloadURIExpirySeconds = seconds;
    }

    void setHttpDownloadURICacheSize(int maxSize) {
        if (maxSize > 0) {
            LOG.info("presigned GET URI cache enabled, maxSize = {} items, expiry = {} seconds", (Object)maxSize, (Object)(this.httpDownloadURIExpirySeconds / 2));
            this.httpDownloadURICache = CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterWrite((long)(this.httpDownloadURIExpirySeconds / 2), TimeUnit.SECONDS).build();
        } else {
            LOG.info("presigned GET URI cache disabled");
            this.httpDownloadURICache = null;
        }
    }

    URI createHttpDownloadURI(@NotNull DataIdentifier identifier, @NotNull DataRecordDownloadOptions downloadOptions) {
        URI uri = null;
        if (null == identifier) {
            throw new NullPointerException("identifier");
        }
        if (null == downloadOptions) {
            throw new NullPointerException("downloadOptions");
        }
        if (this.httpDownloadURIExpirySeconds > 0) {
            if (null != this.httpDownloadURICache) {
                uri = (URI)this.httpDownloadURICache.getIfPresent((Object)identifier);
            }
            if (null == uri) {
                String domain;
                String contentDisposition;
                if (this.presignedDownloadURIVerifyExists) {
                    try {
                        if (!this.exists(identifier)) {
                            LOG.warn("Cannot create download URI for nonexistent blob {}; returning null", (Object)AzureBlobStoreBackend.getKeyName(identifier));
                            return null;
                        }
                    }
                    catch (DataStoreException e) {
                        LOG.warn("Cannot create download URI for blob {} (caught DataStoreException); returning null", (Object)AzureBlobStoreBackend.getKeyName(identifier), (Object)e);
                        return null;
                    }
                }
                String key = AzureBlobStoreBackend.getKeyName(identifier);
                SharedAccessBlobHeaders headers = new SharedAccessBlobHeaders();
                headers.setCacheControl(String.format("private, max-age=%d, immutable", this.httpDownloadURIExpirySeconds));
                String contentType = downloadOptions.getContentTypeHeader();
                if (!Strings.isNullOrEmpty((String)contentType)) {
                    headers.setContentType(contentType);
                }
                if (!Strings.isNullOrEmpty((String)(contentDisposition = downloadOptions.getContentDispositionHeader()))) {
                    headers.setContentDisposition(contentDisposition);
                }
                if (null == (domain = this.getDirectDownloadBlobStorageDomain(downloadOptions.isDomainOverrideIgnored()))) {
                    throw new NullPointerException("Could not determine domain for direct download");
                }
                uri = this.createPresignedURI(key, EnumSet.of(SharedAccessBlobPermissions.READ), this.httpDownloadURIExpirySeconds, headers, domain);
                if (uri != null && this.httpDownloadURICache != null) {
                    this.httpDownloadURICache.put((Object)identifier, (Object)uri);
                }
            }
        }
        return uri;
    }

    void setHttpUploadURIExpirySeconds(int seconds) {
        this.httpUploadURIExpirySeconds = seconds;
    }

    private DataIdentifier generateSafeRandomIdentifier() {
        return new DataIdentifier(String.format("%s-%d", UUID.randomUUID().toString(), Instant.now().toEpochMilli()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DataRecordUpload initiateHttpUpload(long maxUploadSizeInBytes, int maxNumberOfURIs, @NotNull DataRecordUploadOptions options) {
        final ArrayList uploadPartURIs = Lists.newArrayList();
        final long minPartSize = 0xA00000L;
        final long maxPartSize = 0x6400000L;
        if (0L >= maxUploadSizeInBytes) {
            throw new IllegalArgumentException("maxUploadSizeInBytes must be > 0");
        }
        if (0 == maxNumberOfURIs) {
            throw new IllegalArgumentException("maxNumberOfURIs must either be > 0 or -1");
        }
        if (-1 > maxNumberOfURIs) {
            throw new IllegalArgumentException("maxNumberOfURIs must either be > 0 or -1");
        }
        if (maxUploadSizeInBytes > 0x10000000L && maxNumberOfURIs == 1) {
            throw new IllegalArgumentException(String.format("Cannot do single-put upload with file size %d - exceeds max single-put upload size of %d", maxUploadSizeInBytes, 0x10000000L));
        }
        if (maxUploadSizeInBytes > MAX_BINARY_UPLOAD_SIZE) {
            throw new IllegalArgumentException(String.format("Cannot do upload with file size %d - exceeds max upload size of %d", maxUploadSizeInBytes, MAX_BINARY_UPLOAD_SIZE));
        }
        DataIdentifier newIdentifier = this.generateSafeRandomIdentifier();
        String blobId = AzureBlobStoreBackend.getKeyName(newIdentifier);
        String uploadId = null;
        if (this.httpUploadURIExpirySeconds <= 0) return null;
        uploadId = Base64.encode((String)UUID.randomUUID().toString());
        long numParts = 0L;
        if (maxNumberOfURIs > 0) {
            long requestedPartSize = (long)Math.ceil((double)maxUploadSizeInBytes / (double)maxNumberOfURIs);
            if (requestedPartSize > maxPartSize) throw new IllegalArgumentException(String.format("Cannot do multi-part upload with requested part size %d", requestedPartSize));
            numParts = Math.min((long)maxNumberOfURIs, Math.min((long)Math.ceil((double)maxUploadSizeInBytes / (double)minPartSize), 50000L));
        } else {
            long maximalNumParts = (long)Math.ceil((double)maxUploadSizeInBytes / 1.048576E7);
            numParts = Math.min(maximalNumParts, 50000L);
        }
        String key = AzureBlobStoreBackend.getKeyName(newIdentifier);
        String domain = this.getDirectUploadBlobStorageDomain(options.isDomainOverrideIgnored());
        if (null == domain) {
            throw new NullPointerException("Could not determine domain for direct upload");
        }
        EnumSet<SharedAccessBlobPermissions> perms = EnumSet.of(SharedAccessBlobPermissions.WRITE);
        HashMap presignedURIRequestParams = Maps.newHashMap();
        presignedURIRequestParams.put("comp", "block");
        for (long blockId = 1L; blockId <= numParts; ++blockId) {
            presignedURIRequestParams.put("blockId", Base64.encode((String)String.format("%06d", blockId)));
            uploadPartURIs.add(this.createPresignedURI(key, perms, this.httpUploadURIExpirySeconds, presignedURIRequestParams, domain));
        }
        try {
            byte[] secret = this.getOrCreateReferenceKey();
            final String uploadToken = new DataRecordUploadToken(blobId, uploadId).getEncodedToken(secret);
            return new DataRecordUpload(){

                @NotNull
                public String getUploadToken() {
                    return uploadToken;
                }

                public long getMinPartSize() {
                    return minPartSize;
                }

                public long getMaxPartSize() {
                    return maxPartSize;
                }

                @NotNull
                public Collection<URI> getUploadURIs() {
                    return uploadPartURIs;
                }
            };
        }
        catch (DataStoreException e) {
            LOG.warn("Unable to obtain data store key");
        }
        return null;
    }

    DataRecord completeHttpUpload(@NotNull String uploadTokenStr) throws DataRecordUploadException, DataStoreException {
        if (Strings.isNullOrEmpty((String)uploadTokenStr)) {
            throw new IllegalArgumentException("uploadToken required");
        }
        DataRecordUploadToken uploadToken = DataRecordUploadToken.fromEncodedToken((String)uploadTokenStr, (byte[])this.getOrCreateReferenceKey());
        String key = uploadToken.getBlobId();
        DataIdentifier blobId = new DataIdentifier(AzureBlobStoreBackend.getIdentifierName(key));
        Object record = null;
        try {
            record = this.getRecord(blobId);
        }
        catch (DataStoreException e1) {
            try {
                long size;
                CloudBlockBlob blob;
                if (uploadToken.getUploadId().isPresent()) {
                    blob = this.getAzureContainer().getBlockBlobReference(key);
                    ArrayList blocks = blob.downloadBlockList(BlockListingFilter.UNCOMMITTED, AccessCondition.generateEmptyCondition(), null, null);
                    blob.commitBlockList((Iterable)blocks);
                    size = 0L;
                    for (BlockEntry block : blocks) {
                        size += block.getSize();
                    }
                } else {
                    throw new DataRecordUploadException(String.format("Unable to finalize direct write of binary %s - upload ID missing from upload token", blobId));
                }
                record = new AzureBlobStoreDataRecord(this, this.connectionString, this.containerName, blobId, blob.getProperties().getLastModified().getTime(), size);
            }
            catch (StorageException | URISyntaxException e2) {
                throw new DataRecordUploadException(String.format("Unable to finalize direct write of binary %s", blobId), (Exception)e2);
            }
        }
        return record;
    }

    private String getDefaultBlobStorageDomain() {
        String accountName = this.properties.getProperty("accessKey", "");
        if (Strings.isNullOrEmpty((String)accountName)) {
            LOG.warn("Can't generate presigned URI - Azure account name not found in properties");
            return null;
        }
        return String.format("%s.blob.core.windows.net", accountName);
    }

    private String getDirectDownloadBlobStorageDomain(boolean ignoreDomainOverride) {
        String domain;
        String string = domain = ignoreDomainOverride ? this.getDefaultBlobStorageDomain() : this.properties.getProperty("presignedHttpDownloadURIDomainOverride", null);
        if (Strings.isNullOrEmpty((String)domain)) {
            domain = this.getDefaultBlobStorageDomain();
        }
        return domain;
    }

    private String getDirectUploadBlobStorageDomain(boolean ignoreDomainOverride) {
        String domain;
        String string = domain = ignoreDomainOverride ? this.getDefaultBlobStorageDomain() : this.properties.getProperty("presignedHttpUploadURIDomainOverride", null);
        if (Strings.isNullOrEmpty((String)domain)) {
            domain = this.getDefaultBlobStorageDomain();
        }
        return domain;
    }

    private URI createPresignedURI(String key, EnumSet<SharedAccessBlobPermissions> permissions, int expirySeconds, SharedAccessBlobHeaders optionalHeaders, String domain) {
        return this.createPresignedURI(key, permissions, expirySeconds, Maps.newHashMap(), optionalHeaders, domain);
    }

    private URI createPresignedURI(String key, EnumSet<SharedAccessBlobPermissions> permissions, int expirySeconds, Map<String, String> additionalQueryParams, String domain) {
        return this.createPresignedURI(key, permissions, expirySeconds, additionalQueryParams, null, domain);
    }

    private URI createPresignedURI(String key, EnumSet<SharedAccessBlobPermissions> permissions, int expirySeconds, Map<String, String> additionalQueryParams, SharedAccessBlobHeaders optionalHeaders, String domain) {
        SharedAccessBlobPolicy policy = new SharedAccessBlobPolicy();
        Date expiry = Date.from(Instant.now().plusSeconds(expirySeconds));
        policy.setSharedAccessExpiryTime(expiry);
        policy.setPermissions(permissions);
        if (Strings.isNullOrEmpty((String)domain)) {
            LOG.warn("Can't generate presigned URI - no Azure domain provided (is Azure account name configured?)");
            return null;
        }
        URI presignedURI = null;
        try {
            CloudBlockBlob blob = this.getAzureContainer().getBlockBlobReference(key);
            String sharedAccessSignature = null == optionalHeaders ? blob.generateSharedAccessSignature(policy, null) : blob.generateSharedAccessSignature(policy, optionalHeaders, null, null, null, true);
            String uriString = String.format("https://%s/%s/%s?%s", domain, this.containerName, key, sharedAccessSignature);
            if (!additionalQueryParams.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, String> e : additionalQueryParams.entrySet()) {
                    builder.append("&");
                    builder.append(URLEncoder.encode(e.getKey(), Charsets.UTF_8.name()));
                    builder.append("=");
                    builder.append(URLEncoder.encode(e.getValue(), Charsets.UTF_8.name()));
                }
                uriString = uriString + builder.toString();
            }
            presignedURI = new URI(uriString);
        }
        catch (DataStoreException e) {
            LOG.error("No connection to Azure Blob Storage", (Throwable)e);
        }
        catch (UnsupportedEncodingException | URISyntaxException | InvalidKeyException e) {
            LOG.error("Can't generate a presigned URI for key {}", (Object)key, (Object)e);
        }
        catch (StorageException e) {
            LOG.error("Azure request to create presigned Azure Blob Storage {} URI failed. Key: {}, Error: {}, HTTP Code: {}, Azure Error Code: {}", new Object[]{permissions.contains(SharedAccessBlobPermissions.READ) ? "GET" : (permissions.contains(SharedAccessBlobPermissions.WRITE) ? "PUT" : ""), key, e.getMessage(), e.getHttpStatusCode(), e.getErrorCode()});
        }
        return presignedURI;
    }

    static class AzureBlobStoreDataRecord
    extends AbstractDataRecord {
        final String connectionString;
        final String containerName;
        final long lastModified;
        final long length;
        final boolean isMeta;

        public AzureBlobStoreDataRecord(AbstractSharedBackend backend, String connectionString, String containerName, DataIdentifier key, long lastModified, long length) {
            this(backend, connectionString, containerName, key, lastModified, length, false);
        }

        public AzureBlobStoreDataRecord(AbstractSharedBackend backend, String connectionString, String containerName, DataIdentifier key, long lastModified, long length, boolean isMeta) {
            super(backend, key);
            this.connectionString = connectionString;
            this.containerName = containerName;
            this.lastModified = lastModified;
            this.length = length;
            this.isMeta = isMeta;
        }

        public long getLength() throws DataStoreException {
            return this.length;
        }

        public InputStream getStream() throws DataStoreException {
            String id = AzureBlobStoreBackend.getKeyName(this.getIdentifier());
            CloudBlobContainer container = Utils.getBlobContainer(this.connectionString, this.containerName);
            if (this.isMeta) {
                id = AzureBlobStoreBackend.addMetaKeyPrefix(this.getIdentifier().toString());
            } else if (LOG_STREAMS_DOWNLOAD.isDebugEnabled()) {
                LOG_STREAMS_DOWNLOAD.debug("Binary downloaded from Azure Blob Storage - identifier={} ", (Object)id, (Object)new Exception());
            }
            try {
                return container.getBlockBlobReference(id).openInputStream();
            }
            catch (StorageException | URISyntaxException e) {
                throw new DataStoreException(e);
            }
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String toString() {
            return "AzureBlobStoreDataRecord{identifier=" + this.getIdentifier() + ", length=" + this.length + ", lastModified=" + this.lastModified + ", containerName='" + this.containerName + '\'' + '}';
        }
    }

    private class RecordsIterator<T>
    extends AbstractIterator<T> {
        ResultContinuation resultContinuation;
        boolean firstCall = true;
        final Function<AzureBlobInfo, T> transformer;
        final Queue<AzureBlobInfo> items = Lists.newLinkedList();

        public RecordsIterator(Function<AzureBlobInfo, T> transformer) {
            this.transformer = transformer;
        }

        protected T computeNext() {
            if (this.items.isEmpty()) {
                this.loadItems();
            }
            if (!this.items.isEmpty()) {
                return (T)this.transformer.apply((Object)this.items.remove());
            }
            return (T)this.endOfData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadItems() {
            long start = System.currentTimeMillis();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                CloudBlobContainer container = Utils.getBlobContainer(AzureBlobStoreBackend.this.connectionString, AzureBlobStoreBackend.this.containerName);
                if (!(this.firstCall || this.resultContinuation != null && this.resultContinuation.hasContinuation())) {
                    LOG.trace("No more records in container. containerName={}", (Object)container);
                    boolean bl = false;
                    return bl;
                }
                this.firstCall = false;
                ResultSegment results = container.listBlobsSegmented(null, false, EnumSet.noneOf(BlobListingDetails.class), null, this.resultContinuation, null, null);
                this.resultContinuation = results.getContinuationToken();
                for (ListBlobItem item : results.getResults()) {
                    if (!(item instanceof CloudBlob)) continue;
                    this.items.add(AzureBlobInfo.fromCloudBlob((CloudBlob)item));
                }
                LOG.debug("Container records batch read. batchSize={} containerName={} duration={}", new Object[]{results.getLength(), AzureBlobStoreBackend.this.containerName, System.currentTimeMillis() - start});
                boolean bl = results.getLength() > 0;
                return bl;
            }
            catch (StorageException e) {
                LOG.info("Error listing blobs. containerName={}", (Object)AzureBlobStoreBackend.this.containerName, (Object)e);
            }
            catch (DataStoreException e) {
                LOG.debug("Cannot list blobs. containerName={}", (Object)AzureBlobStoreBackend.this.containerName, (Object)e);
            }
            finally {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
            return false;
        }
    }

    private static class AzureBlobInfo {
        private final String name;
        private final long lastModified;
        private final long length;

        public AzureBlobInfo(String name, long lastModified, long length) {
            this.name = name;
            this.lastModified = lastModified;
            this.length = length;
        }

        public String getName() {
            return this.name;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getLength() {
            return this.length;
        }

        public static AzureBlobInfo fromCloudBlob(CloudBlob cloudBlob) {
            return new AzureBlobInfo(cloudBlob.getName(), cloudBlob.getProperties().getLastModified().getTime(), cloudBlob.getProperties().getLength());
        }
    }
}

