/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RetryExponentialRetry;
import com.microsoft.azure.storage.RetryNoRetry;
import com.microsoft.azure.storage.RetryPolicy;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    public static final String DEFAULT_CONFIG_FILE = "azure.properties";
    public static final String DASH = "-";

    private Utils() {
    }

    public static CloudBlobClient getBlobClient(@NotNull String connectionString) throws URISyntaxException, InvalidKeyException {
        return Utils.getBlobClient(connectionString, null);
    }

    public static CloudBlobClient getBlobClient(@NotNull String connectionString, @Nullable BlobRequestOptions requestOptions) throws URISyntaxException, InvalidKeyException {
        CloudStorageAccount account = CloudStorageAccount.parse((String)connectionString);
        CloudBlobClient client = account.createCloudBlobClient();
        if (null != requestOptions) {
            client.setDefaultRequestOptions(requestOptions);
        }
        return client;
    }

    public static CloudBlobContainer getBlobContainer(@NotNull String connectionString, @NotNull String containerName) throws DataStoreException {
        return Utils.getBlobContainer(connectionString, containerName, null);
    }

    public static CloudBlobContainer getBlobContainer(@NotNull String connectionString, @NotNull String containerName, @Nullable BlobRequestOptions requestOptions) throws DataStoreException {
        try {
            CloudBlobClient client = null == requestOptions ? Utils.getBlobClient(connectionString) : Utils.getBlobClient(connectionString, requestOptions);
            return client.getContainerReference(containerName);
        }
        catch (StorageException | URISyntaxException | InvalidKeyException e) {
            throw new DataStoreException(e);
        }
    }

    public static void setProxyIfNeeded(Properties properties) {
        String proxyHost = properties.getProperty("proxyHost");
        String proxyPort = properties.getProperty("proxyPort");
        if (!Strings.isNullOrEmpty((String)proxyHost) && Strings.isNullOrEmpty((String)proxyPort)) {
            int port = Integer.parseInt(proxyPort);
            InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, port);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
            OperationContext.setDefaultProxy((Proxy)proxy);
        }
    }

    public static RetryPolicy getRetryPolicy(String maxRequestRetry) {
        int retries = PropertiesUtil.toInteger((Object)maxRequestRetry, (int)-1);
        if (retries < 0) {
            return null;
        }
        if (retries == 0) {
            return new RetryNoRetry();
        }
        return new RetryExponentialRetry(30000, retries);
    }

    public static String getConnectionStringFromProperties(Properties properties) {
        String sasUri = properties.getProperty("azureSas", "");
        String blobEndpoint = properties.getProperty("azureBlobEndpoint", "");
        String connectionString = properties.getProperty("azureConnectionString", "");
        String accountName = properties.getProperty("accessKey", "");
        String accountKey = properties.getProperty("secretKey", "");
        if (!connectionString.isEmpty()) {
            return connectionString;
        }
        if (!sasUri.isEmpty()) {
            return Utils.getConnectionStringForSas(sasUri, blobEndpoint, accountName);
        }
        return Utils.getConnectionString(accountName, accountKey, blobEndpoint);
    }

    private static String getConnectionStringForSas(String sasUri, String blobEndpoint, String accountName) {
        if (StringUtils.isEmpty((CharSequence)blobEndpoint)) {
            return String.format("AccountName=%s;SharedAccessSignature=%s", accountName, sasUri);
        }
        return String.format("BlobEndpoint=%s;SharedAccessSignature=%s", blobEndpoint, sasUri);
    }

    public static String getConnectionString(String accountName, String accountKey) {
        return Utils.getConnectionString(accountName, accountKey, null);
    }

    public static String getConnectionString(String accountName, String accountKey, String blobEndpoint) {
        StringBuilder connString = new StringBuilder("DefaultEndpointsProtocol=https");
        connString.append(";AccountName=").append(accountName);
        connString.append(";AccountKey=").append(accountKey);
        if (!Strings.isNullOrEmpty((String)blobEndpoint)) {
            connString.append(";BlobEndpoint=").append(blobEndpoint);
        }
        return connString.toString();
    }

    public static Properties readConfig(String fileName) throws IOException {
        if (!new File(fileName).exists()) {
            throw new IOException("Config file not found. fileName=" + fileName);
        }
        Properties prop = new Properties();
        try (FileInputStream in = null;){
            in = new FileInputStream(fileName);
            prop.load(in);
        }
        return prop;
    }
}

