/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAlgorithm;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.util.StringUtils;
import java.util.Properties;

public class S3RequestDecorator {
    DataEncryption dataEncryption = DataEncryption.NONE;
    Properties props;
    SSEAwsKeyManagementParams sseParams;

    public S3RequestDecorator(Properties props) {
        String encryptionType = props.getProperty("s3Encryption");
        if (encryptionType != null) {
            this.dataEncryption = DataEncryption.valueOf(encryptionType);
            if (encryptionType.equals("SSE_KMS")) {
                String keyId = props.getProperty("kmsKeyId");
                this.sseParams = new SSEAwsKeyManagementParams();
                if (!StringUtils.isNullOrEmpty((String)keyId)) {
                    this.sseParams.withAwsKmsKeyId(keyId);
                }
            }
        }
    }

    public PutObjectRequest decorate(PutObjectRequest request) {
        ObjectMetadata metadata = request.getMetadata() == null ? new ObjectMetadata() : request.getMetadata();
        switch (this.getDataEncryption()) {
            case SSE_S3: {
                metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                break;
            }
            case SSE_KMS: {
                metadata.setSSEAlgorithm(SSEAlgorithm.KMS.getAlgorithm());
                request.withSSEAwsKeyManagementParams(this.sseParams);
                break;
            }
        }
        request.setMetadata(metadata);
        return request;
    }

    public CopyObjectRequest decorate(CopyObjectRequest request) {
        ObjectMetadata metadata = request.getNewObjectMetadata() == null ? new ObjectMetadata() : request.getNewObjectMetadata();
        switch (this.getDataEncryption()) {
            case SSE_S3: {
                metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                break;
            }
            case SSE_KMS: {
                metadata.setSSEAlgorithm(SSEAlgorithm.KMS.getAlgorithm());
                request.withSSEAwsKeyManagementParams(this.sseParams);
                break;
            }
        }
        request.setNewObjectMetadata(metadata);
        return request;
    }

    public InitiateMultipartUploadRequest decorate(InitiateMultipartUploadRequest request) {
        ObjectMetadata metadata = request.getObjectMetadata() == null ? new ObjectMetadata() : request.getObjectMetadata();
        switch (this.getDataEncryption()) {
            case SSE_S3: {
                metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                break;
            }
            case SSE_KMS: {
                metadata.setSSEAlgorithm(SSEAlgorithm.KMS.getAlgorithm());
                request.withSSEAwsKeyManagementParams(this.sseParams);
                break;
            }
        }
        request.setObjectMetadata(metadata);
        return request;
    }

    public GeneratePresignedUrlRequest decorate(GeneratePresignedUrlRequest request) {
        switch (this.getDataEncryption()) {
            case SSE_KMS: {
                String keyId = this.getSSEParams().getAwsKmsKeyId();
                request = request.withSSEAlgorithm(SSEAlgorithm.KMS.getAlgorithm());
                if (keyId == null) break;
                request = request.withKmsCmkId(keyId);
            }
        }
        return request;
    }

    private SSEAwsKeyManagementParams getSSEParams() {
        return this.sseParams;
    }

    private DataEncryption getDataEncryption() {
        return this.dataEncryption;
    }

    private static enum DataEncryption {
        SSE_S3,
        SSE_KMS,
        NONE;

    }
}

