/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.s3;

import java.net.URI;
import java.util.Properties;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3Backend;
import org.apache.jackrabbit.oak.plugins.blob.AbstractSharedCachingDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.ConfigurableDataRecordAccessProvider;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordDownloadOptions;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUpload;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadOptions;
import org.apache.jackrabbit.oak.spi.blob.AbstractSharedBackend;
import org.apache.jackrabbit.oak.spi.blob.SharedBackend;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class S3DataStore
extends AbstractSharedCachingDataStore
implements ConfigurableDataRecordAccessProvider {
    protected Properties properties;
    private S3Backend s3Backend;
    private int minRecordLength = 16384;

    protected AbstractSharedBackend createBackend() {
        this.s3Backend = new S3Backend();
        if (this.properties != null) {
            this.s3Backend.setProperties(this.properties);
        }
        return this.s3Backend;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public SharedBackend getBackend() {
        return this.backend;
    }

    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    public void setDirectUploadURIExpirySeconds(int seconds) {
        if (this.s3Backend != null) {
            this.s3Backend.setHttpUploadURIExpirySeconds(seconds);
        }
    }

    public void setBinaryTransferAccelerationEnabled(boolean enabled) {
        if (this.s3Backend != null) {
            this.s3Backend.setBinaryTransferAccelerationEnabled(enabled);
        }
    }

    @Nullable
    public DataRecordUpload initiateDataRecordUpload(long maxUploadSizeInBytes, int maxNumberOfURIs) throws IllegalArgumentException, DataRecordUploadException {
        return this.initiateDataRecordUpload(maxUploadSizeInBytes, maxNumberOfURIs, DataRecordUploadOptions.DEFAULT);
    }

    @Nullable
    public DataRecordUpload initiateDataRecordUpload(long maxUploadSizeInBytes, int maxNumberOfURIs, @NotNull DataRecordUploadOptions options) throws IllegalArgumentException, DataRecordUploadException {
        if (null == this.s3Backend) {
            throw new DataRecordUploadException("Backend not initialized");
        }
        return this.s3Backend.initiateHttpUpload(maxUploadSizeInBytes, maxNumberOfURIs);
    }

    @NotNull
    public DataRecord completeDataRecordUpload(@NotNull String uploadToken) throws IllegalArgumentException, DataRecordUploadException, DataStoreException {
        if (null == this.s3Backend) {
            throw new DataRecordUploadException("Backend not initialized");
        }
        return this.s3Backend.completeHttpUpload(uploadToken);
    }

    public void setDirectDownloadURIExpirySeconds(int seconds) {
        if (this.s3Backend != null) {
            this.s3Backend.setHttpDownloadURIExpirySeconds(seconds);
        }
    }

    public void setDirectDownloadURICacheSize(int maxSize) {
        if (this.s3Backend != null) {
            this.s3Backend.setHttpDownloadURICacheSize(maxSize);
        }
    }

    @Nullable
    public URI getDownloadURI(@NotNull DataIdentifier identifier, @NotNull DataRecordDownloadOptions downloadOptions) {
        if (this.s3Backend == null) {
            return null;
        }
        return this.s3Backend.createHttpDownloadURI(identifier, downloadOptions);
    }
}

