/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.oak.api.blob.BlobAccessProvider;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreStats;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStoreStatsMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataStoreService {
    private static final String PROP_HOME = "repository.home";
    private static final String PATH = "path";
    public static final String PROP_ENCODE_LENGTH = "encodeLengthInId";
    public static final String PROP_CACHE_SIZE = "cacheSizeInMB";
    private static final String DESCRIPTION = "oak.blobstore.description";
    private ServiceRegistration reg;
    private Registration mbeanReg;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private DataStoreBlobStore dataStore;

    protected void activate(ComponentContext context, Map<String, Object> config) throws RepositoryException {
        config = new HashMap<String, Object>(config);
        DataStore ds = this.createDataStore(context, config);
        boolean encodeLengthInId = PropertiesUtil.toBoolean((Object)config.get(PROP_ENCODE_LENGTH), (boolean)true);
        int cacheSizeInMB = PropertiesUtil.toInteger((Object)config.get(PROP_CACHE_SIZE), (int)16);
        String homeDir = AbstractDataStoreService.lookup(context, PROP_HOME);
        if (config.containsKey(PATH) && !Strings.isNullOrEmpty((String)((String)config.get(PATH)))) {
            this.log.info("Initializing the DataStore with path [{}]", config.get(PATH));
        } else if (homeDir != null) {
            this.log.info("Initializing the DataStore with homeDir [{}]", (Object)homeDir);
        }
        PropertiesUtil.populate((Object)ds, config, (boolean)false);
        ds.init(homeDir);
        BlobStoreStats stats = new BlobStoreStats(Objects.requireNonNull(this.getStatisticsProvider(), "statisticsProvider must be non-null"));
        this.dataStore = new DataStoreBlobStore(ds, encodeLengthInId, cacheSizeInMB);
        this.dataStore.setBlobStatsCollector(stats);
        PropertiesUtil.populate((Object)this.dataStore, config, (boolean)false);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", ds.getClass().getName());
        ((Dictionary)props).put(DESCRIPTION, this.getDescription());
        if (context.getProperties().get("split.blobstore") != null) {
            ((Dictionary)props).put("split.blobstore", context.getProperties().get("split.blobstore"));
        }
        this.reg = context.getBundleContext().registerService(new String[]{BlobStore.class.getName(), GarbageCollectableBlobStore.class.getName(), BlobAccessProvider.class.getName()}, (Object)this.dataStore, props);
        this.mbeanReg = AbstractDataStoreService.registerMBeans(context.getBundleContext(), this.dataStore, stats);
    }

    protected void deactivate() throws DataStoreException {
        if (this.reg != null) {
            this.reg.unregister();
        }
        if (this.mbeanReg != null) {
            this.mbeanReg.unregister();
        }
        this.dataStore.close();
    }

    protected abstract DataStore createDataStore(ComponentContext var1, Map<String, Object> var2);

    @NotNull
    protected abstract StatisticsProvider getStatisticsProvider();

    protected abstract void setStatisticsProvider(StatisticsProvider var1);

    protected String[] getDescription() {
        return new String[]{"type=unknown"};
    }

    protected static String lookup(ComponentContext context, String property) {
        if (context.getBundleContext().getProperty(property) != null) {
            return context.getBundleContext().getProperty(property);
        }
        if (context.getProperties().get(property) != null) {
            return context.getProperties().get(property).toString();
        }
        return null;
    }

    private static Registration registerMBeans(BundleContext context, DataStoreBlobStore ds, BlobStoreStats stats) {
        OsgiWhiteboard wb = new OsgiWhiteboard(context);
        return new CompositeRegistration(new Registration[]{WhiteboardUtils.registerMBean((Whiteboard)wb, BlobStoreStatsMBean.class, (Object)stats, (String)"BlobStoreStats", (String)ds.getClass().getSimpleName()), WhiteboardUtils.registerMBean((Whiteboard)wb, CacheStatsMBean.class, (Object)ds.getCacheStats(), (String)"CacheStats", (String)ds.getCacheStats().getName())});
    }
}

