/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.UnmodifiableIterator;
import org.apache.jackrabbit.guava.common.util.concurrent.ListenableFutureTask;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.commons.FileIOUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.io.FileLineDifferenceIterator;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.BlobTrackingStore;
import org.apache.jackrabbit.oak.plugins.blob.GarbageCollectionRepoStats;
import org.apache.jackrabbit.oak.plugins.blob.GarbageCollectorFileState;
import org.apache.jackrabbit.oak.plugins.blob.OperationStatsCollector;
import org.apache.jackrabbit.oak.plugins.blob.OperationsStatsMBean;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobIdTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkSweepGarbageCollector
implements BlobGarbageCollector {
    public static final Logger LOG = LoggerFactory.getLogger(MarkSweepGarbageCollector.class);
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static final int DEFAULT_BATCH_COUNT = 1024;
    public static final String DELIM = ",";
    private static final Function<String, String> transformer = new Function<String, String>(){

        @Override
        @Nullable
        public String apply(@Nullable String input) {
            if (input != null) {
                return input.split(MarkSweepGarbageCollector.DELIM)[0];
            }
            return "";
        }
    };
    private final long maxLastModifiedInterval;
    private final GarbageCollectableBlobStore blobStore;
    private boolean checkConsistencyAfterGc;
    private final boolean sweepIfRefsPastRetention;
    private final BlobReferenceRetriever marker;
    private final Executor executor;
    private final int batchCount;
    private final String repoId;
    private final String root;
    private final Whiteboard whiteboard;
    private CheckpointMBean checkpointMbean;
    private final GarbageCollectionOperationStats stats;
    private final OperationStatsCollector statsCollector;
    private final GarbageCollectionOperationStats consistencyStats;
    private final OperationStatsCollector consistencyStatsCollector;
    private boolean traceOutput;
    private Clock clock;

    public MarkSweepGarbageCollector(BlobReferenceRetriever marker, GarbageCollectableBlobStore blobStore, Executor executor, String root, int batchCount, long maxLastModifiedInterval, boolean checkConsistencyAfterGc, boolean sweepIfRefsPastRetention, @Nullable String repositoryId, @Nullable Whiteboard whiteboard, @Nullable StatisticsProvider statisticsProvider) throws IOException {
        this.executor = executor;
        this.blobStore = blobStore;
        this.checkConsistencyAfterGc = checkConsistencyAfterGc;
        this.sweepIfRefsPastRetention = sweepIfRefsPastRetention;
        Objects.requireNonNull(blobStore, "BlobStore cannot be null");
        this.marker = marker;
        this.batchCount = batchCount;
        this.maxLastModifiedInterval = maxLastModifiedInterval;
        this.repoId = repositoryId;
        this.root = root;
        this.whiteboard = whiteboard;
        if (whiteboard != null) {
            this.checkpointMbean = (CheckpointMBean)WhiteboardUtils.getService((Whiteboard)whiteboard, CheckpointMBean.class);
        }
        if (statisticsProvider == null) {
            statisticsProvider = StatisticsProvider.NOOP;
        }
        this.stats = new GarbageCollectionOperationStats(statisticsProvider);
        this.statsCollector = this.stats.getCollector();
        this.consistencyStats = new GarbageCollectionOperationStats(statisticsProvider, "DataStoreConsistencyCheck");
        this.consistencyStatsCollector = this.consistencyStats.getCollector();
        this.clock = Clock.SIMPLE;
    }

    public MarkSweepGarbageCollector(BlobReferenceRetriever marker, GarbageCollectableBlobStore blobStore, Executor executor, String root, int batchCount, long maxLastModifiedInterval, @Nullable String repositoryId) throws IOException {
        this(marker, blobStore, executor, root, batchCount, maxLastModifiedInterval, false, false, repositoryId, null, null);
    }

    public MarkSweepGarbageCollector(BlobReferenceRetriever marker, GarbageCollectableBlobStore blobStore, Executor executor, long maxLastModifiedInterval, @Nullable String repositoryId, @Nullable Whiteboard whiteboard, @Nullable StatisticsProvider statisticsProvider) throws IOException {
        this(marker, blobStore, executor, TEMP_DIR, 1024, maxLastModifiedInterval, false, false, repositoryId, whiteboard, statisticsProvider);
    }

    @Override
    public void collectGarbage(boolean markOnly) throws Exception {
        this.markAndSweep(markOnly, false);
    }

    @Override
    public void collectGarbage(boolean markOnly, boolean forceBlobRetrieve) throws Exception {
        this.markAndSweep(markOnly, forceBlobRetrieve);
    }

    @Override
    public List<GarbageCollectionRepoStats> getStats() throws Exception {
        ArrayList<GarbageCollectionRepoStats> stats = new ArrayList<GarbageCollectionRepoStats>();
        if (SharedDataStoreUtils.isShared((BlobStore)this.blobStore)) {
            List<DataRecord> refFiles = ((SharedDataStore)this.blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType());
            ArrayListValuedHashMap references = new ArrayListValuedHashMap();
            for (DataRecord input2 : refFiles) {
                references.put((Object)SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getIdFromName(input2.getIdentifier().toString()), (Object)input2);
            }
            List<DataRecord> markerFiles = ((SharedDataStore)this.blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getType());
            Map markers = markerFiles.stream().collect(Collectors.toUnmodifiableMap(input -> input.getIdentifier().toString().substring(SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getType().length() + 1), Function.identity()));
            List<DataRecord> repoFiles = ((SharedDataStore)this.blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getType());
            for (DataRecord repoRec : repoFiles) {
                String id = SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getIdFromName(repoRec.getIdentifier().toString());
                GarbageCollectionRepoStats stat = new GarbageCollectionRepoStats();
                stats.add(stat);
                stat.setRepositoryId(id);
                if (id != null && id.equals(this.repoId)) {
                    stat.setLocal(true);
                }
                if (!references.containsKey((Object)id)) continue;
                for (DataRecord refRec : references.get((Object)id)) {
                    String uniqueSessionId = refRec.getIdentifier().toString().substring(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType().length() + 1);
                    stat.setEndTime(refRec.getLastModified());
                    stat.setLength(refRec.getLength());
                    if (markers.containsKey(uniqueSessionId)) {
                        stat.setStartTime(((DataRecord)markers.get(uniqueSessionId)).getLastModified());
                    }
                    try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(refRec.getStream()));){
                        while (reader.readLine() != null) {
                        }
                        stat.setNumLines(reader.getLineNumber());
                    }
                }
            }
        }
        return stats;
    }

    @Override
    public OperationsStatsMBean getOperationStats() {
        return this.stats;
    }

    @Override
    public OperationsStatsMBean getConsistencyOperationStats() {
        return this.consistencyStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAndSweep(boolean markOnly, boolean forceBlobRetrieve) throws Exception {
        block19: {
            this.statsCollector.start();
            boolean threw = true;
            GarbageCollectorFileState fs = new GarbageCollectorFileState(this.root);
            Stopwatch sw = Stopwatch.createStarted();
            try {
                long markFinish;
                LOG.info("Starting Blob garbage collection with markOnly [{}] for repositoryId [{}]", (Object)markOnly, (Object)this.repoId);
                long markStart = System.currentTimeMillis();
                try {
                    this.mark(fs);
                }
                finally {
                    markFinish = sw.elapsed(TimeUnit.MILLISECONDS);
                    this.statsCollector.updateMarkDuration(markFinish, TimeUnit.MILLISECONDS);
                    LOG.info("Blob garbage collection Mark completed in {} ({} ms).", (Object)sw.toString(), (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                }
                if (markOnly) break block19;
                try {
                    long deleteCount = this.sweep(fs, markStart, forceBlobRetrieve);
                    long maxTime = this.getMaxModifiedTime(markStart) > 0L ? this.getMaxModifiedTime(markStart) : markStart;
                    LOG.info("Blob garbage collection completed in {} ({} ms). Number of blobs deleted [{}] with max modification time of [{}]", new Object[]{sw.toString(), sw.elapsed(TimeUnit.MILLISECONDS), deleteCount, MarkSweepGarbageCollector.timestampToString(maxTime)});
                    threw = false;
                }
                catch (NotAllRepositoryMarkedException rm) {
                    this.statsCollector.finishFailure();
                }
                finally {
                    sw.stop();
                    this.statsCollector.updateSweepDuration(sw.elapsed(TimeUnit.MILLISECONDS) - markFinish, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                this.statsCollector.finishFailure();
                LOG.error("Blob garbage collection error", (Throwable)e);
                throw e;
            }
            finally {
                block20: {
                    this.statsCollector.updateDuration(sw.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                    if (!LOG.isTraceEnabled() && !this.traceOutput) {
                        try {
                            org.apache.commons.io.IOUtils.close((Closeable)fs);
                        }
                        catch (IOException ioe) {
                            if (threw) break block20;
                            throw ioe;
                        }
                    }
                }
            }
        }
    }

    protected void mark(GarbageCollectorFileState fs) throws IOException, DataStoreException {
        LOG.debug("Starting mark phase of the garbage collector");
        String uniqueSuffix = UUID.randomUUID().toString();
        GarbageCollectionType.get(this.blobStore).addMarkedStartMarker(this.blobStore, this.repoId, uniqueSuffix);
        this.iterateNodeTree(fs, false);
        MarkSweepGarbageCollector.getBlobReferencesSize(fs, this.stats);
        GarbageCollectionType.get(this.blobStore).addMarked(this.blobStore, fs, this.repoId, uniqueSuffix);
        LOG.debug("Ending mark phase of the garbage collector");
    }

    private static void getBlobReferencesSize(GarbageCollectorFileState fs, GarbageCollectionOperationStats stats) throws IOException {
        try (LineIterator lineIterator = new LineIterator((Reader)new FileReader(fs.getMarkedRefs()));){
            lineIterator.forEachRemaining(line -> {
                String id = line.split(DELIM)[0];
                long length = DataStoreBlobStore.BlobId.of(id).getLength();
                LOG.debug("Blob {} has size {}", (Object)id, (Object)length);
                stats.getCollector().updateNumBlobReferences(1L);
                if (length != -1L) {
                    stats.getCollector().updateBlobReferencesSize(length);
                }
            });
        }
        LOG.info("Blob references found : {} with size : {}", (Object)stats.getNumBlobReferences(), (Object)stats.getBlobReferencesSize());
    }

    private void difference(GarbageCollectorFileState fs) throws IOException {
        LOG.debug("Starting difference phase of the garbage collector");
        FileLineDifferenceIterator iter = new FileLineDifferenceIterator(fs.getMarkedRefs(), fs.getAvailableRefs(), transformer);
        int candidates = FileIOUtils.writeStrings((Iterator)iter, (File)fs.getGcCandidates(), (boolean)true);
        LOG.debug("Found candidates - " + candidates);
        LOG.debug("Ending difference phase of the garbage collector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sweep(GarbageCollectorFileState fs, long markStart, boolean forceBlobRetrieve) throws Exception {
        long earliestRefAvailTime = GarbageCollectionType.get(this.blobStore).mergeAllMarkedReferences(this.blobStore, fs, this.clock, this.maxLastModifiedInterval, this.sweepIfRefsPastRetention);
        LOG.debug("Earliest reference available for timestamp [{}]", (Object)earliestRefAvailTime);
        earliestRefAvailTime = earliestRefAvailTime < markStart ? earliestRefAvailTime : markStart;
        new BlobIdRetriever(fs, forceBlobRetrieve).call();
        this.difference(fs);
        long count = 0L;
        long deleted = 0L;
        long maxModifiedTime = this.getMaxModifiedTime(earliestRefAvailTime);
        LOG.debug("Starting sweep phase of the garbage collector");
        LOG.debug("Sweeping blobs with modified time > than the configured max deleted time ({}). ", (Object)MarkSweepGarbageCollector.timestampToString(maxModifiedTime));
        BufferedWriter removesWriter = null;
        LineIterator iterator = null;
        long deletedSize = 0L;
        int numDeletedSizeAvailable = 0;
        try {
            removesWriter = new BufferedWriter(new FileWriter(fs.getGarbage(), StandardCharsets.UTF_8));
            ArrayDeque<String> removesQueue = new ArrayDeque<String>();
            iterator = FileUtils.lineIterator((File)fs.getGcCandidates(), (String)StandardCharsets.UTF_8.name());
            UnmodifiableIterator partitions = Iterators.partition((Iterator)iterator, (int)this.getBatchCount());
            while (partitions.hasNext()) {
                List ids = (List)partitions.next();
                count += (long)ids.size();
                deleted += BlobCollectionType.get(this.blobStore).sweepInternal(this.blobStore, ids, removesQueue, maxModifiedTime);
                MarkSweepGarbageCollector.saveBatchToFile(new ArrayList<String>(removesQueue), removesWriter);
                for (String deletedId : removesQueue) {
                    long length = DataStoreBlobStore.BlobId.of(deletedId).getLength();
                    if (length == -1L) continue;
                    deletedSize += length;
                    ++numDeletedSizeAvailable;
                }
                removesQueue.clear();
            }
        }
        catch (Throwable throwable) {
            LineIterator.closeQuietly(iterator);
            IOUtils.closeQuietly(removesWriter);
            throw throwable;
        }
        LineIterator.closeQuietly((LineIterator)iterator);
        IOUtils.closeQuietly((Closeable)removesWriter);
        if (this.checkConsistencyAfterGc) {
            BlobCollectionType.get(this.blobStore).checkConsistencyAfterGC(this.blobStore, fs, this.consistencyStats);
        }
        BlobCollectionType.get(this.blobStore).handleRemoves(this.blobStore, fs.getGarbage(), fs.getMarkedRefs());
        if (count != deleted) {
            LOG.warn("Deleted only [{}] blobs entries from the [{}] candidates identified. This may happen if blob modified time is > than the max deleted time ({})", new Object[]{deleted, count, MarkSweepGarbageCollector.timestampToString(maxModifiedTime)});
        }
        if (deletedSize > 0L) {
            LOG.info("Estimated size recovered for {} deleted blobs is {} ({} bytes)", new Object[]{numDeletedSizeAvailable, IOUtils.humanReadableByteCount((long)deletedSize), deletedSize});
        }
        this.statsCollector.updateNumCandidates(count);
        this.statsCollector.updateNumDeleted(deleted);
        this.statsCollector.updateTotalSizeDeleted(deletedSize);
        GarbageCollectionType.get(this.blobStore).removeAllMarkedReferences(this.blobStore);
        LOG.debug("Ending sweep phase of the garbage collector");
        return deleted;
    }

    private int getBatchCount() {
        return this.batchCount;
    }

    private long getMaxModifiedTime(long maxModificationReferenceTime) {
        if (this.maxLastModifiedInterval <= 0L) {
            return 0L;
        }
        long oldestCheckpoint = -1L;
        if (this.checkpointMbean != null) {
            oldestCheckpoint = this.checkpointMbean.getOldestCheckpointCreationDate().getTime();
            LOG.debug("Oldest checkpoint data retrieved {} ", (Object)oldestCheckpoint);
        }
        LOG.debug("maxModificationReferenceTime {} ", (Object)maxModificationReferenceTime);
        maxModificationReferenceTime = maxModificationReferenceTime <= 0L ? System.currentTimeMillis() : maxModificationReferenceTime;
        long calculatedReferenceTime = oldestCheckpoint <= 0L ? maxModificationReferenceTime : Math.min(maxModificationReferenceTime, oldestCheckpoint);
        LOG.debug("Calculated reference time {} ", (Object)calculatedReferenceTime);
        return calculatedReferenceTime - this.maxLastModifiedInterval;
    }

    static void saveBatchToFile(List<String> ids, BufferedWriter writer) throws IOException {
        for (String id : ids) {
            FileIOUtils.writeAsLine((BufferedWriter)writer, (String)id, (boolean)true);
        }
        writer.flush();
    }

    protected void iterateNodeTree(GarbageCollectorFileState fs, final boolean logPath) throws IOException {
        final AtomicInteger count = new AtomicInteger();
        try (final BufferedWriter writer = new BufferedWriter(new FileWriter(fs.getMarkedRefs(), StandardCharsets.UTF_8));){
            this.marker.collectReferences(new ReferenceCollector(){
                private final boolean debugMode = LOG.isTraceEnabled();

                @Override
                public void addReference(String blobId, String nodeId) {
                    if (this.debugMode) {
                        LOG.trace("BlobId : {}, NodeId : {}", (Object)blobId, (Object)nodeId);
                    }
                    try {
                        Iterator idIter = MarkSweepGarbageCollector.this.blobStore.resolveChunks(blobId);
                        UnmodifiableIterator partitions = Iterators.partition((Iterator)idIter, (int)MarkSweepGarbageCollector.this.getBatchCount());
                        while (partitions.hasNext()) {
                            List<String> idBatch = ((List)partitions.next()).stream().map(id -> {
                                if (logPath && nodeId != null) {
                                    return id + MarkSweepGarbageCollector.DELIM + nodeId;
                                }
                                return id;
                            }).collect(Collectors.toList());
                            if (this.debugMode) {
                                LOG.trace("chunkIds : {}", idBatch);
                            }
                            count.getAndAdd(idBatch.size());
                            MarkSweepGarbageCollector.saveBatchToFile(idBatch, writer);
                        }
                        if (count.get() > 0 && count.get() % MarkSweepGarbageCollector.this.getBatchCount() == 0) {
                            LOG.info("Collected ({}) blob references", (Object)count.get());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error in retrieving references", e);
                    }
                }
            });
        }
        LOG.info("Number of valid blob references marked under mark phase of Blob garbage collection [{}]", (Object)count.get());
        FileIOUtils.sort((File)fs.getMarkedRefs(), (s1, s2) -> s1.split(DELIM)[0].compareTo(s2.split(DELIM)[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long checkConsistency(boolean markOnly) throws Exception {
        long candidates;
        block20: {
            this.consistencyStatsCollector.start();
            Stopwatch sw = Stopwatch.createStarted();
            boolean threw = true;
            GarbageCollectorFileState fs = new GarbageCollectorFileState(this.root);
            candidates = 0L;
            try {
                LOG.info("Starting blob consistency check with markOnly = {}", (Object)markOnly);
                String uniqueSuffix = UUID.randomUUID().toString();
                GarbageCollectionType.get(this.blobStore).addMarkedStartMarker(this.blobStore, this.repoId, uniqueSuffix);
                this.iterateNodeTree(fs, true);
                GarbageCollectionType.get(this.blobStore).addMarked(this.blobStore, fs, this.repoId, uniqueSuffix);
                this.consistencyStatsCollector.updateMarkDuration(sw.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                if (SharedDataStoreUtils.isShared((BlobStore)this.blobStore)) {
                    List<DataRecord> refFiles = ((SharedDataStore)this.blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType());
                    List<DataRecord> repoFiles = ((SharedDataStore)this.blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getType());
                    LOG.info("Repositories registered {}", repoFiles);
                    Set<String> unAvailRepos = SharedDataStoreUtils.refsNotAvailableFromRepos(repoFiles, refFiles);
                    LOG.info("Repositories with unavailable references {}", unAvailRepos);
                    if (!unAvailRepos.isEmpty()) {
                        throw new NotAllRepositoryMarkedException("Not all repositories have marked references available");
                    }
                    if (refFiles.size() > 0) {
                        File temp = new File(this.root, this.repoId + UUID.randomUUID().toString());
                        FileUtils.copyFile((File)fs.getMarkedRefs(), (File)temp);
                        ArrayList<File> files = new ArrayList<File>();
                        files.add(temp);
                        for (DataRecord refFile : refFiles) {
                            File file = FileIOUtils.copy((InputStream)refFile.getStream());
                            files.add(file);
                        }
                        FileIOUtils.merge(files, (File)fs.getMarkedRefs(), Comparator.comparing(s -> s.split(DELIM)[0]));
                    }
                }
                MarkSweepGarbageCollector.getBlobReferencesSize(fs, this.consistencyStats);
                if (markOnly) break block20;
                ListenableFutureTask blobIdRetriever = ListenableFutureTask.create((Callable)new BlobIdRetriever(fs, true));
                this.executor.execute((Runnable)blobIdRetriever);
                try {
                    blobIdRetriever.get();
                }
                catch (ExecutionException e) {
                    LOG.warn("Error occurred while fetching all the blobIds from the BlobStore");
                    threw = false;
                    throw e;
                }
                LOG.trace("Starting difference phase of the consistency check");
                FileLineDifferenceIterator iter = new FileLineDifferenceIterator(fs.getAvailableRefs(), fs.getMarkedRefs(), transformer);
                candidates = BlobCollectionType.get(this.blobStore).filter(this.blobStore, iter, fs);
                GarbageCollectionType.get(this.blobStore).removeAllMarkedReferences(this.blobStore);
                LOG.trace("Ending difference phase of the consistency check");
                LOG.info("Consistency check found [{}] missing blobs", (Object)candidates);
                if (candidates <= 0L) break block20;
                try (LineIterator lineIterator = new LineIterator((Reader)new FileReader(fs.getGcCandidates()));){
                    while (lineIterator.hasNext()) {
                        LOG.warn("Missing Blob [{}]", (Object)lineIterator.nextLine());
                    }
                }
                LOG.warn("Consistency check failure in the the blob store : {}, check missing candidates in file {}", (Object)this.blobStore, (Object)fs.getGcCandidates().getAbsolutePath());
                this.consistencyStatsCollector.finishFailure();
                this.consistencyStatsCollector.updateNumDeleted(candidates);
            }
            finally {
                block22: {
                    if (!this.traceOutput && !LOG.isTraceEnabled() && candidates == 0L) {
                        try {
                            org.apache.commons.io.IOUtils.close((Closeable)fs);
                        }
                        catch (IOException ioe) {
                            if (threw) break block22;
                            throw ioe;
                        }
                    }
                }
                sw.stop();
                this.consistencyStatsCollector.updateDuration(sw.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            }
        }
        return candidates;
    }

    @Override
    public long checkConsistency() throws Exception {
        return this.checkConsistency(false);
    }

    public void setTraceOutput(boolean trace) {
        this.traceOutput = trace;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    private static String timestampToString(long timestamp) {
        return (new Timestamp(timestamp) + "00").substring(0, 23);
    }

    static class NotAllRepositoryMarkedException
    extends IOException {
        public NotAllRepositoryMarkedException(String message) {
            super(message);
        }
    }

    class GarbageCollectionOperationStats
    implements OperationsStatsMBean {
        static final String NAME = "DataStoreGarbageCollection";
        static final String CONSISTENCY_NAME = "DataStoreConsistencyCheck";
        static final String START = "COUNTER";
        static final String FINISH_FAILURE = "FAILURE";
        static final String DURATION = "ACTIVE_TIMER";
        static final String MARK_DURATION = "MARK_TIMER";
        static final String SWEEP_DURATION = "SWEEP_TIMER";
        static final String NUM_BLOBS_DELETED = "NUM_BLOBS_DELETED";
        static final String TOTAL_SIZE_DELETED = "TOTAL_SIZE_DELETED";
        static final String NUM_CANDIDATES = "NUM_CANDIDATES";
        static final String NUM_BLOB_REFERENCES = "NUM_BLOB_REFERENCES";
        static final String BLOB_REFERENCES_SIZE = "BLOB_REFERENCES_SIZE";
        private final String typeName;
        private CounterStats startCounter;
        private CounterStats finishFailureCounter;
        private CounterStats numDeletedCounter;
        private CounterStats totalSizeDeletedCounter;
        private CounterStats numCandidatesCounter;
        private CounterStats numBlobReferencesCounter;
        private CounterStats blobReferencesSizeCounter;
        private TimerStats duration;
        private final TimerStats markDuration;
        private final TimerStats sweepDuration;
        private final OperationStatsCollector collector;

        GarbageCollectionOperationStats(StatisticsProvider sp, String typeName) {
            this.typeName = typeName;
            this.startCounter = sp.getCounterStats(this.getMetricName(START), StatsOptions.METRICS_ONLY);
            this.finishFailureCounter = sp.getCounterStats(this.getMetricName(FINISH_FAILURE), StatsOptions.METRICS_ONLY);
            this.numDeletedCounter = sp.getCounterStats(this.getMetricName(NUM_BLOBS_DELETED), StatsOptions.METRICS_ONLY);
            this.totalSizeDeletedCounter = sp.getCounterStats(this.getMetricName(TOTAL_SIZE_DELETED), StatsOptions.METRICS_ONLY);
            this.numCandidatesCounter = sp.getCounterStats(this.getMetricName(NUM_CANDIDATES), StatsOptions.METRICS_ONLY);
            this.numBlobReferencesCounter = sp.getCounterStats(this.getMetricName(NUM_BLOB_REFERENCES), StatsOptions.METRICS_ONLY);
            this.blobReferencesSizeCounter = sp.getCounterStats(this.getMetricName(BLOB_REFERENCES_SIZE), StatsOptions.METRICS_ONLY);
            this.duration = sp.getTimer(this.getMetricName(DURATION), StatsOptions.METRICS_ONLY);
            this.markDuration = sp.getTimer(this.getMetricName(MARK_DURATION), StatsOptions.METRICS_ONLY);
            this.sweepDuration = sp.getTimer(this.getMetricName(SWEEP_DURATION), StatsOptions.METRICS_ONLY);
            this.collector = new OperationStatsCollector(){

                @Override
                public void start() {
                    GarbageCollectionOperationStats.this.startCounter.inc();
                }

                @Override
                public void finishFailure() {
                    GarbageCollectionOperationStats.this.finishFailureCounter.inc();
                }

                @Override
                public void updateNumDeleted(long num) {
                    GarbageCollectionOperationStats.this.numDeletedCounter.inc(num);
                }

                @Override
                public void updateNumCandidates(long num) {
                    GarbageCollectionOperationStats.this.numCandidatesCounter.inc(num);
                }

                @Override
                public void updateTotalSizeDeleted(long size) {
                    GarbageCollectionOperationStats.this.totalSizeDeletedCounter.inc(size);
                }

                @Override
                public void updateNumBlobReferences(long num) {
                    GarbageCollectionOperationStats.this.numBlobReferencesCounter.inc(num);
                }

                @Override
                public void updateBlobReferencesSize(long size) {
                    GarbageCollectionOperationStats.this.blobReferencesSizeCounter.inc(size);
                }

                @Override
                public void updateDuration(long time, TimeUnit timeUnit) {
                    GarbageCollectionOperationStats.this.duration.update(time, timeUnit);
                }

                @Override
                public void updateMarkDuration(long time, TimeUnit timeUnit) {
                    GarbageCollectionOperationStats.this.markDuration.update(time, timeUnit);
                }

                @Override
                public void updateSweepDuration(long time, TimeUnit timeUnit) {
                    GarbageCollectionOperationStats.this.sweepDuration.update(time, timeUnit);
                }
            };
        }

        GarbageCollectionOperationStats(StatisticsProvider sp) {
            this(sp, NAME);
        }

        private String getMetricName(String name) {
            return this.getName() + "." + name;
        }

        protected OperationStatsCollector getCollector() {
            return this.collector;
        }

        @Override
        public String getName() {
            return "OperationStats." + this.typeName;
        }

        @Override
        public long getStartCount() {
            return this.startCounter.getCount();
        }

        @Override
        public long getFailureCount() {
            return this.finishFailureCounter.getCount();
        }

        @Override
        public long duration() {
            return this.duration.getCount();
        }

        @Override
        public long markDuration() {
            return this.markDuration.getCount();
        }

        @Override
        public long numDeleted() {
            return this.numDeletedCounter.getCount();
        }

        @Override
        public long sizeDeleted() {
            return this.totalSizeDeletedCounter.getCount();
        }

        @Override
        public long getNumBlobReferences() {
            return this.numBlobReferencesCounter.getCount();
        }

        @Override
        public long getBlobReferencesSize() {
            return this.blobReferencesSizeCounter.getCount();
        }
    }

    private static enum BlobCollectionType {
        TRACKER{

            @Override
            void retrieve(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, int batchCount) throws Exception {
                ((BlobTrackingStore)blobStore).getTracker().get(fs.getAvailableRefs().getAbsolutePath());
            }

            @Override
            void handleRemoves(GarbageCollectableBlobStore blobStore, File removedIds, File markedRefs) throws IOException {
                BlobTrackingStore store = (BlobTrackingStore)blobStore;
                BlobIdTracker tracker = (BlobIdTracker)store.getTracker();
                tracker.remove(removedIds);
                tracker.getDeleteTracker().reconcile(markedRefs);
            }

            @Override
            void track(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs) {
                try {
                    File f = File.createTempFile("blobiddownload", null);
                    FileUtils.copyFile((File)fs.getAvailableRefs(), (File)f);
                    ((BlobTrackingStore)blobStore).getTracker().add(f);
                }
                catch (IOException e) {
                    LOG.warn("Unable to track blob ids locally");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int filter(GarbageCollectableBlobStore blobStore, FileLineDifferenceIterator iter, GarbageCollectorFileState fs) throws IOException {
                FileIOUtils.writeStrings((Iterator)iter, (File)fs.getGcCandidates(), (boolean)true);
                BlobTrackingStore store = (BlobTrackingStore)blobStore;
                BlobIdTracker tracker = (BlobIdTracker)store.getTracker();
                File candTemp = File.createTempFile("candTemp", null);
                FileUtils.copyFile((File)fs.getGcCandidates(), (File)candTemp);
                Iterator<String> filter = tracker.getDeleteTracker().filter(candTemp);
                try {
                    int n = FileIOUtils.writeStrings(filter, (File)fs.getGcCandidates(), (boolean)true);
                    return n;
                }
                finally {
                    if (filter != null && filter instanceof FileLineDifferenceIterator) {
                        ((FileLineDifferenceIterator)filter).close();
                    }
                    if (candTemp != null) {
                        candTemp.delete();
                    }
                }
            }
        }
        ,
        DEFAULT;


        long sweepInternal(GarbageCollectableBlobStore blobStore, List<String> ids, ArrayDeque<String> exceptionQueue, long maxModified) {
            long totalDeleted = 0L;
            LOG.trace("Blob ids to be deleted {}", ids);
            for (String id : ids) {
                try {
                    long deleted = blobStore.countDeleteChunks(new ArrayList<String>(Arrays.asList(id)), maxModified);
                    if (deleted != 1L) {
                        LOG.debug("Blob [{}] not deleted", (Object)id);
                        continue;
                    }
                    exceptionQueue.add(id);
                    ++totalDeleted;
                }
                catch (Exception e) {
                    LOG.warn("Error occurred while deleting blob with id [{}]", (Object)id, (Object)e);
                }
            }
            return totalDeleted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void retrieve(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, int batchCount) throws Exception {
            LOG.debug("Starting retrieve of all blobs");
            int blobsCount = 0;
            Iterator idsIter = null;
            try {
                idsIter = blobStore.getAllChunkIds(0L);
                blobsCount = FileIOUtils.writeStrings((Iterator)idsIter, (File)fs.getAvailableRefs(), (boolean)true, (Logger)LOG, (String)"Retrieved blobs - ");
                FileIOUtils.sort((File)fs.getAvailableRefs());
                LOG.info("Number of blobs present in BlobStore : [{}] ", (Object)blobsCount);
            }
            finally {
                if (idsIter instanceof Closeable) {
                    try {
                        ((Closeable)((Object)idsIter)).close();
                    }
                    catch (Exception e) {
                        LOG.debug("Error closing iterator");
                    }
                }
            }
        }

        void handleRemoves(GarbageCollectableBlobStore blobStore, File removedIds, File markedRefs) throws IOException {
            FileUtils.forceDelete((File)removedIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkConsistencyAfterGC(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, GarbageCollectionOperationStats stats) throws IOException {
            stats.getCollector().start();
            Stopwatch sw = Stopwatch.createStarted();
            try {
                File availAfterGC = new File(fs.getAvailableRefs().getParent(), "availAfterGC");
                try (FileLineDifferenceIterator iterator = null;){
                    iterator = new FileLineDifferenceIterator(fs.getGarbage(), fs.getAvailableRefs(), null);
                    FileIOUtils.writeStrings((Iterator)iterator, (File)availAfterGC, (boolean)false);
                }
                LOG.trace("Starting difference phase of the consistency check");
                FileLineDifferenceIterator iter = new FileLineDifferenceIterator(availAfterGC, fs.getMarkedRefs(), transformer);
                File consistencyCandidatesAfterGC = new File(fs.getGcCandidates().getParent(), "consistencyCandidatesAfterGC");
                int candidates = FileIOUtils.writeStrings((Iterator)iter, (File)consistencyCandidatesAfterGC, (boolean)true);
                LOG.trace("Ending difference phase of the consistency check");
                LOG.warn("Consistency check found [{}] missing blobs", (Object)candidates);
                if (candidates > 0) {
                    try (LineIterator lineIterator = new LineIterator((Reader)new FileReader(consistencyCandidatesAfterGC));){
                        while (lineIterator.hasNext()) {
                            LOG.warn("Missing Blob [{}]", (Object)lineIterator.nextLine());
                        }
                    }
                    LOG.warn("Consistency check failure in the the blob store after GC : {}", (Object)blobStore);
                    stats.getCollector().finishFailure();
                    stats.getCollector().updateNumDeleted(candidates);
                }
                MarkSweepGarbageCollector.getBlobReferencesSize(fs, stats);
            }
            finally {
                sw.stop();
                stats.getCollector().updateDuration(sw.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            }
        }

        void track(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs) {
        }

        public static BlobCollectionType get(GarbageCollectableBlobStore blobStore) {
            BlobTracker tracker;
            if (blobStore instanceof BlobTrackingStore && (tracker = ((BlobTrackingStore)blobStore).getTracker()) != null) {
                return TRACKER;
            }
            return DEFAULT;
        }

        public int filter(GarbageCollectableBlobStore blobStore, FileLineDifferenceIterator iter, GarbageCollectorFileState fs) throws IOException {
            return FileIOUtils.writeStrings((Iterator)iter, (File)fs.getGcCandidates(), (boolean)true);
        }
    }

    static enum GarbageCollectionType {
        SHARED{

            @Override
            void removeAllMarkedReferences(GarbageCollectableBlobStore blobStore) {
                ((SharedDataStore)blobStore).deleteAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType());
                ((SharedDataStore)blobStore).deleteAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getType());
            }

            @Override
            long mergeAllMarkedReferences(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, Clock clock, long maxLastModifiedInterval, boolean sweepIfRefsPastRetention) throws IOException, DataStoreException {
                List<DataRecord> refFiles = ((SharedDataStore)blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getType());
                LOG.info("References available {}", refFiles);
                List<DataRecord> repoFiles = ((SharedDataStore)blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getType());
                LOG.info("Repositories registered {}", repoFiles);
                Set<String> unAvailRepos = SharedDataStoreUtils.refsNotAvailableFromRepos(repoFiles, refFiles);
                LOG.info("Repositories with unavailable references {}", unAvailRepos);
                Set<String> notOldRefs = Collections.EMPTY_SET;
                long retentionTime = clock.getTime() - maxLastModifiedInterval;
                LOG.info("Retention time calculated [{}]", (Object)retentionTime);
                if (sweepIfRefsPastRetention) {
                    notOldRefs = SharedDataStoreUtils.refsNotOld(repoFiles, refFiles, retentionTime);
                    LOG.info("Repositories not having older references than retention time {}", notOldRefs);
                }
                if (unAvailRepos.isEmpty() && notOldRefs.isEmpty()) {
                    ArrayList<File> files = new ArrayList<File>();
                    for (DataRecord refFile : refFiles) {
                        File file = FileIOUtils.copy((InputStream)refFile.getStream());
                        files.add(file);
                    }
                    FileIOUtils.merge(files, (File)fs.getMarkedRefs());
                    List<DataRecord> markerFiles = ((SharedDataStore)blobStore).getAllMetadataRecords(SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getType());
                    long earliestMarker = SharedDataStoreUtils.getEarliestRecord(markerFiles).getLastModified();
                    LOG.trace("Earliest marker timestamp {}", (Object)earliestMarker);
                    long earliestRef = SharedDataStoreUtils.getEarliestRecord(refFiles).getLastModified();
                    LOG.trace("Earliest ref timestamp {}", (Object)earliestRef);
                    return earliestMarker < earliestRef ? earliestMarker : earliestRef;
                }
                LOG.error("Not all repositories have marked references available : {} or older than retention time: {}", unAvailRepos, notOldRefs);
                throw new NotAllRepositoryMarkedException("Not all repositories have marked references available");
            }

            @Override
            void addMarked(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, String repoId, String uniqueSuffix) throws DataStoreException, IOException {
                boolean exists = ((SharedDataStore)blobStore).metadataRecordExists(SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getNameFromId(repoId));
                if (exists) {
                    LOG.info("References for repository id {} already exists. Creating a duplicate one. Please check for inadvertent sharing of repository id by different repositories", (Object)repoId);
                }
                ((SharedDataStore)blobStore).addMetadataRecord(fs.getMarkedRefs(), SharedDataStoreUtils.SharedStoreRecordType.REFERENCES.getNameFromIdPrefix(repoId, uniqueSuffix));
            }

            @Override
            public void addMarkedStartMarker(GarbageCollectableBlobStore blobStore, String repoId, String uniqueSuffix) {
                try {
                    ((SharedDataStore)blobStore).addMetadataRecord(new ByteArrayInputStream(new byte[0]), SharedDataStoreUtils.SharedStoreRecordType.MARKED_START_MARKER.getNameFromIdPrefix(repoId, uniqueSuffix));
                }
                catch (DataStoreException e) {
                    LOG.debug("Error creating marked time marker for repo : {}", (Object)repoId);
                }
            }
        }
        ,
        DEFAULT;


        void removeAllMarkedReferences(GarbageCollectableBlobStore blobStore) {
        }

        void addMarked(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, String repoId, String uniqueSuffix) throws DataStoreException, IOException {
        }

        long mergeAllMarkedReferences(GarbageCollectableBlobStore blobStore, GarbageCollectorFileState fs, Clock clock, long maxLastModifiedInterval, boolean sweepIfRefsPastRetention) throws IOException, DataStoreException {
            if (!fs.getMarkedRefs().exists() || fs.getMarkedRefs().length() == 0L) {
                throw new IOException("Marked references not available");
            }
            return fs.getMarkedRefs().lastModified();
        }

        public static GarbageCollectionType get(GarbageCollectableBlobStore blobStore) {
            if (SharedDataStoreUtils.isShared((BlobStore)blobStore)) {
                return SHARED;
            }
            return DEFAULT;
        }

        public void addMarkedStartMarker(GarbageCollectableBlobStore blobStore, String repoId, String uniqueSuffix) {
        }
    }

    private class BlobIdRetriever
    implements Callable<Integer> {
        private final GarbageCollectorFileState fs;
        private final boolean forceRetrieve;

        public BlobIdRetriever(GarbageCollectorFileState fs, boolean forceBlobRetrieve) {
            this.fs = fs;
            this.forceRetrieve = forceBlobRetrieve;
        }

        @Override
        public Integer call() throws Exception {
            if (!this.forceRetrieve) {
                BlobCollectionType.get(MarkSweepGarbageCollector.this.blobStore).retrieve(MarkSweepGarbageCollector.this.blobStore, this.fs, MarkSweepGarbageCollector.this.getBatchCount());
                LOG.info("Length of blob ids file retrieved from tracker {}", (Object)this.fs.getAvailableRefs().length());
            }
            if (this.fs.getAvailableRefs().length() <= 0L) {
                BlobCollectionType.DEFAULT.retrieve(MarkSweepGarbageCollector.this.blobStore, this.fs, MarkSweepGarbageCollector.this.getBatchCount());
                LOG.info("Length of blob ids file retrieved {}", (Object)this.fs.getAvailableRefs().length());
                BlobCollectionType.get(MarkSweepGarbageCollector.this.blobStore).track(MarkSweepGarbageCollector.this.blobStore, this.fs);
            }
            return 0;
        }
    }
}

