/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaDeprecation {
    private static final Logger LOG = LoggerFactory.getLogger(GuavaDeprecation.class);
    private static String LOGLEVEL = "error";

    private GuavaDeprecation() {
    }

    public static void handleCall(String ticket) throws UnsupportedOperationException {
        String message = "use of deprecated Guava-related API - this method is going to be removed in future Oak releases - see %s for details";
        switch (LOGLEVEL) {
            case "error": {
                if (!LOG.isErrorEnabled()) break;
                LOG.error(String.format(message, ticket), (Throwable)new Exception("call stack"));
                break;
            }
            case "warn": {
                if (!LOG.isWarnEnabled()) break;
                LOG.warn(String.format(message, ticket), (Throwable)new Exception("call stack"));
                break;
            }
            case "info": {
                if (!LOG.isInfoEnabled()) break;
                LOG.info(String.format(message, ticket), (Throwable)new Exception("call stack"));
                break;
            }
            case "debug": {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(String.format(message, ticket), (Throwable)new Exception("call stack"));
            }
        }
    }

    public static String setLogLevel(String level) {
        String before = LOGLEVEL;
        LOGLEVEL = level;
        return before;
    }
}

