/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.concurrent;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorCloser
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorCloser.class);
    private final ExecutorService executorService;
    private final int timeout;
    private final TimeUnit timeUnit;

    public ExecutorCloser(@Nullable ExecutorService executorService) {
        this(executorService, 5, TimeUnit.SECONDS);
    }

    public ExecutorCloser(@Nullable ExecutorService executorService, int timeout, TimeUnit unit) {
        this.executorService = executorService;
        this.timeout = timeout;
        this.timeUnit = unit;
    }

    @Override
    public void close() {
        if (this.executorService == null) {
            return;
        }
        try {
            this.executorService.shutdown();
            this.executorService.awaitTermination(this.timeout, this.timeUnit);
        }
        catch (InterruptedException e) {
            LOG.error("Error while shutting down the ExecutorService", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            if (!this.executorService.isShutdown()) {
                LOG.warn("ExecutorService `{}` didn't shutdown property. Will be forced now.", (Object)this.executorService);
            }
            this.executorService.shutdownNow();
        }
    }
}

