/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.properties;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertySupplier<T>
implements Supplier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SystemPropertySupplier.class);
    private final String propName;
    private final T defaultValue;
    private final Function<String, T> parser;
    private Logger log = LOG;
    private String successLogLevel = "INFO";
    private Predicate<T> validator = a -> true;
    private Function<String, String> sysPropReader = System::getProperty;
    private BiFunction<String, T, String> setMessageFormatter = (a, b) -> String.format("System property %s found to be '%s'", a, b);

    private SystemPropertySupplier(@NotNull String propName, @NotNull T defaultValue) throws IllegalArgumentException {
        this.propName = Objects.requireNonNull(propName, "propertyName must be non-null");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue must be non-null");
        this.parser = SystemPropertySupplier.getValueParser(defaultValue);
    }

    public static <U> SystemPropertySupplier<U> create(@NotNull String propName, @NotNull U defaultValue) throws IllegalArgumentException {
        return new SystemPropertySupplier<U>(propName, defaultValue);
    }

    public SystemPropertySupplier<T> loggingTo(@NotNull Logger log) {
        this.log = Objects.requireNonNull(log);
        return this;
    }

    public SystemPropertySupplier<T> validateWith(@NotNull Predicate<T> validator) {
        this.validator = Objects.requireNonNull(validator);
        return this;
    }

    public SystemPropertySupplier<T> formatSetMessage(@NotNull BiFunction<String, T, String> setMessageFormatter) {
        this.setMessageFormatter = Objects.requireNonNull(setMessageFormatter);
        return this;
    }

    public SystemPropertySupplier<T> logSuccessAs(String successLogLevel) {
        String newLevel;
        switch (Objects.requireNonNull(successLogLevel)) {
            case "DEBUG": 
            case "ERROR": 
            case "INFO": 
            case "TRACE": 
            case "WARN": {
                newLevel = successLogLevel;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported log level: " + successLogLevel);
            }
        }
        this.successLogLevel = newLevel;
        return this;
    }

    protected SystemPropertySupplier<T> usingSystemPropertyReader(@NotNull Function<String, String> sysPropReader) {
        this.sysPropReader = Objects.requireNonNull(sysPropReader);
        return this;
    }

    @Override
    public T get() {
        T ret = this.defaultValue;
        String value = this.sysPropReader.apply(this.propName);
        if (value == null) {
            this.log.trace("System property {} not set", (Object)this.propName);
        } else {
            this.log.trace("System property {} set to '{}'", (Object)this.propName, (Object)value);
            try {
                T v = this.parser.apply(value);
                if (!this.validator.test(v)) {
                    this.log.error("Ignoring invalid value '{}' for system property {}", (Object)value, (Object)this.propName);
                } else {
                    ret = v;
                }
            }
            catch (NumberFormatException ex) {
                this.log.error("Ignoring malformed value '{}' for system property {}", (Object)value, (Object)this.propName);
            }
            if (!ret.equals(this.defaultValue)) {
                String msg = this.setMessageFormatter.apply(this.propName, (String)ret);
                switch (this.successLogLevel) {
                    case "INFO": {
                        this.log.info(msg);
                        break;
                    }
                    case "DEBUG": {
                        this.log.debug(msg);
                        break;
                    }
                    case "ERROR": {
                        this.log.error(msg);
                        break;
                    }
                    case "TRACE": {
                        this.log.trace(msg);
                        break;
                    }
                    case "WARN": {
                        this.log.warn(msg);
                        break;
                    }
                }
            }
        }
        return ret;
    }

    private static <T> Function<String, T> getValueParser(T defaultValue) {
        if (defaultValue instanceof Boolean) {
            return v -> Boolean.valueOf(v);
        }
        if (defaultValue instanceof Integer) {
            return v -> Integer.valueOf(v);
        }
        if (defaultValue instanceof Long) {
            return v -> Long.valueOf(v);
        }
        if (defaultValue instanceof String) {
            return v -> v;
        }
        throw new IllegalArgumentException(String.format("expects a defaultValue of Boolean, Integer, Long, or String, but got: %s", defaultValue.getClass()));
    }
}

