/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.guava.common.io.Closeables;
import org.apache.jackrabbit.guava.common.io.FileWriteMode;
import org.apache.jackrabbit.guava.common.io.Files;
import org.apache.jackrabbit.oak.commons.sort.EscapeUtils;
import org.apache.jackrabbit.oak.commons.sort.ExternalSort;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class FileIOUtils {
    public static final Comparator<String> lexComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    };

    private FileIOUtils() {
    }

    public static void sort(File file) throws IOException {
        File sorted = File.createTempFile("fleioutilssort", null);
        FileIOUtils.merge(ExternalSort.sortInBatch(file, lexComparator, true), sorted);
        Files.move((File)sorted, (File)file);
    }

    public static void sort(File file, Comparator<String> comparator) throws IOException {
        File sorted = File.createTempFile("fleioutilssort", null);
        FileIOUtils.merge(ExternalSort.sortInBatch(file, comparator, true), sorted, comparator);
        Files.move((File)sorted, (File)file);
    }

    public static void merge(List<File> files, File output) throws IOException {
        ExternalSort.mergeSortedFiles(files, output, lexComparator, true);
    }

    public static void merge(List<File> files, File output, Comparator<String> comparator) throws IOException {
        ExternalSort.mergeSortedFiles(files, output, comparator, true);
    }

    public static File copy(InputStream stream) throws IOException {
        File file = File.createTempFile("fleioutilscopy", null);
        FileIOUtils.copyInputStreamToFile(stream, file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(List<File> files, File appendTo, boolean delete) throws IOException {
        boolean threw;
        OutputStream appendStream;
        block9: {
            appendStream = null;
            threw = true;
            try {
                appendStream = Files.asByteSink((File)appendTo, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).openBufferedStream();
                for (File f : files) {
                    FileInputStream iStream = new FileInputStream(f);
                    try {
                        IOUtils.copyLarge((InputStream)iStream, (OutputStream)appendStream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)iStream);
                    }
                }
                threw = false;
                if (!delete) break block9;
            }
            catch (Throwable throwable) {
                if (delete) {
                    for (File f : files) {
                        f.delete();
                    }
                }
                Closeables.close(appendStream, (boolean)threw);
                throw throwable;
            }
            for (File f : files) {
                f.delete();
            }
        }
        Closeables.close((Closeable)appendStream, (boolean)threw);
    }

    public static void writeAsLine(BufferedWriter writer, String str, boolean escape) throws IOException {
        if (escape) {
            writer.write(EscapeUtils.escapeLineBreak(str));
        } else {
            writer.write(str);
        }
        writer.newLine();
    }

    public static int writeStrings(Iterator<String> iterator, File f, boolean escape) throws IOException {
        return FileIOUtils.writeStrings(iterator, f, escape, null, "");
    }

    public static int writeStrings(Iterator<String> iterator, File f, boolean escape, @Nullable Logger logger, @Nullable String message) throws IOException {
        return FileIOUtils.writeStrings(iterator, f, escape, Function.identity(), logger, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeStrings(Iterator<String> iterator, File f, boolean escape, @NotNull Function<String, String> transformer, @Nullable Logger logger, @Nullable String message) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(f, StandardCharsets.UTF_8));
        boolean threw = true;
        int count = 0;
        try {
            while (iterator.hasNext()) {
                FileIOUtils.writeAsLine(writer, transformer.apply(iterator.next()), escape);
                if (logger == null || ++count % 100000 != 0) continue;
                logger.info(Objects.toString(message, "") + count);
            }
            threw = false;
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)threw);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readStringsAsSet(InputStream stream, boolean unescape) throws IOException {
        BufferedReader reader = null;
        HashSet<String> set = new HashSet<String>();
        boolean threw = true;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (unescape) {
                    set.add(EscapeUtils.unescapeLineBreaks(line));
                    continue;
                }
                set.add(line);
            }
            threw = false;
        }
        catch (Throwable throwable) {
            Closeables.close(reader, (boolean)threw);
            throw throwable;
        }
        Closeables.close((Closeable)reader, (boolean)threw);
        return set;
    }

    public static Comparator<String> lineBreakAwareComparator(Comparator<String> delegate) {
        return new TransformingComparator(delegate, new Function<String, String>(){

            @Override
            @Nullable
            public String apply(@Nullable String input) {
                return EscapeUtils.unescapeLineBreaks(input);
            }
        });
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        boolean success = false;
        try {
            FileUtils.copyInputStreamToFile((InputStream)source, (File)destination);
            success = true;
        }
        finally {
            if (!success) {
                FileUtils.forceDelete((File)destination);
            }
        }
    }

    public static class TransformingComparator
    implements Comparator<String> {
        private Comparator<String> delegate;
        private Function<String, String> func;

        public TransformingComparator(Comparator<String> delegate, Function<String, String> func) {
            this.delegate = delegate;
            this.func = func;
        }

        @Override
        public int compare(String s1, String s2) {
            return this.delegate.compare(this.func.apply(s1), this.func.apply(s2));
        }
    }
}

