/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class CollectionUtils {
    private static final int MAX_CAPACITY = 0x40000000;

    private CollectionUtils() {
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        ArrayList result = new ArrayList();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <T> List<T> toLinkedList(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        LinkedList result = new LinkedList();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <T> List<T> toList(Iterator<? extends T> iterator) {
        Objects.requireNonNull(iterator);
        ArrayList result = new ArrayList();
        iterator.forEachRemaining(result::add);
        return result;
    }

    @NotNull
    public static <T> List<List<T>> partitionList(List<T> list, int n) {
        Objects.requireNonNull(list);
        return IntStream.range(0, list.size()).filter(i -> i % n == 0).mapToObj(i -> list.subList(i, Math.min(i + n, list.size()))).collect(Collectors.toList());
    }

    @NotNull
    public static <T> List<T> reverse(List<T> l) {
        Objects.requireNonNull(l);
        return IntStream.range(0, l.size()).map(i -> l.size() - 1 - i).mapToObj(l::get).collect(Collectors.toList());
    }

    @NotNull
    public static <T> Set<T> toSet(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        HashSet result = new HashSet();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <T> Set<T> toLinkedSet(@NotNull Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        LinkedHashSet result = new LinkedHashSet();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <T extends Comparable> TreeSet<T> toTreeSet(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        TreeSet result = new TreeSet();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <T> Set<T> toSet(@NotNull Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        HashSet result = new HashSet();
        iterator.forEachRemaining(result::add);
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> toSet(T ... elements) {
        Objects.requireNonNull(elements);
        HashSet<T> result = new HashSet<T>(CollectionUtils.ensureCapacity(elements.length));
        result.addAll(Arrays.asList(elements));
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> toLinkedSet(T ... elements) {
        Objects.requireNonNull(elements);
        LinkedHashSet<T> result = new LinkedHashSet<T>(CollectionUtils.ensureCapacity(elements.length));
        result.addAll(Arrays.asList(elements));
        return result;
    }

    @NotNull
    public static <T> Set<T> union(@NotNull Set<T> s1, @NotNull Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return Stream.concat(s1.stream(), s2.stream()).collect(Collectors.toSet());
    }

    @NotNull
    public static <T> Set<T> intersection(@NotNull Set<T> s1, @NotNull Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return s1.stream().filter(s2::contains).collect(Collectors.toSet());
    }

    public static <T> Set<T> symmetricDifference(Set<T> s1, Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        HashSet<T> result = new HashSet<T>(s1);
        s2.stream().filter(Predicate.not(result::add)).forEach(result::remove);
        return result;
    }

    public static <T> Set<T> difference(Set<T> s1, Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return s1.stream().filter(e -> !s2.contains(e)).collect(Collectors.toSet());
    }

    public static <T> ArrayDeque<T> toArrayDeque(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        ArrayDeque arrayDeque = new ArrayDeque();
        iterable.forEach(arrayDeque::add);
        return arrayDeque;
    }

    @NotNull
    public static <K> Set<K> newHashSet(int capacity) {
        return new HashSet(CollectionUtils.ensureCapacity(capacity));
    }

    @NotNull
    public static <K> Set<K> newConcurrentHashSet() {
        return ConcurrentHashMap.newKeySet();
    }

    @NotNull
    public static <K> Set<K> newConcurrentHashSet(@NotNull Iterable<? extends K> elements) {
        Objects.requireNonNull(elements);
        Set<K> set = CollectionUtils.newConcurrentHashSet();
        elements.forEach(set::add);
        return set;
    }

    @NotNull
    public static <K> Set<K> newLinkedHashSet(int capacity) {
        return new LinkedHashSet(CollectionUtils.ensureCapacity(capacity));
    }

    @NotNull
    public static <E> Set<E> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    @NotNull
    public static <K, V> Map<K, V> newHashMap(int capacity) {
        return new HashMap(CollectionUtils.ensureCapacity(capacity));
    }

    @NotNull
    public static Map<String, String> fromProperties(@NotNull Properties properties) {
        Objects.requireNonNull(properties);
        return properties.entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
    }

    @NotNull
    public static <K, V> Map<K, V> filterKeys(@NotNull Map<K, V> map, @NotNull Predicate<? super K> predicate) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(predicate);
        return map.entrySet().stream().filter(e -> predicate.test((Object)e.getKey())).collect(LinkedHashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
    }

    @NotNull
    public static <K, V> Map<K, V> filterValues(@NotNull Map<K, V> map, @NotNull Predicate<? super V> predicate) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(predicate);
        return map.entrySet().stream().filter(e -> predicate.test((Object)e.getValue())).collect(LinkedHashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
    }

    @NotNull
    public static <K, V> Map<K, V> filterEntries(@NotNull Map<K, V> map, @NotNull Predicate<? super Map.Entry<K, V>> predicate) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(predicate);
        return map.entrySet().stream().filter(predicate).collect(LinkedHashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
    }

    @NotNull
    public static <T> Iterable<T> toIterable(final @NotNull Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        return new Iterable<T>(){
            private boolean consumed = false;

            @Override
            @NotNull
            public Iterator<T> iterator() {
                if (this.consumed) {
                    throw new IllegalStateException("Iterator already returned once");
                }
                this.consumed = true;
                return iterator;
            }
        };
    }

    @NotNull
    public static <T> Stream<T> toStream(@NotNull Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @NotNull
    public static <T> Stream<T> toStream(@NotNull Iterator<T> iterator) {
        return StreamSupport.stream(CollectionUtils.toIterable(iterator).spliterator(), false);
    }

    static int ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative");
        }
        if (capacity > 0x40000000) {
            return 0x40000000;
        }
        return 1 + (int)((float)capacity / 0.75f);
    }
}

