/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

public class CollectionUtils {
    private static final int MAX_CAPACITY = 0x40000000;

    private CollectionUtils() {
    }

    static int ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative");
        }
        if (capacity > 0x40000000) {
            return 0x40000000;
        }
        return 1 + (int)((float)capacity / 0.75f);
    }
}

