/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class IteratorUtils {
    private IteratorUtils() {
    }

    @NotNull
    public static <T> Iterable<T> toIterable(final @NotNull Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        return new Iterable<T>(){
            private boolean consumed = false;

            @Override
            @NotNull
            public Iterator<T> iterator() {
                if (this.consumed) {
                    throw new IllegalStateException("Iterator already returned once");
                }
                this.consumed = true;
                return iterator;
            }
        };
    }
}

