/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class SetUtils {
    private SetUtils() {
    }

    @NotNull
    public static <T> Set<T> toSet(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        HashSet result = new HashSet();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <T> Set<T> toSet(@NotNull Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        HashSet result = new HashSet();
        iterator.forEachRemaining(result::add);
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> toSet(T ... elements) {
        Objects.requireNonNull(elements);
        HashSet<T> result = new HashSet<T>(CollectionUtils.ensureCapacity(elements.length));
        result.addAll(Arrays.asList(elements));
        return result;
    }

    @NotNull
    public static <K> Set<K> newHashSet(int capacity) {
        return new HashSet(CollectionUtils.ensureCapacity(capacity));
    }

    @NotNull
    public static <E> Set<E> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    @NotNull
    public static <T> Set<T> toLinkedSet(@NotNull Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        LinkedHashSet result = new LinkedHashSet();
        iterable.forEach(result::add);
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> toLinkedSet(T ... elements) {
        Objects.requireNonNull(elements);
        LinkedHashSet<T> result = new LinkedHashSet<T>(CollectionUtils.ensureCapacity(elements.length));
        result.addAll(Arrays.asList(elements));
        return result;
    }

    @NotNull
    public static <K> Set<K> newLinkedHashSet(int capacity) {
        return new LinkedHashSet(CollectionUtils.ensureCapacity(capacity));
    }

    @NotNull
    public static <T extends Comparable> TreeSet<T> toTreeSet(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        TreeSet result = new TreeSet();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <K> Set<K> newConcurrentHashSet() {
        return ConcurrentHashMap.newKeySet();
    }

    @NotNull
    public static <K> Set<K> newConcurrentHashSet(@NotNull Iterable<? extends K> elements) {
        Objects.requireNonNull(elements);
        Set<K> set = SetUtils.newConcurrentHashSet();
        elements.forEach(set::add);
        return set;
    }

    @NotNull
    public static <T> Set<T> union(@NotNull Set<T> s1, @NotNull Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return Stream.concat(s1.stream(), s2.stream()).collect(Collectors.toSet());
    }

    @NotNull
    public static <T> Set<T> intersection(@NotNull Set<T> s1, @NotNull Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return s1.stream().filter(s2::contains).collect(Collectors.toSet());
    }

    public static <T> Set<T> symmetricDifference(Set<T> s1, Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        HashSet<T> result = new HashSet<T>(s1);
        s2.stream().filter(Predicate.not(result::add)).forEach(result::remove);
        return result;
    }

    public static <T> Set<T> difference(Set<T> s1, Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return s1.stream().filter(e -> !s2.contains(e)).collect(Collectors.toSet());
    }
}

