/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.jetbrains.annotations.NotNull;

public class IteratorUtils {
    private IteratorUtils() {
    }

    @NotNull
    public static <T> Iterable<T> toIterable(final @NotNull Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        return new Iterable<T>(){
            private boolean consumed = false;

            @Override
            @NotNull
            public Iterator<T> iterator() {
                if (this.consumed) {
                    throw new IllegalStateException("Iterator already returned once");
                }
                this.consumed = true;
                return iterator;
            }
        };
    }

    public static <T> Iterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> itrs, Comparator<? super T> c) {
        Objects.requireNonNull(itrs, "Iterators must not be null");
        Objects.requireNonNull(c, "Comparator must not be null");
        return org.apache.commons.collections4.IteratorUtils.unmodifiableIterator(new MergingIterator<T>(itrs, c));
    }

    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        if (iterator1 == iterator2) {
            return true;
        }
        if (iterator1 == null || iterator2 == null) {
            return false;
        }
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (Objects.equals(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static int size(Iterator<?> iterator) {
        return org.apache.commons.collections4.IteratorUtils.size(iterator);
    }

    public static <T> T get(Iterator<T> iterator, int index) {
        Objects.requireNonNull(iterator, "Iterator must not be null");
        return (T)org.apache.commons.collections4.IteratorUtils.get(iterator, (int)index);
    }

    public static <T> T getLast(Iterator<T> iterator) {
        T currentElement;
        Objects.requireNonNull(iterator, "Iterator must not be null");
        do {
            currentElement = iterator.next();
        } while (iterator.hasNext());
        return currentElement;
    }

    private static class MergingIterator<T>
    implements Iterator<T> {
        final Queue<PeekingIterator<T>> queue;

        public MergingIterator(Iterable<? extends Iterator<? extends T>> itrs, Comparator<? super T> c) {
            Comparator<PeekingIterator> heapComparator = Comparator.comparing(PeekingIterator::peek, c);
            this.queue = new PriorityQueue<PeekingIterator>(heapComparator);
            for (Iterator<T> itr : itrs) {
                if (!itr.hasNext()) continue;
                this.queue.add(PeekingIterator.peekingIterator(itr));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            PeekingIterator<T> nextItr = this.queue.remove();
            Object next = nextItr.next();
            if (nextItr.hasNext()) {
                this.queue.add(nextItr);
            }
            return (T)next;
        }
    }
}

