/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Preconditions;
import java.security.Principal;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;

final class ImpersonationDelegator
implements Impersonation {
    private final SessionDelegate sessionDelegate;
    private final Impersonation impersonationDelegate;

    private ImpersonationDelegator(SessionDelegate sessionDelegate, Impersonation impersonationDelegate) {
        Preconditions.checkArgument((!(impersonationDelegate instanceof ImpersonationDelegator) ? 1 : 0) != 0);
        this.sessionDelegate = sessionDelegate;
        this.impersonationDelegate = impersonationDelegate;
    }

    static Impersonation wrap(SessionDelegate sessionDelegate, Impersonation impersonation) {
        if (impersonation == null) {
            return null;
        }
        return new ImpersonationDelegator(sessionDelegate, impersonation);
    }

    @NotNull
    public PrincipalIterator getImpersonators() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<PrincipalIterator>("getImpersonators"){

            @Override
            @NotNull
            public PrincipalIterator perform() throws RepositoryException {
                return ImpersonationDelegator.this.impersonationDelegate.getImpersonators();
            }
        });
    }

    public boolean grantImpersonation(final @NotNull Principal principal) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("grantImpersonation", true){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return ImpersonationDelegator.this.impersonationDelegate.grantImpersonation(principal);
            }
        });
    }

    public boolean revokeImpersonation(final @NotNull Principal principal) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("revokeImpersonation", true){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return ImpersonationDelegator.this.impersonationDelegate.revokeImpersonation(principal);
            }
        });
    }

    public boolean allows(final @NotNull Subject subject) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("allows"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return ImpersonationDelegator.this.impersonationDelegate.allows(subject);
            }
        });
    }
}

