/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.observation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.jackrabbit.api.observation.JackrabbitEventFilter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.observation.filter.OakEventFilter;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.observation.filter.ConstantFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventAggregator;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.FilterBuilder;
import org.apache.jackrabbit.oak.plugins.observation.filter.Filters;
import org.apache.jackrabbit.oak.plugins.observation.filter.GlobbingPathFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.GlobbingPathHelper;
import org.apache.jackrabbit.oak.plugins.observation.filter.PermissionProviderFactory;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class OakEventFilterImpl
extends OakEventFilter {
    private final JackrabbitEventFilter delegate;
    private boolean applyNodeTypeOnSelf;
    private boolean includeAncestorRemove;
    private boolean includeSubtreeOnRemove;
    private String[] globPaths;
    private FilterBuilder builder;
    private EventAggregator aggregator;
    private boolean withNodeTypeAggregate;
    private Set<String> relativeGlobPaths;

    public OakEventFilterImpl(@NotNull JackrabbitEventFilter delegate) {
        Preconditions.checkNotNull((Object)delegate);
        this.delegate = delegate;
    }

    public String getAbsPath() {
        return this.delegate.getAbsPath();
    }

    public JackrabbitEventFilter setAbsPath(String absPath) {
        this.delegate.setAbsPath(absPath);
        return this;
    }

    public String[] getAdditionalPaths() {
        return this.delegate.getAdditionalPaths();
    }

    public JackrabbitEventFilter setAdditionalPaths(String ... absPaths) {
        this.delegate.setAdditionalPaths(absPaths);
        return this;
    }

    public int getEventTypes() {
        return this.delegate.getEventTypes();
    }

    public JackrabbitEventFilter setEventTypes(int eventTypes) {
        this.delegate.setEventTypes(eventTypes);
        return this;
    }

    public String[] getExcludedPaths() {
        return this.delegate.getExcludedPaths();
    }

    public JackrabbitEventFilter setExcludedPaths(String ... excludedPaths) {
        this.delegate.setExcludedPaths(excludedPaths);
        return this;
    }

    public String[] getIdentifiers() {
        return this.delegate.getIdentifiers();
    }

    public JackrabbitEventFilter setIdentifiers(String[] identifiers) {
        this.delegate.setIdentifiers(identifiers);
        return this;
    }

    public boolean getIsDeep() {
        return this.delegate.getIsDeep();
    }

    public JackrabbitEventFilter setIsDeep(boolean isDeep) {
        this.delegate.setIsDeep(isDeep);
        return this;
    }

    public String[] getNodeTypes() {
        return this.delegate.getNodeTypes();
    }

    public JackrabbitEventFilter setNodeTypes(String[] nodeTypeNames) {
        this.delegate.setNodeTypes(nodeTypeNames);
        return this;
    }

    public boolean getNoExternal() {
        return this.delegate.getNoExternal();
    }

    public JackrabbitEventFilter setNoExternal(boolean noExternal) {
        this.delegate.setNoExternal(noExternal);
        return this;
    }

    public boolean getNoInternal() {
        return this.delegate.getNoInternal();
    }

    public JackrabbitEventFilter setNoInternal(boolean noInternal) {
        this.delegate.setNoInternal(noInternal);
        return this;
    }

    public boolean getNoLocal() {
        return this.delegate.getNoLocal();
    }

    public JackrabbitEventFilter setNoLocal(boolean noLocal) {
        this.delegate.setNoLocal(noLocal);
        return this;
    }

    @Override
    public OakEventFilter withApplyNodeTypeOnSelf() {
        this.applyNodeTypeOnSelf = true;
        return this;
    }

    boolean getApplyNodeTypeOnSelf() {
        return this.applyNodeTypeOnSelf;
    }

    @Override
    public OakEventFilter withIncludeAncestorsRemove() {
        this.includeAncestorRemove = true;
        return this;
    }

    boolean getIncludeAncestorsRemove() {
        return this.includeAncestorRemove;
    }

    static void addAncestorPaths(Set<String> ancestorPaths, String globPath) {
        if (globPath == null || !globPath.contains("/")) {
            return;
        }
        Iterator it = PathUtils.elements((String)globPath).iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            String element = (String)it.next();
            sb.append("/");
            sb.append(element);
            ancestorPaths.add(sb.toString());
            if (!element.equals("**")) continue;
            break;
        }
    }

    public FilterBuilder.Condition wrapMainCondition(FilterBuilder.Condition mainCondition, FilterBuilder filterBuilder, PermissionProviderFactory permissionProviderFactory) {
        if (!this.includeAncestorRemove || (this.getEventTypes() & 2) != 2) {
            return mainCondition;
        }
        HashSet<String> parentPaths = new HashSet<String>();
        OakEventFilterImpl.addAncestorPaths(parentPaths, this.getAbsPath());
        if (this.getAdditionalPaths() != null) {
            for (String absPath : this.getAdditionalPaths()) {
                OakEventFilterImpl.addAncestorPaths(parentPaths, absPath);
            }
        }
        if (this.globPaths != null) {
            for (String globPath : this.globPaths) {
                OakEventFilterImpl.addAncestorPaths(parentPaths, globPath);
            }
        }
        if (parentPaths.size() == 0) {
            return mainCondition;
        }
        LinkedList<FilterBuilder.Condition> ancestorsIncludeConditions = new LinkedList<FilterBuilder.Condition>();
        for (String aParentPath : parentPaths) {
            ancestorsIncludeConditions.add(filterBuilder.all(new FilterBuilder.Condition[]{filterBuilder.path(aParentPath), filterBuilder.deleteSubtree()}));
        }
        if (this.globPaths != null) {
            for (String globPath : this.globPaths) {
                if (!globPath.contains("**") && !globPath.contains("/*/")) continue;
                ancestorsIncludeConditions.add(filterBuilder.path(globPath));
            }
        }
        return filterBuilder.any(new FilterBuilder.Condition[]{mainCondition, filterBuilder.all(new FilterBuilder.Condition[]{filterBuilder.eventType(2), filterBuilder.any(ancestorsIncludeConditions), filterBuilder.accessControl(permissionProviderFactory)})});
    }

    @Override
    public OakEventFilter withIncludeSubtreeOnRemove() {
        this.includeSubtreeOnRemove = true;
        return this;
    }

    boolean getIncludeSubtreeOnRemove() {
        return this.includeSubtreeOnRemove;
    }

    @Override
    public OakEventFilter withIncludeGlobPaths(String ... globPaths) {
        if (this.globPaths == null) {
            this.globPaths = globPaths;
        } else {
            LinkedList<String> combo = new LinkedList<String>();
            combo.addAll(Arrays.asList(this.globPaths));
            combo.addAll(Arrays.asList(globPaths));
            this.globPaths = combo.toArray(new String[combo.size()]);
        }
        return this;
    }

    String[] getIncludeGlobPaths() {
        return this.globPaths;
    }

    public FilterBuilder builder() {
        if (this.builder == null) {
            this.builder = new FilterBuilder();
        }
        return this.builder;
    }

    public OakEventFilterImpl aggregator(EventAggregator aggregator) {
        Preconditions.checkNotNull((Object)aggregator);
        this.aggregator = aggregator;
        return this;
    }

    public FilterBuilder.Condition getAdditionalIncludeConditions(Set<String> includePaths) {
        if (!this.withNodeTypeAggregate) {
            return null;
        }
        LinkedList<FilterBuilder.Condition> additionalIncludeConditions = new LinkedList<FilterBuilder.Condition>();
        for (String includePath : includePaths) {
            if (includePath.equals("**") || includePath.endsWith("/*") || includePath.endsWith("/**")) continue;
            for (String relativeGlobPath : this.relativeGlobPaths) {
                if (relativeGlobPath.equals("")) continue;
                String additionalGlobPath = includePath.endsWith("/") ? includePath + relativeGlobPath : includePath + "/" + relativeGlobPath;
                additionalIncludeConditions.add(this.builder().path(additionalGlobPath));
                additionalIncludeConditions.add(this.builder().path(additionalGlobPath + "/*"));
            }
        }
        if (additionalIncludeConditions.size() == 0) {
            return null;
        }
        return this.builder().any(additionalIncludeConditions);
    }

    public EventAggregator getAggregator() {
        return this.aggregator;
    }

    @Override
    public OakEventFilter withNodeTypeAggregate(String[] nodeTypes, String[] relativeGlobPaths) {
        this.withNodeTypeAggregate = true;
        if (this.relativeGlobPaths == null) {
            this.relativeGlobPaths = new HashSet<String>();
        }
        this.relativeGlobPaths.addAll(Arrays.asList(relativeGlobPaths));
        Pattern[] relativePathPatterns = new Pattern[relativeGlobPaths.length];
        for (int i = 0; i < relativePathPatterns.length; ++i) {
            relativePathPatterns[i] = Pattern.compile(GlobbingPathHelper.globPathAsRegex((String)relativeGlobPaths[i]));
        }
        this.aggregator(new NodeTypeAggregator(nodeTypes, relativePathPatterns));
        return this;
    }

    Set<String> calcPrefilterIncludePaths(Set<String> includePaths) {
        HashSet<String> paths = new HashSet<String>();
        if (this.includeAncestorRemove) {
            for (String includePath : includePaths) {
                OakEventFilterImpl.addAncestorPaths(paths, includePath);
            }
        }
        if (this.withNodeTypeAggregate) {
            for (String includePath : includePaths) {
                if (includePath.equals("**") || includePath.endsWith("/**")) continue;
                if (includePath.endsWith("/")) {
                    paths.add(includePath + "**");
                    continue;
                }
                paths.add(includePath + "/**");
            }
        }
        return paths;
    }

    private static final class NodeTypeAggregator
    implements EventAggregator {
        private final String[] nodeTypes;
        private final Pattern[] relativePathPatterns;

        private NodeTypeAggregator(String[] nodeTypes, Pattern[] relativePathPatterns) {
            this.nodeTypes = nodeTypes;
            this.relativePathPatterns = relativePathPatterns;
        }

        public int aggregate(NodeState root, List<ChildNodeEntry> parents, ChildNodeEntry childNodeState) {
            TypePredicate nodeTypePredicate = new TypePredicate(root, this.nodeTypes);
            int depth = parents.size();
            for (int i = 0; i < depth; ++i) {
                ChildNodeEntry child = parents.get(i);
                NodeState nodeState = child.getNodeState();
                if (!nodeTypePredicate.apply(nodeState) || i + 1 > depth) continue;
                String childPath = this.asPath(parents.subList(i + 1, depth));
                for (Pattern pattern : this.relativePathPatterns) {
                    if (!pattern.matcher(childPath).matches()) continue;
                    return depth - i;
                }
            }
            return 0;
        }

        public int aggregate(NodeState root, List<ChildNodeEntry> parents, PropertyState propertyState) {
            TypePredicate nodeTypePredicate = new TypePredicate(root, this.nodeTypes);
            int depth = parents.size();
            for (int i = 0; i < depth; ++i) {
                ChildNodeEntry child = parents.get(i);
                NodeState nodeState = child.getNodeState();
                if (!nodeTypePredicate.apply(nodeState) || i + 1 > depth) continue;
                String childPath = this.asPath(parents.subList(i + 1, depth));
                for (Pattern pattern : this.relativePathPatterns) {
                    if (!pattern.matcher(childPath).matches()) continue;
                    return depth - (i + 1);
                }
            }
            return 0;
        }

        private String asPath(List<ChildNodeEntry> children) {
            if (children.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (ChildNodeEntry child : children) {
                if (sb.length() != 0) {
                    sb.append("/");
                }
                sb.append(child.getName());
            }
            return sb.toString();
        }
    }

    static class NodeTypeAggregationFilter
    implements EventFilter,
    FilterBuilder.Condition {
        private final Map<String, Pattern> patternMap = new HashMap<String, Pattern>();
        private final String[] nodeTypes;
        private final String[] relativeGlobPaths;
        private final boolean includeThis;
        private TypePredicate predicate;

        NodeTypeAggregationFilter(String[] nodeTypes, String[] relativeGlobPaths) {
            this.nodeTypes = nodeTypes;
            this.relativeGlobPaths = relativeGlobPaths;
            boolean includeThis = false;
            for (String aRelativeGlobPath : relativeGlobPaths) {
                if (!aRelativeGlobPath.equals("") && !aRelativeGlobPath.equals(".") && !aRelativeGlobPath.equals("*") && !aRelativeGlobPath.equals("**")) continue;
                includeThis = true;
            }
            this.includeThis = includeThis;
        }

        public boolean includeAdd(PropertyState after) {
            return false;
        }

        public boolean includeChange(PropertyState before, PropertyState after) {
            return false;
        }

        public boolean includeDelete(PropertyState before) {
            return false;
        }

        public boolean includeAdd(String name, NodeState after) {
            return this.includeThis && this.predicate.apply(after);
        }

        public boolean includeDelete(String name, NodeState before) {
            return this.includeThis && this.predicate.apply(before);
        }

        public boolean includeMove(String sourcePath, String name, NodeState moved) {
            return this.includeThis && this.predicate.apply(moved);
        }

        public boolean includeReorder(String destName, String name, NodeState reordered) {
            return this.includeThis && this.predicate.apply(reordered);
        }

        public EventFilter create(String name, NodeState before, NodeState after) {
            boolean predicateMatches = false;
            predicateMatches = after.exists() ? this.predicate.apply(after) : this.predicate.apply(before);
            if (predicateMatches) {
                ArrayList filters = Lists.newArrayList();
                for (String relativeGlobPath : this.relativeGlobPaths) {
                    if (relativeGlobPath.endsWith("*")) {
                        filters.add(new GlobbingPathFilter(relativeGlobPath, this.patternMap));
                        continue;
                    }
                    filters.add(new GlobbingPathFilter(relativeGlobPath + "/*", this.patternMap));
                }
                return filters.isEmpty() ? ConstantFilter.EXCLUDE_ALL : Filters.any((List)filters);
            }
            return this;
        }

        public EventFilter createFilter(NodeState before, NodeState after) {
            this.predicate = after.exists() ? new TypePredicate(after, this.nodeTypes) : new TypePredicate(before, this.nodeTypes);
            return this;
        }
    }
}

