/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.version;

import com.google.common.base.Preconditions;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.LabelExistsVersionException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.version.VersionStorage;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.plugins.version.ReadOnlyVersionManager;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;

public class ReadWriteVersionManager
extends ReadOnlyVersionManager {
    private final SessionDelegate sessionDelegate;
    private final VersionStorage versionStorage;
    private final Clock clock = Clock.ACCURATE;

    public ReadWriteVersionManager(@NotNull SessionDelegate sessionDelegate) {
        this.sessionDelegate = sessionDelegate;
        this.versionStorage = new VersionStorage(sessionDelegate.getRoot());
    }

    protected void refresh() throws RepositoryException {
        this.sessionDelegate.refresh(true);
    }

    @NotNull
    protected Tree getVersionStorage() {
        return this.versionStorage.getTree();
    }

    @NotNull
    protected Root getWorkspaceRoot() {
        return this.sessionDelegate.getRoot();
    }

    @NotNull
    protected ReadOnlyNodeTypeManager getNodeTypeManager() {
        return ReadOnlyNodeTypeManager.getInstance((Root)this.sessionDelegate.getRoot(), (NamePathMapper)NamePathMapper.DEFAULT);
    }

    @NotNull
    public Tree checkin(@NotNull Tree versionable) throws RepositoryException, InvalidItemStateException, UnsupportedRepositoryOperationException {
        if (this.sessionDelegate.hasPendingChanges()) {
            throw new InvalidItemStateException("Unable to perform checkin. Session has pending changes.");
        }
        if (!this.isVersionable(versionable)) {
            throw new UnsupportedRepositoryOperationException(versionable.getPath() + " is not versionable");
        }
        if (this.isCheckedOut(versionable)) {
            Tree baseVersion = this.getExistingBaseVersion(versionable);
            versionable.setProperty("jcr:isCheckedOut", (Object)Boolean.FALSE, Type.BOOLEAN);
            PropertyState created = baseVersion.getProperty("jcr:created");
            long c = created == null ? 0L : ISO8601.parse((String)((String)created.getValue(Type.DATE))).getTimeInMillis();
            try {
                long last = Math.max(c, this.clock.getTimeIncreasing());
                this.clock.waitUntil(last);
            }
            catch (InterruptedException e) {
                throw new RepositoryException((Throwable)e);
            }
            try {
                this.sessionDelegate.commit();
                this.refresh();
            }
            catch (CommitFailedException e) {
                this.sessionDelegate.refresh(true);
                throw e.asRepositoryException();
            }
        }
        return this.getExistingBaseVersion(this.getWorkspaceRoot().getTree(versionable.getPath()));
    }

    public void checkout(@NotNull Root workspaceRoot, @NotNull String versionablePath) throws UnsupportedRepositoryOperationException, InvalidItemStateException, RepositoryException {
        Preconditions.checkState((!workspaceRoot.hasPendingChanges() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)PathUtils.isAbsolute((String)versionablePath));
        Tree versionable = workspaceRoot.getTree(versionablePath);
        if (!this.isVersionable(versionable)) {
            throw new UnsupportedRepositoryOperationException(versionable.getPath() + " is not versionable");
        }
        if (!this.isCheckedOut(versionable)) {
            versionable.setProperty("jcr:isCheckedOut", (Object)Boolean.TRUE, Type.BOOLEAN);
            try {
                workspaceRoot.commit();
                this.refresh();
            }
            catch (CommitFailedException e) {
                workspaceRoot.refresh();
                throw e.asRepositoryException();
            }
        }
    }

    public void addVersionLabel(@NotNull VersionStorage versionStorage, @NotNull String versionHistoryOakRelPath, @NotNull String versionIdentifier, @NotNull String oakVersionLabel, boolean moveLabel) throws RepositoryException {
        Tree versionHistory = TreeUtil.getTree((Tree)((Tree)Preconditions.checkNotNull((Object)versionStorage.getTree())), (String)((String)Preconditions.checkNotNull((Object)versionHistoryOakRelPath)));
        Tree labels = ((Tree)Preconditions.checkNotNull((Object)versionHistory)).getChild("jcr:versionLabels");
        PropertyState existing = labels.getProperty((String)Preconditions.checkNotNull((Object)oakVersionLabel));
        if (existing != null) {
            if (moveLabel) {
                labels.removeProperty(existing.getName());
            } else {
                throw new LabelExistsVersionException("Version label '" + oakVersionLabel + "' already exists on this version history");
            }
        }
        labels.setProperty(oakVersionLabel, (Object)versionIdentifier, Type.REFERENCE);
        try {
            this.sessionDelegate.commit(versionStorage.getRoot());
            this.refresh();
        }
        catch (CommitFailedException e) {
            versionStorage.refresh();
            throw e.asRepositoryException();
        }
    }

    public void removeVersionLabel(@NotNull VersionStorage versionStorage, @NotNull String versionHistoryOakRelPath, @NotNull String oakVersionLabel) throws RepositoryException {
        Tree versionHistory = TreeUtil.getTree((Tree)((Tree)Preconditions.checkNotNull((Object)versionStorage.getTree())), (String)((String)Preconditions.checkNotNull((Object)versionHistoryOakRelPath)));
        Tree labels = ((Tree)Preconditions.checkNotNull((Object)versionHistory)).getChild("jcr:versionLabels");
        if (!labels.hasProperty(oakVersionLabel)) {
            throw new VersionException("Version label " + oakVersionLabel + " does not exist on this version history");
        }
        labels.removeProperty(oakVersionLabel);
        try {
            this.sessionDelegate.commit(versionStorage.getRoot());
            this.refresh();
        }
        catch (CommitFailedException e) {
            versionStorage.refresh();
            throw e.asRepositoryException();
        }
    }

    public void removeVersion(@NotNull VersionStorage versionStorage, @NotNull String versionHistoryOakRelPath, @NotNull String oakVersionName) throws RepositoryException {
        Tree versionHistory = TreeUtil.getTree((Tree)versionStorage.getTree(), (String)versionHistoryOakRelPath);
        if (versionHistory == null || !versionHistory.exists()) {
            throw new VersionException("Version history " + versionHistoryOakRelPath + " does not exist on this version storage");
        }
        Tree version = versionHistory.getChild(oakVersionName);
        if (!version.exists()) {
            throw new VersionException("Version " + oakVersionName + " does not exist on this version history");
        }
        version.remove();
        try {
            this.sessionDelegate.commit(versionStorage.getRoot());
            this.refresh();
        }
        catch (CommitFailedException e) {
            versionStorage.refresh();
            throw e.asRepositoryException();
        }
    }

    @NotNull
    private Tree getExistingBaseVersion(@NotNull Tree versionableTree) throws RepositoryException {
        Tree baseVersion = this.getBaseVersion(versionableTree);
        if (baseVersion == null) {
            throw new IllegalStateException("Base version does not exist for " + versionableTree.getPath());
        }
        return baseVersion;
    }
}

