/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.oak.jcr.delegate.AuthorizableDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;

final class GroupDelegator
extends AuthorizableDelegator
implements Group {
    private GroupDelegator(@NotNull SessionDelegate sessionDelegate, @NotNull Group groupDelegate) {
        super(sessionDelegate, (Authorizable)groupDelegate);
    }

    @NotNull
    static Group wrap(@NotNull SessionDelegate sessionDelegate, @NotNull Group group) {
        return new GroupDelegator(sessionDelegate, group);
    }

    @NotNull
    static Group unwrap(@NotNull Group group) {
        if (group instanceof GroupDelegator) {
            return ((GroupDelegator)group).getDelegate();
        }
        return group;
    }

    @NotNull
    private Group getDelegate() {
        return (Group)this.delegate;
    }

    @NotNull
    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<Authorizable>>("getDeclaredMembers"){

            @Override
            @NotNull
            public Iterator<Authorizable> perform() throws RepositoryException {
                Iterator authorizables = GroupDelegator.this.getDelegate().getDeclaredMembers();
                return Iterators.transform((Iterator)authorizables, authorizable -> AuthorizableDelegator.wrap(GroupDelegator.this.sessionDelegate, authorizable));
            }
        });
    }

    @NotNull
    public Iterator<Authorizable> getMembers() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<Authorizable>>("getMembers"){

            @Override
            @NotNull
            public Iterator<Authorizable> perform() throws RepositoryException {
                Iterator authorizables = GroupDelegator.this.getDelegate().getMembers();
                return Iterators.transform((Iterator)authorizables, authorizable -> AuthorizableDelegator.wrap(GroupDelegator.this.sessionDelegate, authorizable));
            }
        });
    }

    public boolean isDeclaredMember(final @NotNull Authorizable authorizable) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("isDeclaredMember"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().isDeclaredMember(AuthorizableDelegator.unwrap(authorizable));
            }
        });
    }

    public boolean isMember(final @NotNull Authorizable authorizable) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("isMember"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().isMember(AuthorizableDelegator.unwrap(authorizable));
            }
        });
    }

    public boolean addMember(final @NotNull Authorizable authorizable) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("addMember", true){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().addMember(AuthorizableDelegator.unwrap(authorizable));
            }
        });
    }

    @NotNull
    public Set<String> addMembers(final String ... memberIds) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Set<String>>("addMembers", true){

            @Override
            @NotNull
            public Set<String> perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().addMembers(memberIds);
            }
        });
    }

    public boolean removeMember(final @NotNull Authorizable authorizable) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("removeMember", true){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().removeMember(AuthorizableDelegator.unwrap(authorizable));
            }
        });
    }

    @NotNull
    public Set<String> removeMembers(final String ... memberIds) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Set<String>>("removeMembers", true){

            @Override
            @NotNull
            public Set<String> perform() throws RepositoryException {
                return GroupDelegator.this.getDelegate().removeMembers(memberIds);
            }
        });
    }
}

