/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.ItemOperation;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.version.VersionManagerImpl;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ReadWriteNodeTypeManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ItemImpl<T extends ItemDelegate>
implements Item {
    private static final Logger log = LoggerFactory.getLogger(ItemImpl.class);
    public static final String ITEM_SAVE_DOES_SESSION_SAVE = "item-save-does-session-save";
    public static final int MV_PROPERTY_WARN_THRESHOLD = 1000;
    public static final boolean SAVE_SESSION;
    protected final SessionContext sessionContext;
    protected final T dlg;
    protected final SessionDelegate sessionDelegate;

    protected ItemImpl(T itemDelegate, SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.dlg = itemDelegate;
        this.sessionDelegate = sessionContext.getSessionDelegate();
    }

    @NotNull
    protected final <U> U perform(@NotNull SessionOperation<U> op) throws RepositoryException {
        return this.sessionDelegate.perform(op);
    }

    @NotNull
    public String getName() throws RepositoryException {
        String oakName = this.perform(new ItemOperation<String>(this.dlg, "getName"){

            @Override
            @NotNull
            public String perform() {
                return this.item.getName();
            }

            @Override
            public String toString() {
                return String.format("getName [%s]", ((ItemDelegate)ItemImpl.this.dlg).getPath());
            }
        });
        return oakName.isEmpty() ? "" : this.toJcrPath(((ItemDelegate)this.dlg).getName());
    }

    @NotNull
    public String getPath() throws RepositoryException {
        return this.toJcrPath(this.perform(new ItemOperation<String>(this.dlg, "getPath"){

            @Override
            @NotNull
            public String perform() {
                return this.item.getPath();
            }
        }));
    }

    @NotNull
    public Session getSession() {
        return this.sessionContext.getSession();
    }

    public Item getAncestor(final int depth) throws RepositoryException {
        if (depth < 0) {
            throw new ItemNotFoundException(this.getPath() + "Invalid ancestor depth " + depth);
        }
        if (depth == 0) {
            return this.sessionContext.getSession().getRootNode();
        }
        ItemDelegate ancestor = this.perform(new ItemOperation<ItemDelegate>(this.dlg, "getAncestor"){

            @Override
            @NotNull
            public ItemDelegate perform() throws RepositoryException {
                String path = this.item.getPath();
                int slash = 0;
                for (int i = 0; i < depth - 1; ++i) {
                    if ((slash = PathUtils.getNextSlash((String)path, (int)(slash + 1))) != -1) continue;
                    throw new ItemNotFoundException(path + ": Invalid ancestor depth " + depth);
                }
                if ((slash = PathUtils.getNextSlash((String)path, (int)(slash + 1))) == -1) {
                    return this.item;
                }
                NodeDelegate ndlg = ItemImpl.this.sessionDelegate.getNode(path.substring(0, slash));
                if (ndlg == null) {
                    throw new ItemNotFoundException(ItemImpl.this.getPath() + "Invalid ancestor depth " + depth);
                }
                return ndlg;
            }
        });
        if (ancestor == this.dlg) {
            return this;
        }
        if (ancestor instanceof NodeDelegate) {
            return NodeImpl.createNode((NodeDelegate)ancestor, this.sessionContext);
        }
        throw new AccessDeniedException(this.getPath() + ": Access denied to ancestor at depth " + depth);
    }

    public int getDepth() throws RepositoryException {
        return PathUtils.getDepth((String)this.getPath());
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        if (this == otherItem) {
            return true;
        }
        if (this.isNode() != otherItem.isNode()) {
            return false;
        }
        if (!this.getSession().getRepository().equals(otherItem.getSession().getRepository())) {
            return false;
        }
        if (!this.getSession().getWorkspace().getName().equals(otherItem.getSession().getWorkspace().getName())) {
            return false;
        }
        if (this.isNode()) {
            return ((Node)this).getIdentifier().equals(((Node)otherItem).getIdentifier());
        }
        return this.getName().equals(otherItem.getName()) && this.getParent().isSame((Item)otherItem.getParent());
    }

    public void save() throws RepositoryException {
        try {
            this.sessionDelegate.performVoid((SessionOperation<Void>)new ItemWriteOperation<Void>("save"){

                @Override
                public void performVoid() throws RepositoryException {
                    ((ItemDelegate)ItemImpl.this.dlg).save();
                }

                @Override
                public boolean isSave() {
                    return true;
                }
            });
        }
        catch (UnsupportedRepositoryOperationException e) {
            if (SAVE_SESSION) {
                if (this.isNew()) {
                    throw new RepositoryException("Item.save() not allowed on new item");
                }
                log.warn("Item#save is only supported when the subtree rooted at that item contains all transient changes. Falling back to Session#save since system property item-save-does-session-save is true.");
                this.getSession().save();
            }
            throw e;
        }
    }

    public void refresh(final boolean keepChanges) throws RepositoryException {
        if (!keepChanges) {
            log.warn("Item#refresh invokes Session#refresh!");
        }
        this.sessionDelegate.performVoid(new SessionOperation<Void>("refresh"){

            @Override
            public void performVoid() throws InvalidItemStateException {
                ItemImpl.this.sessionDelegate.refresh(keepChanges);
                if (!((ItemDelegate)ItemImpl.this.dlg).exists()) {
                    throw new InvalidItemStateException("This item no longer exists");
                }
            }

            @Override
            public boolean isUpdate() {
                return true;
            }

            @Override
            public boolean isRefresh() {
                return true;
            }
        });
    }

    public String toString() {
        return (this.isNode() ? "Node[" : "Property[") + this.dlg + ']';
    }

    @NotNull
    String getOakName(String name) throws RepositoryException {
        return this.sessionContext.getOakName(name);
    }

    @NotNull
    String getOakPathOrThrow(String jcrPath) throws RepositoryException {
        return this.sessionContext.getOakPathOrThrow(jcrPath);
    }

    @NotNull
    String getOakPathOrThrowNotFound(String relPath) throws PathNotFoundException {
        return this.sessionContext.getOakPathOrThrowNotFound(relPath);
    }

    @NotNull
    String toJcrPath(String oakPath) {
        return this.sessionContext.getJcrPath(oakPath);
    }

    @NotNull
    ValueFactory getValueFactory() {
        return this.sessionContext.getValueFactory();
    }

    @NotNull
    ReadWriteNodeTypeManager getNodeTypeManager() {
        return this.sessionContext.getWorkspace().getNodeTypeManager();
    }

    @NotNull
    VersionManagerImpl getVersionManager() {
        return this.sessionContext.getWorkspace().internalGetVersionManager();
    }

    @NotNull
    protected PropertyState createSingleState(String oakName, Value value, Type<?> type) throws RepositoryException {
        if (type == Type.UNDEFINED) {
            type = Type.fromTag((int)value.getType(), (boolean)false);
        }
        if (type == Type.NAME || type == Type.PATH) {
            return PropertyStates.createProperty((String)oakName, (Object)this.getOakValue(value, type), (Type)type);
        }
        return PropertyStates.createProperty((String)oakName, (Value)value);
    }

    @NotNull
    protected PropertyState createMultiState(String oakName, List<Value> values, Type<?> type) throws RepositoryException {
        if (values.isEmpty()) {
            Type base = type.getBaseType();
            if (base == Type.UNDEFINED) {
                base = Type.STRING;
            }
            return PropertyBuilder.array((Type)base).setName(oakName).getPropertyState();
        }
        if (type == Type.UNDEFINEDS) {
            type = Type.fromTag((int)values.get(0).getType(), (boolean)true);
        }
        if (type == Type.NAMES || type == Type.PATHS) {
            Type base = type.getBaseType();
            ArrayList strings = Lists.newArrayListWithCapacity((int)values.size());
            for (Value value : values) {
                strings.add(this.getOakValue(value, base));
            }
            return PropertyStates.createProperty((String)oakName, (Object)strings, (Type)type);
        }
        return PropertyStates.createProperty((String)oakName, values, (int)type.tag());
    }

    private String getOakValue(Value value, Type<?> type) throws RepositoryException {
        if (type == Type.NAME) {
            return this.getOakName(value.getString());
        }
        if (type == Type.PATH) {
            String path = value.getString();
            if (!path.startsWith("[")) {
                path = this.getOakPathOrThrow(path);
            }
            return path;
        }
        throw new IllegalArgumentException();
    }

    static {
        String property = System.getProperty(ITEM_SAVE_DOES_SESSION_SAVE);
        SAVE_SESSION = property == null || Boolean.parseBoolean(property);
    }

    protected abstract class ItemWriteOperation<U>
    extends SessionOperation<U> {
        protected ItemWriteOperation(String name) {
            super(name, true);
        }

        @Override
        public void checkPreconditions() throws RepositoryException {
            ((ItemDelegate)ItemImpl.this.dlg).checkAlive();
            if (((ItemDelegate)ItemImpl.this.dlg).isProtected()) {
                throw new ConstraintViolationException("Item is protected.");
            }
        }
    }
}

