/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.repository;

import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.blob.BlobAccessProvider;
import org.apache.jackrabbit.oak.api.jmx.SessionMBean;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.repository.JcrDescriptorsImpl;
import org.apache.jackrabbit.oak.jcr.session.RefreshStrategy;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.SessionStats;
import org.apache.jackrabbit.oak.jcr.version.FrozenNodeLogger;
import org.apache.jackrabbit.oak.plugins.observation.CommitRateLimiter;
import org.apache.jackrabbit.oak.spi.descriptors.GenericDescriptors;
import org.apache.jackrabbit.oak.spi.gc.DelegatingGCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.query.SessionQuerySettings;
import org.apache.jackrabbit.oak.spi.query.SessionQuerySettingsProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryImpl
implements JackrabbitRepository {
    public static final String REFRESH_INTERVAL = "oak.refresh-interval";
    public static final String RELAXED_LOCKING = "oak.relaxed-locking";
    public static final String BOUND_PRINCIPALS = "oak.bound-principals";
    private static final Logger log = LoggerFactory.getLogger(RepositoryImpl.class);
    protected final Whiteboard whiteboard;
    protected final boolean fastQueryResultSize;
    private final boolean createSessionMBeans;
    private final GenericDescriptors descriptors;
    private final ContentRepository contentRepository;
    private final SecurityProvider securityProvider;
    private final int observationQueueLength;
    private final CommitRateLimiter commitRateLimiter;
    private final Clock.Fast clock;
    private final DelegatingGCMonitor gcMonitor = new DelegatingGCMonitor();
    private final Registration gcMonitorRegistration;
    private final MountInfoProvider mountInfoProvider;
    private final BlobAccessProvider blobAccessProvider;
    private final SessionQuerySettingsProvider sessionQuerySettingsProvider;
    private final ThreadLocal<Long> threadSaveCount = new ThreadLocal();
    private final ScheduledExecutorService scheduledExecutor = RepositoryImpl.createListeningScheduledExecutorService();
    private final StatisticManager statisticManager;
    private final FrozenNodeLogger frozenNodeLogger;

    public RepositoryImpl(@NotNull ContentRepository contentRepository, @NotNull Whiteboard whiteboard, @NotNull SecurityProvider securityProvider, int observationQueueLength, CommitRateLimiter commitRateLimiter) {
        this(contentRepository, whiteboard, securityProvider, observationQueueLength, commitRateLimiter, false, true);
    }

    public RepositoryImpl(@NotNull ContentRepository contentRepository, @NotNull Whiteboard whiteboard, @NotNull SecurityProvider securityProvider, int observationQueueLength, CommitRateLimiter commitRateLimiter, boolean fastQueryResultSize, boolean createSessionMBeans) {
        this.contentRepository = Objects.requireNonNull(contentRepository);
        this.whiteboard = Objects.requireNonNull(whiteboard);
        this.securityProvider = Objects.requireNonNull(securityProvider);
        this.observationQueueLength = observationQueueLength;
        this.commitRateLimiter = commitRateLimiter;
        this.descriptors = this.determineDescriptors();
        this.statisticManager = new StatisticManager(whiteboard, this.scheduledExecutor);
        this.clock = new Clock.Fast(this.scheduledExecutor);
        this.gcMonitorRegistration = whiteboard.register(GCMonitor.class, (Object)this.gcMonitor, Collections.emptyMap());
        this.fastQueryResultSize = fastQueryResultSize;
        this.createSessionMBeans = createSessionMBeans;
        this.mountInfoProvider = (MountInfoProvider)WhiteboardUtils.getService((Whiteboard)whiteboard, MountInfoProvider.class);
        this.blobAccessProvider = (BlobAccessProvider)WhiteboardUtils.getService((Whiteboard)whiteboard, BlobAccessProvider.class);
        this.frozenNodeLogger = new FrozenNodeLogger((Clock)this.clock, whiteboard);
        this.sessionQuerySettingsProvider = Optional.ofNullable((SessionQuerySettingsProvider)WhiteboardUtils.getService((Whiteboard)whiteboard, SessionQuerySettingsProvider.class)).orElseGet(() -> new FastQuerySizeSettingsProvider(fastQueryResultSize));
    }

    public String[] getDescriptorKeys() {
        return this.descriptors.getKeys();
    }

    public boolean isStandardDescriptor(String key) {
        return this.descriptors.isStandardDescriptor(key);
    }

    public String getDescriptor(String key) {
        try {
            Value v = this.getDescriptorValue(key);
            return v == null ? null : v.getString();
        }
        catch (RepositoryException e) {
            log.debug("Error converting value for descriptor with key {} to string", (Object)key);
            return null;
        }
    }

    public Value getDescriptorValue(String key) {
        return this.descriptors.getValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.descriptors.getValues(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.descriptors.isSingleValueDescriptor(key);
    }

    public Session login(@Nullable Credentials credentials, @Nullable String workspaceName) throws RepositoryException {
        return this.login(credentials, workspaceName, null);
    }

    public Session login() throws RepositoryException {
        return this.login(null, null, null);
    }

    public Session login(Credentials credentials) throws RepositoryException {
        return this.login(credentials, null, null);
    }

    public Session login(String workspace) throws RepositoryException {
        return this.login(null, workspace, null);
    }

    public Session login(@Nullable Credentials credentials, @Nullable String workspaceName, @Nullable Map<String, Object> attributes) throws RepositoryException {
        try {
            Long refreshInterval;
            if (attributes == null) {
                attributes = Collections.emptyMap();
            }
            if ((refreshInterval = RepositoryImpl.getRefreshInterval(credentials)) == null) {
                refreshInterval = RepositoryImpl.getRefreshInterval(attributes);
            } else if (attributes.containsKey(REFRESH_INTERVAL)) {
                throw new RepositoryException("Duplicate attribute 'oak.refresh-interval'.");
            }
            boolean relaxedLocking = RepositoryImpl.getRelaxedLocking(attributes);
            ContentSession contentSession = this.contentRepository.login(credentials, workspaceName);
            SessionDelegate sessionDelegate = this.createSessionDelegate(refreshInterval, contentSession);
            SessionContext context = this.createSessionContext(this.statisticManager, this.securityProvider, RepositoryImpl.createAttributes(refreshInterval, relaxedLocking), sessionDelegate, this.observationQueueLength, this.commitRateLimiter);
            return context.getSession();
        }
        catch (javax.security.auth.login.LoginException e) {
            throw new LoginException(e.getMessage(), (Throwable)e);
        }
    }

    private SessionDelegate createSessionDelegate(Long refreshInterval, ContentSession contentSession) {
        final RefreshOnGC refreshOnGC = new RefreshOnGC(this.gcMonitor);
        RefreshStrategy refreshStrategy = refreshInterval == null ? refreshOnGC : RefreshStrategy.Composite.create(new RefreshStrategy.Timed(refreshInterval), refreshOnGC);
        return new SessionDelegate(contentSession, this.securityProvider, refreshStrategy, this.threadSaveCount, this.statisticManager, (Clock)this.clock){
            final RegistrationTask registrationTask;
            final ScheduledFuture<?> scheduledTask;
            {
                super(contentSession, securityProvider, refreshStrategy, threadSaveCount, statisticManager, clock);
                this.registrationTask = RepositoryImpl.this.createSessionMBeans ? new RegistrationTask(this.getSessionStats(), RepositoryImpl.this.whiteboard) : null;
                this.scheduledTask = RepositoryImpl.this.createSessionMBeans ? RepositoryImpl.this.scheduledExecutor.schedule(this.registrationTask, 1L, TimeUnit.MINUTES) : null;
            }

            @Override
            protected void treeLookedUpByIdentifier(@NotNull Tree tree) {
                RepositoryImpl.this.frozenNodeLogger.lookupById(tree);
            }

            @Override
            public void logout() {
                refreshOnGC.close();
                if (this.registrationTask != null) {
                    this.registrationTask.cancel();
                    this.scheduledTask.cancel(false);
                }
                super.logout();
            }
        };
    }

    public void shutdown() {
        this.statisticManager.dispose();
        this.gcMonitorRegistration.unregister();
        this.frozenNodeLogger.close();
        this.clock.close();
        new ExecutorCloser((ExecutorService)this.scheduledExecutor).close();
        if (this.contentRepository instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)this.contentRepository));
        }
    }

    protected SessionContext createSessionContext(StatisticManager statisticManager, SecurityProvider securityProvider, Map<String, Object> attributes, SessionDelegate delegate, int observationQueueLength, CommitRateLimiter commitRateLimiter) {
        return new SessionContext((Repository)this, statisticManager, securityProvider, this.whiteboard, attributes, delegate, observationQueueLength, commitRateLimiter, this.mountInfoProvider, this.blobAccessProvider, this.sessionQuerySettingsProvider.getQuerySettings(delegate.getContentSession()));
    }

    protected GenericDescriptors determineDescriptors() {
        return new JcrDescriptorsImpl(this.contentRepository.getDescriptors(), (ValueFactory)new SimpleValueFactory());
    }

    protected GenericDescriptors getDescriptors() {
        return this.descriptors;
    }

    private static ScheduledExecutorService createListeningScheduledExecutorService() {
        ThreadFactory tf = new ThreadFactory(){
            private final AtomicLong counter = new AtomicLong();

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread t = new Thread(r, this.newName());
                t.setDaemon(true);
                return t;
            }

            private String newName() {
                return "oak-repository-executor-" + this.counter.incrementAndGet();
            }
        };
        return new ScheduledThreadPoolExecutor(1, tf){

            @Override
            public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
                this.purge();
                return super.schedule(callable, delay, unit);
            }

            @Override
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                this.purge();
                return super.schedule(command, delay, unit);
            }

            @Override
            public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
                this.purge();
                return super.scheduleAtFixedRate(command, initialDelay, period, unit);
            }

            @Override
            public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
                this.purge();
                return super.scheduleWithFixedDelay(command, initialDelay, delay, unit);
            }
        };
    }

    private static Long getRefreshInterval(Credentials credentials) {
        String value;
        if (credentials instanceof SimpleCredentials) {
            Object value2 = ((SimpleCredentials)credentials).getAttribute(REFRESH_INTERVAL);
            return RepositoryImpl.toLong(value2);
        }
        if (credentials instanceof TokenCredentials && (value = ((TokenCredentials)credentials).getAttribute(REFRESH_INTERVAL)) != null) {
            return RepositoryImpl.toLong(value);
        }
        return null;
    }

    private static Long getRefreshInterval(Map<String, Object> attributes) {
        return RepositoryImpl.toLong(attributes.get(REFRESH_INTERVAL));
    }

    private static boolean getRelaxedLocking(Map<String, Object> attributes) {
        Object value = attributes.get(RELAXED_LOCKING);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    private static Long toLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof String) {
            return RepositoryImpl.toLong((String)value);
        }
        return null;
    }

    private static Long toLong(String longValue) {
        try {
            return Long.valueOf(longValue);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid value '" + longValue + "' for oak.refresh-interval. Expected long. ", (Throwable)e);
            return null;
        }
    }

    private static Map<String, Object> createAttributes(Long refreshInterval, boolean relaxedLocking) {
        if (refreshInterval == null && !relaxedLocking) {
            return Collections.emptyMap();
        }
        if (refreshInterval == null) {
            return Collections.singletonMap(RELAXED_LOCKING, relaxedLocking);
        }
        if (!relaxedLocking) {
            return Collections.singletonMap(REFRESH_INTERVAL, refreshInterval);
        }
        return ImmutableMap.of((Object)REFRESH_INTERVAL, (Object)refreshInterval, (Object)RELAXED_LOCKING, (Object)relaxedLocking);
    }

    private static class FastQuerySizeSettingsProvider
    implements SessionQuerySettingsProvider {
        private final boolean fastQueryResultSize;

        public FastQuerySizeSettingsProvider(boolean fastQueryResultSize) {
            this.fastQueryResultSize = fastQueryResultSize;
        }

        @NotNull
        public SessionQuerySettings getQuerySettings(@NotNull ContentSession session) {
            return new SessionQuerySettings(){

                public boolean useDirectResultCount() {
                    return Optional.ofNullable(System.getProperty("oak.fastQuerySize")).map(Boolean::valueOf).orElse(fastQueryResultSize);
                }
            };
        }
    }

    private static class RegistrationTask
    implements Runnable {
        private final SessionStats sessionStats;
        private final Whiteboard whiteboard;
        private boolean cancelled;
        private Registration completed;

        public RegistrationTask(SessionStats sessionStats, Whiteboard whiteboard) {
            this.sessionStats = sessionStats;
            this.whiteboard = whiteboard;
        }

        @Override
        public synchronized void run() {
            if (!this.cancelled) {
                this.completed = WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, SessionMBean.class, (Object)this.sessionStats, (String)"SessionStatistics", (String)this.sessionStats.toString());
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
            if (this.completed != null) {
                this.completed.unregister();
                this.completed = null;
            }
        }
    }

    private static class RefreshOnGC
    extends GCMonitor.Empty
    implements RefreshStrategy {
        private final Registration registration;
        private volatile boolean compacted;

        public RefreshOnGC(DelegatingGCMonitor gcMonitor) {
            this.registration = gcMonitor.registerGCMonitor((GCMonitor)this);
        }

        public void close() {
            this.registration.unregister();
        }

        public void compacted() {
            this.compacted = true;
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            return this.compacted;
        }

        @Override
        public void refreshed() {
            this.compacted = false;
        }

        public String toString() {
            return "Refresh on revision garbage collection";
        }
    }
}

