/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.observation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.blob.BlobAccessProvider;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.jetbrains.annotations.NotNull;

public class EventFactory {
    public static final String USER_DATA = "user-data";
    private final NamePathMapper mapper;
    private final PartialValueFactory valueFactory;
    private final String userID;
    private final String userData;
    private final long date;
    private final boolean external;

    EventFactory(@NotNull NamePathMapper mapper, @NotNull BlobAccessProvider blobAccessProvider, @NotNull CommitInfo commitInfo) {
        this.mapper = mapper;
        this.valueFactory = new PartialValueFactory(mapper, blobAccessProvider);
        if (!commitInfo.isExternal()) {
            this.userID = commitInfo.getUserId();
            Object userData = commitInfo.getInfo().get(USER_DATA);
            this.userData = userData instanceof String ? (String)userData : null;
            this.date = commitInfo.getDate();
            this.external = false;
        } else {
            this.userID = commitInfo.getUserId();
            this.userData = null;
            this.date = commitInfo.getDate();
            this.external = true;
        }
    }

    Event propertyAdded(final PropertyState after, final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 4;
            }

            @Override
            public Map<?, ?> getInfo() {
                HashMap<String, Object> builder = new HashMap<String, Object>();
                builder.putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes));
                builder.put("afterValue", EventFactory.this.createValue(after));
                return Collections.unmodifiableMap(builder);
            }
        };
    }

    Event propertyChanged(final PropertyState before, final PropertyState after, final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 16;
            }

            @Override
            public Map<?, ?> getInfo() {
                HashMap<String, Object> builder = new HashMap<String, Object>();
                builder.putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes));
                builder.put("beforeValue", EventFactory.this.createValue(before));
                builder.put("afterValue", EventFactory.this.createValue(after));
                return Collections.unmodifiableMap(builder);
            }
        };
    }

    Event propertyDeleted(final PropertyState before, final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 8;
            }

            @Override
            public Map<?, ?> getInfo() {
                HashMap<String, Object> builder = new HashMap<String, Object>();
                builder.putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes));
                builder.put("beforeValue", EventFactory.this.createValue(before));
                return Collections.unmodifiableMap(builder);
            }
        };
    }

    private Object createValue(PropertyState property) {
        if (property.isArray()) {
            List values = this.valueFactory.createValues(property);
            return values.toArray(new Value[values.size()]);
        }
        return this.valueFactory.createValue(property);
    }

    Event nodeAdded(final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 1;
            }

            @Override
            public Map<?, ?> getInfo() {
                return EventFactory.this.createInfoMap(primaryType, mixinTypes);
            }
        };
    }

    Event nodeDeleted(final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 2;
            }

            @Override
            public Map<?, ?> getInfo() {
                return EventFactory.this.createInfoMap(primaryType, mixinTypes);
            }
        };
    }

    Event nodeMoved(final String primaryType, final Iterable<String> mixinTypes, String parent, String name, String identifier, final String sourcePath) {
        return new EventImpl(parent, name, identifier){

            public int getType() {
                return 32;
            }

            @Override
            public Map<?, ?> getInfo() {
                HashMap<String, String> builder = new HashMap<String, String>();
                builder.put("srcAbsPath", EventFactory.this.mapper.getJcrPath(sourcePath));
                builder.put("destAbsPath", this.getPath());
                builder.putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes));
                return Collections.unmodifiableMap(builder);
            }
        };
    }

    Event nodeReordered(final String primaryType, final Iterable<String> mixinTypes, String parent, String name, String identifier, final String destName) {
        return new EventImpl(parent, name, identifier){

            public int getType() {
                return 32;
            }

            @Override
            public Map<?, ?> getInfo() {
                HashMap<String, String> builder = new HashMap<String, String>();
                builder.put("srcChildRelPath", EventFactory.this.mapper.getJcrName(this.name));
                builder.put("destChildRelPath", EventFactory.this.mapper.getJcrName(destName));
                builder.putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes));
                return Collections.unmodifiableMap(builder);
            }
        };
    }

    private Map<String, ?> createInfoMap(String primaryType, Iterable<String> mixinTypes) {
        if (Iterables.isEmpty(mixinTypes)) {
            return Map.of("jcr:primaryType", this.mapper.getJcrName(primaryType));
        }
        ArrayList<String> jcrNames = new ArrayList<String>();
        for (String name : mixinTypes) {
            jcrNames.add(this.mapper.getJcrName(name));
        }
        return Map.of("jcr:primaryType", this.mapper.getJcrName(primaryType), "jcr:mixinTypes", Iterables.toArray(jcrNames, String.class));
    }

    private abstract class EventImpl
    implements JackrabbitEvent {
        private final String parent;
        protected final String name;
        private final String identifier;

        EventImpl(String parent, String name, String identifier) {
            this.parent = parent;
            this.name = name;
            this.identifier = identifier;
        }

        public String getPath() {
            return PathUtils.concat((String)EventFactory.this.mapper.getJcrPath(this.parent), (String)EventFactory.this.mapper.getJcrName(this.name));
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Map<?, ?> getInfo() {
            return Collections.emptyMap();
        }

        public String getUserID() {
            return EventFactory.this.userID;
        }

        public String getUserData() {
            return EventFactory.this.userData;
        }

        public long getDate() {
            return EventFactory.this.date;
        }

        public boolean isExternal() {
            return EventFactory.this.external;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof EventImpl) {
                EventImpl that = (EventImpl)object;
                return this.getType() == that.getType() && this.getPath().equals(that.getPath()) && this.getIdentifier().equals(that.getIdentifier()) && this.getInfo().equals(that.getInfo()) && Objects.equals(this.getUserID(), that.getUserID()) && Objects.equals(this.getUserData(), that.getUserData()) && this.getDate() == that.getDate() && this.isExternal() == that.isExternal();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getType(), this.getPath(), this.getIdentifier(), this.getInfo(), this.getUserID(), this.getUserData(), this.getDate(), this.isExternal());
        }

        public String toString() {
            return new StringJoiner(", ", "Event [", "]").add("type=" + this.getType()).add("path=" + this.getPath()).add("identifier=" + this.getIdentifier()).add("info=" + this.getInfo()).add("userID=" + this.getUserID()).add("userData=" + this.getUserData()).add("date=" + this.getDate()).add("external=" + this.isExternal()).toString();
        }
    }
}

