/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.lock.LockDeprecation;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.value.ValueHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDelegate
extends ItemDelegate {
    private final Tree tree;

    public NodeDelegate(SessionDelegate sessionDelegate, Tree tree) {
        super(sessionDelegate);
        this.tree = tree;
    }

    @Override
    @NotNull
    public String getName() {
        return this.tree.getName();
    }

    @Override
    @NotNull
    public String getPath() {
        return this.tree.getPath();
    }

    @Override
    @Nullable
    public NodeDelegate getParent() {
        return this.tree.isRoot() || !this.tree.getParent().exists() ? null : new NodeDelegate(this.sessionDelegate, this.tree.getParent());
    }

    @Override
    public boolean exists() {
        return this.tree.exists();
    }

    @Override
    @Nullable
    public Tree.Status getStatus() {
        return this.tree.getStatus();
    }

    @NotNull
    public String getIdentifier() throws InvalidItemStateException {
        return IdentifierManager.getIdentifier((Tree)this.getTree());
    }

    @Override
    public boolean isProtected() throws InvalidItemStateException {
        Tree tree = this.getTree();
        if (tree.isRoot()) {
            return false;
        }
        Tree parent = tree.getParent();
        String nameWithIndex = tree.getName();
        String name = PathUtils.dropIndexFromName((String)nameWithIndex);
        boolean sns = !name.equals(nameWithIndex);
        Tree typeRoot = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
        List types = TreeUtil.getEffectiveType((Tree)parent, (Tree)typeRoot);
        boolean protectedResidual = false;
        for (Tree type : types) {
            if (IterableUtils.contains((Iterable)TreeUtil.getNames((Tree)type, (String)"rep:protectedChildNodes"), (Object)name)) {
                return true;
            }
            if (protectedResidual) continue;
            protectedResidual = TreeUtil.getBoolean((Tree)type, (String)"rep:hasProtectedResidualChildNodes");
        }
        if (protectedResidual) {
            HashSet<String> typeNames = new HashSet<String>();
            for (Tree type : TreeUtil.getEffectiveType((Tree)tree, (Tree)typeRoot)) {
                typeNames.add(TreeUtil.getName((Tree)type, (String)"jcr:nodeTypeName"));
                TreeUtil.getNames((Tree)type, (String)"rep:supertypes").forEach(typeNames::add);
            }
            for (Tree type : types) {
                Tree definitions = type.getChild("rep:residualChildNodeDefinitions");
                for (String typeName : typeNames) {
                    Tree definition = definitions.getChild(typeName);
                    if (sns && !TreeUtil.getBoolean((Tree)definition, (String)"jcr:sameNameSiblings") || !TreeUtil.getBoolean((Tree)definition, (String)"jcr:protected")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    boolean isProtected(String propertyName, Type<?> propertyType) throws InvalidItemStateException {
        Tree definition;
        Tree tree = this.getTree();
        Tree typeRoot = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
        List types = TreeUtil.getEffectiveType((Tree)tree, (Tree)typeRoot);
        boolean protectedResidual = false;
        for (Tree type : types) {
            if (IterableUtils.contains((Iterable)TreeUtil.getNames((Tree)type, (String)"rep:protectedProperties"), (Object)propertyName)) {
                return true;
            }
            if (protectedResidual) continue;
            protectedResidual = TreeUtil.getBoolean((Tree)type, (String)"rep:hasProtectedResidualProperties");
        }
        return protectedResidual && (definition = this.findMatchingResidualPropertyDefinition(types, propertyType)) != null && TreeUtil.getBoolean((Tree)definition, (String)"jcr:protected");
    }

    public boolean isRoot() throws InvalidItemStateException {
        return this.getTree().isRoot();
    }

    public long getPropertyCount() throws InvalidItemStateException {
        return this.getTree().getPropertyCount();
    }

    @Nullable
    public PropertyDelegate getPropertyOrNull(String relPath) throws RepositoryException {
        PropertyDelegate property;
        Tree parent = this.tree;
        String name = relPath;
        int slash = relPath.lastIndexOf(47);
        if (slash != -1) {
            parent = this.getTree(relPath.substring(0, slash));
            name = relPath.substring(slash + 1);
        }
        if (parent != null && (property = new PropertyDelegate(this.sessionDelegate, parent, name)).exists()) {
            return property;
        }
        return null;
    }

    @NotNull
    public PropertyDelegate getProperty(String relPath) throws RepositoryException {
        Tree parent = this.tree;
        String name = relPath;
        int slash = relPath.lastIndexOf(47);
        if (slash != -1) {
            parent = this.getTree(relPath.substring(0, slash));
            name = relPath.substring(slash + 1);
        }
        return new PropertyDelegate(this.sessionDelegate, parent, name);
    }

    @NotNull
    public Iterator<PropertyDelegate> getProperties() throws InvalidItemStateException {
        return Iterators.transform(this.getTree().getProperties().iterator(), propertyState -> new PropertyDelegate(this.sessionDelegate, this.tree, propertyState.getName()));
    }

    public long getChildCount(long max) throws InvalidItemStateException {
        return this.getTree().getChildrenCount(max);
    }

    @Nullable
    public NodeDelegate getChild(String relPath) throws RepositoryException {
        if (relPath.isEmpty()) {
            return this;
        }
        Tree tree = this.getTree(relPath);
        return tree == null || !tree.exists() ? null : new NodeDelegate(this.sessionDelegate, tree);
    }

    @NotNull
    public Iterator<NodeDelegate> getChildren() throws InvalidItemStateException {
        Iterator iterator = this.getTree().getChildren().iterator();
        return Iterators.transform((Iterator)Iterators.filter(iterator, tree -> tree.exists()), tree -> new NodeDelegate(this.sessionDelegate, (Tree)tree));
    }

    public void orderBefore(String source, String target) throws ItemNotFoundException, InvalidItemStateException {
        Tree tree = this.getTree();
        if (!tree.getChild(source).exists()) {
            throw new ItemNotFoundException("Not a child: " + source);
        }
        if (target != null && !tree.getChild(target).exists()) {
            throw new ItemNotFoundException("Not a child: " + target);
        }
        tree.getChild(source).orderBefore(target);
    }

    public boolean canAddMixin(String typeName) throws RepositoryException {
        if (!LockDeprecation.isLockingSupported() && "mix:lockable".equals(typeName)) {
            return false;
        }
        Tree type = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes").getChild(typeName);
        if (type.exists()) {
            return !TreeUtil.getBoolean((Tree)type, (String)"jcr:isAbstract") && TreeUtil.getBoolean((Tree)type, (String)"jcr:isMixin");
        }
        throw new NoSuchNodeTypeException("Node type " + typeName + " does not exist");
    }

    public void addMixin(Function<Tree, Iterable<String>> existingMixins, String typeName) throws RepositoryException {
        TreeUtil.addMixin((Tree)this.getTree(), existingMixins, (String)typeName, (Tree)this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes"), (String)this.getUserID());
    }

    public void removeMixin(String typeName) throws RepositoryException {
        Tree tree = this.getTree();
        Set mixins = SetUtils.toLinkedSet((Iterable)TreeUtil.getNames((Tree)tree, (String)"jcr:mixinTypes"));
        if (!mixins.remove(typeName)) {
            throw new NoSuchNodeTypeException("Mixin " + typeName + " not contained in " + this.getPath());
        }
        this.updateMixins(mixins, Collections.singleton(typeName));
    }

    public void setMixins(Set<String> mixinNames) throws RepositoryException {
        Set existingMixins = SetUtils.toLinkedSet((Iterable)TreeUtil.getNames((Tree)this.tree, (String)"jcr:mixinTypes"));
        if (existingMixins.isEmpty()) {
            this.updateMixins(mixinNames, Collections.emptySet());
        } else {
            LinkedHashSet<String> toRemove = new LinkedHashSet<String>();
            for (String name : existingMixins) {
                if (mixinNames.remove(name)) continue;
                toRemove.add(name);
            }
            this.updateMixins(mixinNames, toRemove);
        }
    }

    public void updateMixins(Set<String> addMixinNames, Set<String> removedOakMixinNames) throws RepositoryException {
        for (String oakMixinName : addMixinNames) {
            this.addMixin(TreeUtil::getMixinTypeNames, oakMixinName);
        }
        if (!removedOakMixinNames.isEmpty()) {
            Tree newDefinition;
            Object oldDefinition;
            String name;
            Set mixinNames = SetUtils.toLinkedSet((Iterable)TreeUtil.getNames((Tree)this.getTree(), (String)"jcr:mixinTypes"));
            if (mixinNames.removeAll(removedOakMixinNames)) {
                mixinNames.addAll(addMixinNames);
                this.tree.setProperty("jcr:mixinTypes", (Object)mixinNames, Type.NAMES);
            }
            Tree typeRoot = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
            ArrayList<Tree> removed = new ArrayList<Tree>();
            for (String name2 : removedOakMixinNames) {
                removed.add(typeRoot.getChild(name2));
            }
            List<Tree> remaining = this.getNodeTypes(this.tree, typeRoot);
            for (PropertyState property : this.tree.getProperties()) {
                Type type;
                name = property.getName();
                oldDefinition = this.findMatchingPropertyDefinition(removed, name, type = property.getType(), true);
                if (oldDefinition == null || (newDefinition = this.findMatchingPropertyDefinition(remaining, name, type, true)) != null && (!TreeUtil.getBoolean((Tree)oldDefinition, (String)"jcr:protected") || TreeUtil.getBoolean((Tree)newDefinition, (String)"jcr:protected"))) continue;
                this.tree.removeProperty(name);
            }
            for (Tree child : this.tree.getChildren()) {
                name = child.getName();
                LinkedHashSet<String> typeNames = new LinkedHashSet<String>();
                for (Tree type : this.getNodeTypes(child, typeRoot)) {
                    typeNames.add(TreeUtil.getName((Tree)type, (String)"jcr:nodeTypeName"));
                    TreeUtil.getNames((Tree)type, (String)"rep:supertypes").forEach(typeNames::add);
                }
                oldDefinition = this.findMatchingChildNodeDefinition(removed, name, typeNames);
                if (oldDefinition == null || (newDefinition = this.findMatchingChildNodeDefinition(remaining, name, typeNames)) != null && (!TreeUtil.getBoolean((Tree)oldDefinition, (String)"jcr:protected") || TreeUtil.getBoolean((Tree)newDefinition, (String)"jcr:protected"))) continue;
                child.remove();
            }
        }
    }

    @NotNull
    public PropertyDelegate setProperty(PropertyState propertyState, boolean exactTypeMatch, boolean setProtected) throws RepositoryException {
        Tree tree = this.getTree();
        String name = propertyState.getName();
        Type type = propertyState.getType();
        PropertyState old = tree.getProperty(name);
        if (old != null && old.isArray() && !propertyState.isArray()) {
            throw new ValueFormatException("Can not assign a single value to multi-valued property: " + propertyState);
        }
        if (old != null && !old.isArray() && propertyState.isArray()) {
            throw new ValueFormatException("Can not assign multiple values to single valued property: " + propertyState);
        }
        Tree definition = this.findMatchingPropertyDefinition(this.getNodeTypes(tree), name, type, exactTypeMatch);
        if (definition == null) {
            throw new ConstraintViolationException("No matching property definition: " + propertyState);
        }
        if (!setProtected && TreeUtil.getBoolean((Tree)definition, (String)"jcr:protected")) {
            throw new ConstraintViolationException("Property is protected: " + propertyState);
        }
        Type requiredType = Type.fromString((String)TreeUtil.getString((Tree)definition, (String)"jcr:requiredType"));
        if (requiredType != Type.UNDEFINED) {
            if (TreeUtil.getBoolean((Tree)definition, (String)"jcr:multiple")) {
                requiredType = requiredType.getArrayType();
            }
            ValueHelper.checkSupportedConversion((int)propertyState.getType().tag(), (int)requiredType.tag());
            propertyState = PropertyStates.convert((PropertyState)propertyState, (Type)requiredType);
        }
        tree.setProperty(propertyState);
        return new PropertyDelegate(this.sessionDelegate, tree, name);
    }

    private List<Tree> getNodeTypes(Tree tree) {
        Root root = this.sessionDelegate.getRoot();
        return this.getNodeTypes(tree, root.getTree("/jcr:system/jcr:nodeTypes"));
    }

    private List<Tree> getNodeTypes(Tree tree, Tree typeRoot) {
        ArrayList<Tree> types = new ArrayList<Tree>();
        String primaryName = TreeUtil.getName((Tree)tree, (String)"jcr:primaryType");
        if (primaryName == null) {
            primaryName = "nt:base";
        }
        types.add(typeRoot.getChild(primaryName));
        for (String mixinName : TreeUtil.getNames((Tree)tree, (String)"jcr:mixinTypes")) {
            types.add(typeRoot.getChild(mixinName));
        }
        return types;
    }

    private boolean isNodeType(String typeName) {
        return this.isNodeType(this.tree, typeName, this.sessionDelegate.getRoot());
    }

    private boolean isNodeType(Tree tree, String typeName, Root root) {
        return TreeUtil.isNodeType((Tree)tree, (String)typeName, (Tree)root.getTree("/jcr:system/jcr:nodeTypes"));
    }

    private Tree findMatchingPropertyDefinition(List<Tree> types, String propertyName, Type<?> propertyType, boolean exactTypeMatch) {
        String escapedName = "jcr:primaryType".equals(propertyName) ? "rep:primaryType" : ("jcr:mixinTypes".equals(propertyName) ? "rep:mixinTypes" : ("jcr:uuid".equals(propertyName) ? "rep:uuid" : propertyName));
        String definedType = propertyType.toString();
        String undefinedType = Type.UNDEFINED.toString();
        if (propertyType.isArray()) {
            undefinedType = Type.UNDEFINEDS.toString();
        }
        Tree fuzzyMatch = null;
        for (Tree type : types) {
            Tree definitions = type.getChild("rep:namedPropertyDefinitions").getChild(escapedName);
            Tree definition = definitions.getChild(definedType);
            if (definition.exists()) {
                return definition;
            }
            definition = definitions.getChild(undefinedType);
            if (definition.exists()) {
                return definition;
            }
            for (Tree def : definitions.getChildren()) {
                if (propertyType.isArray() != TreeUtil.getBoolean((Tree)def, (String)"jcr:multiple")) continue;
                if (TreeUtil.getBoolean((Tree)def, (String)"jcr:protected")) {
                    return null;
                }
                if (exactTypeMatch || fuzzyMatch != null) continue;
                fuzzyMatch = def;
            }
        }
        return this.findMatchingResidualPropertyDefinition(fuzzyMatch, types, propertyType.isArray(), definedType, undefinedType, exactTypeMatch);
    }

    private Tree findMatchingResidualPropertyDefinition(List<Tree> types, Type<?> propertyType) {
        String definedType = propertyType.toString();
        String undefinedType = Type.UNDEFINED.toString();
        if (propertyType.isArray()) {
            undefinedType = Type.UNDEFINEDS.toString();
        }
        return this.findMatchingResidualPropertyDefinition(null, types, propertyType.isArray(), definedType, undefinedType, true);
    }

    private Tree findMatchingResidualPropertyDefinition(Tree fuzzyMatch, List<Tree> types, boolean isMultiValue, String definedType, String undefinedType, boolean exactTypeMatch) {
        block0: for (Tree type : types) {
            Tree definitions = type.getChild("rep:residualPropertyDefinitions");
            Tree definition = definitions.getChild(definedType);
            if (definition.exists()) {
                return definition;
            }
            definition = definitions.getChild(undefinedType);
            if (definition.exists()) {
                return definition;
            }
            if (exactTypeMatch || fuzzyMatch != null) continue;
            for (Tree def : definitions.getChildren()) {
                if (isMultiValue != TreeUtil.getBoolean((Tree)def, (String)"jcr:multiple")) continue;
                fuzzyMatch = def;
                continue block0;
            }
        }
        return fuzzyMatch;
    }

    private Tree findMatchingChildNodeDefinition(List<Tree> types, String childNodeName, Set<String> typeNames) {
        Tree definition;
        Tree definitions;
        for (Tree type : types) {
            definitions = type.getChild("rep:namedChildNodeDefinitions").getChild(childNodeName);
            for (String typeName : typeNames) {
                definition = definitions.getChild(typeName);
                if (!definition.exists()) continue;
                return definition;
            }
        }
        for (Tree type : types) {
            definitions = type.getChild("rep:residualChildNodeDefinitions");
            for (String typeName : typeNames) {
                definition = definitions.getChild(typeName);
                if (!definition.exists()) continue;
                return definition;
            }
        }
        return null;
    }

    @Nullable
    public NodeDelegate addChild(String name, String typeName) throws RepositoryException {
        Tree tree = this.getTree();
        if (tree.hasChild(name)) {
            return null;
        }
        Tree typeRoot = this.sessionDelegate.getRoot().getTree("/jcr:system/jcr:nodeTypes");
        Tree child = TreeUtil.addChild((Tree)tree, (String)name, (String)typeName, (Tree)typeRoot, (String)this.getUserID());
        return new NodeDelegate(this.sessionDelegate, child);
    }

    @Override
    public boolean remove() throws InvalidItemStateException {
        return this.getTree().remove();
    }

    public void setOrderableChildren(boolean enable) throws InvalidItemStateException {
        this.getTree().setOrderableChildren(enable);
    }

    public boolean isLocked() {
        return this.getLock() != null;
    }

    @Nullable
    public NodeDelegate getLock() {
        Tree lock = this.findLock(this.tree, false);
        if (lock != null) {
            NodeDelegate delegate = new NodeDelegate(this.sessionDelegate, lock);
            if (delegate.isNodeType("mix:lockable")) {
                return delegate;
            }
            if (lock.isRoot()) {
                return null;
            }
            lock = this.findLock(lock.getParent(), true);
        }
        return null;
    }

    @Nullable
    private Tree findLock(@NotNull Tree tree, boolean deep) {
        if (this.holdsLock(tree, deep)) {
            return tree;
        }
        if (tree.isRoot()) {
            return null;
        }
        return this.findLock(tree.getParent(), true);
    }

    private boolean holdsLock(Tree tree, boolean deep) {
        PropertyState property = tree.getProperty("jcr:lockIsDeep");
        return property != null && property.getType() == Type.BOOLEAN && (!deep || (Boolean)property.getValue(Type.BOOLEAN) != false);
    }

    @Nullable
    private Tree findDescendantLock(@NotNull Tree tree) {
        for (Tree child : tree.getChildren()) {
            if (this.holdsLock(child, false)) {
                return child;
            }
            Tree desc = this.findDescendantLock(child);
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    public boolean holdsLock(boolean deep) {
        return this.holdsLock(this.tree, deep) && this.isNodeType("mix:lockable");
    }

    public String getLockOwner() {
        PropertyState property = this.tree.getProperty("jcr:lockOwner");
        if (property != null && property.getType() == Type.STRING) {
            return (String)property.getValue(Type.STRING);
        }
        return null;
    }

    public boolean isLockOwner(String user) {
        return user != null && user.equals(this.getLockOwner());
    }

    public void lock(boolean isDeep) throws RepositoryException {
        Tree descendantLock;
        String path = this.getPath();
        Root root = this.sessionDelegate.getContentSession().getLatestRoot();
        Tree tree = root.getTree(path);
        if (!tree.exists()) {
            throw new ItemNotFoundException("Node " + path + " does not exist");
        }
        if (!this.isNodeType(tree, "mix:lockable", root)) {
            throw new LockException("Node " + path + " is not lockable");
        }
        if (tree.hasProperty("jcr:lockIsDeep")) {
            throw new LockException("Node " + path + " is already locked");
        }
        Tree inheritedLock = this.findLock(tree, true);
        if (inheritedLock != null) {
            throw new LockException("Node already indirectly locked by " + inheritedLock.getPath());
        }
        if (isDeep && (descendantLock = this.findDescendantLock(tree)) != null) {
            throw new LockException("Lock conflicts with lock hold by " + descendantLock.getPath());
        }
        try {
            String owner = this.sessionDelegate.getAuthInfo().getUserID();
            if (owner == null) {
                owner = "";
            }
            tree.setProperty("jcr:lockIsDeep", (Object)isDeep);
            tree.setProperty("jcr:lockOwner", (Object)owner);
            this.sessionDelegate.commit(root);
        }
        catch (CommitFailedException e) {
            if (e.isAccessViolation()) {
                throw new AccessControlException("Access denied to lock node " + path, (Throwable)e);
            }
            throw new RepositoryException("Unable to lock node " + path, (Throwable)e);
        }
    }

    public void unlock() throws RepositoryException {
        String path = this.getPath();
        Root root = this.sessionDelegate.getContentSession().getLatestRoot();
        Tree tree = root.getTree(path);
        if (!tree.exists()) {
            throw new ItemNotFoundException("Node " + path + " does not exist");
        }
        if (!this.isNodeType(tree, "mix:lockable", root)) {
            throw new LockException("Node " + path + " is not lockable");
        }
        if (!tree.hasProperty("jcr:lockIsDeep")) {
            throw new LockException("Node " + path + " is not locked");
        }
        try {
            tree.removeProperty("jcr:lockIsDeep");
            tree.removeProperty("jcr:lockOwner");
            this.sessionDelegate.commit(root);
        }
        catch (CommitFailedException e) {
            if (e.isAccessViolation()) {
                throw new AccessControlException("Access denied to unlock node " + path, (Throwable)e);
            }
            throw new RepositoryException("Unable to unlock node " + path, (Throwable)e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", NodeDelegate.class.getSimpleName() + "[", "]").add("tree=" + this.tree).toString();
    }

    @NotNull
    public Tree getTree() throws InvalidItemStateException {
        if (!this.tree.exists()) {
            throw new InvalidItemStateException("Item is stale " + this.tree.getPath());
        }
        return this.tree;
    }

    private Tree getTree(String relPath) throws RepositoryException {
        if (PathUtils.isAbsolute((String)relPath)) {
            throw new RepositoryException("Not a relative path: " + relPath);
        }
        return TreeUtil.getTree((Tree)this.tree, (String)relPath);
    }

    private String getUserID() {
        return this.sessionDelegate.getAuthInfo().getUserID();
    }
}

