/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.session.RefreshStrategy;
import org.apache.jackrabbit.oak.jcr.session.SessionNamespaces;
import org.apache.jackrabbit.oak.jcr.session.SessionStats;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionAware;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.state.ReadyOnlyBuilderException;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticManager;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionDelegate {
    static final Logger log = LoggerFactory.getLogger(SessionDelegate.class);
    static final Logger auditLogger = LoggerFactory.getLogger((String)"org.apache.jackrabbit.oak.audit");
    static final Logger readOperationLogger = LoggerFactory.getLogger((String)"org.apache.jackrabbit.oak.jcr.operations.reads");
    static final Logger writeOperationLogger = LoggerFactory.getLogger((String)"org.apache.jackrabbit.oak.jcr.operations.writes");
    private static final long LOG_TRACE_BIT_MASK = (Long)SystemPropertySupplier.create((String)"org.apache.jackrabbit.oak.jcr.operations.bitMask", (Object)127L).loggingTo(log).get();
    private static final long LOG_TRACE_STACK_BIT_MASK = (Long)SystemPropertySupplier.create((String)"org.apache.jackrabbit.oak.jcr.operations.stack.bitMask", (Object)1048575L).loggingTo(log).get();
    private static final AtomicLong LOG_COUNTER = new AtomicLong();
    private final ContentSession contentSession;
    private final SecurityProvider securityProvider;
    private final RefreshAtNextAccess refreshAtNextAccess = new RefreshAtNextAccess();
    private final SaveCountRefresh saveCountRefresh;
    private final RefreshStrategy refreshStrategy;
    private final Root root;
    private final IdentifierManager idManager;
    private final SessionStats sessionStats;
    private final Clock clock;
    private final SessionStats.Counters sessionCounters;
    private final MeterStats readCounter;
    private final TimerStats readDuration;
    private final MeterStats writeCounter;
    private final TimerStats writeDuration;
    private boolean isAlive = true;
    private int sessionOpCount;
    private long updateCount = 0L;
    private String userData = null;
    private PermissionProvider permissionProvider;
    private boolean refreshPermissionProvider = false;
    private final WarningLock lock = new WarningLock(new ReentrantLock());
    private final SessionNamespaces namespaces;

    public SessionDelegate(@NotNull ContentSession contentSession, @NotNull SecurityProvider securityProvider, @NotNull RefreshStrategy refreshStrategy, @NotNull ThreadLocal<Long> threadSaveCount, @NotNull StatisticManager statisticManager, @NotNull Clock clock) {
        this.contentSession = Objects.requireNonNull(contentSession);
        this.securityProvider = Objects.requireNonNull(securityProvider);
        this.root = contentSession.getLatestRoot();
        this.namespaces = new SessionNamespaces(this.root);
        this.saveCountRefresh = new SaveCountRefresh(Objects.requireNonNull(threadSaveCount));
        this.refreshStrategy = RefreshStrategy.Composite.create(Objects.requireNonNull(refreshStrategy), this.refreshAtNextAccess, this.saveCountRefresh, new RefreshNamespaces(this.namespaces));
        this.idManager = new IdentifierManager(this.root);
        this.clock = Objects.requireNonNull(clock);
        Objects.requireNonNull(statisticManager);
        this.sessionStats = new SessionStats(contentSession.toString(), contentSession.getAuthInfo(), clock, refreshStrategy, this, statisticManager);
        this.sessionCounters = this.sessionStats.getCounters();
        this.readCounter = statisticManager.getMeter(RepositoryStatistics.Type.SESSION_READ_COUNTER);
        this.readDuration = statisticManager.getTimer(RepositoryStatistics.Type.SESSION_READ_DURATION);
        this.writeCounter = statisticManager.getMeter(RepositoryStatistics.Type.SESSION_WRITE_COUNTER);
        this.writeDuration = statisticManager.getTimer(RepositoryStatistics.Type.SESSION_WRITE_DURATION);
    }

    @NotNull
    public SessionStats getSessionStats() {
        return this.sessionStats;
    }

    public void refreshAtNextAccess() {
        this.lock.lock();
        try {
            this.refreshAtNextAccess.refreshAtNextAccess(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> Iterator<T> sync(Iterator<T> iterator) {
        return new SynchronizedIterator<T>(iterator, this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T> T perform(@NotNull SessionOperation<T> sessionOperation) throws RepositoryException {
        long t0 = this.clock.getTime();
        this.lock.lock(sessionOperation);
        try {
            T t;
            this.prePerform(sessionOperation, t0);
            try {
                ++this.sessionOpCount;
                T result = sessionOperation.perform();
                SessionDelegate.logOperationDetails(this.contentSession, sessionOperation);
                t = result;
                this.postPerform(sessionOperation, t0);
            }
            catch (Throwable throwable) {
                try {
                    this.postPerform(sessionOperation, t0);
                    throw throwable;
                }
                catch (ReadyOnlyBuilderException e) {
                    throw new ConstraintViolationException((Throwable)e);
                }
            }
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T performNullable(@NotNull SessionOperation<T> sessionOperation) throws RepositoryException {
        long t0 = this.clock.getTime();
        this.lock.lock(sessionOperation);
        try {
            T t;
            this.prePerform(sessionOperation, t0);
            try {
                ++this.sessionOpCount;
                T result = sessionOperation.performNullable();
                SessionDelegate.logOperationDetails(this.contentSession, sessionOperation);
                t = result;
                this.postPerform(sessionOperation, t0);
            }
            catch (Throwable throwable) {
                try {
                    this.postPerform(sessionOperation, t0);
                    throw throwable;
                }
                catch (ReadyOnlyBuilderException e) {
                    throw new ConstraintViolationException((Throwable)e);
                }
            }
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performVoid(SessionOperation<Void> sessionOperation) throws RepositoryException {
        long t0 = this.clock.getTime();
        this.lock.lock(sessionOperation);
        try {
            this.prePerform(sessionOperation, t0);
            try {
                ++this.sessionOpCount;
                sessionOperation.performVoid();
                SessionDelegate.logOperationDetails(this.contentSession, sessionOperation);
            }
            finally {
                this.postPerform(sessionOperation, t0);
            }
        }
        catch (ReadyOnlyBuilderException e) {
            throw new ConstraintViolationException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @NotNull
    public <T> T safePerform(SessionOperation<T> sessionOperation) {
        try {
            return this.perform(sessionOperation);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unexpected exception thrown by operation " + sessionOperation, e);
        }
    }

    @Nullable
    public <T> T safePerformNullable(SessionOperation<T> sessionOperation) {
        try {
            return this.performNullable(sessionOperation);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unexpected exception thrown by operation " + sessionOperation, e);
        }
    }

    @NotNull
    public ContentSession getContentSession() {
        return this.contentSession;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void checkAlive() throws RepositoryException {
        if (!this.isAlive()) {
            throw new RepositoryException("This session has been closed.");
        }
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    private void commit(Root root, String path) throws CommitFailedException {
        HashMap<String, String> info = new HashMap<String, String>();
        if (path != null && !PathUtils.denotesRoot((String)path)) {
            info.put("path", path);
        }
        if (this.userData != null) {
            info.put("user-data", this.userData);
        }
        root.commit(Collections.unmodifiableMap(info));
        if (this.permissionProvider != null && this.refreshPermissionProvider) {
            this.permissionProvider.refresh();
        }
    }

    public void commit() throws CommitFailedException {
        this.commit(this.root, null);
    }

    public void commit(Root root) throws CommitFailedException {
        this.commit(root, null);
    }

    public void checkProtectedNode(String path) throws RepositoryException {
        NodeDelegate node = this.getNode(path);
        if (node == null) {
            throw new PathNotFoundException("Node " + path + " does not exist.");
        }
        if (node.isProtected()) {
            throw new ConstraintViolationException("Node " + path + " is protected.");
        }
    }

    @NotNull
    public AuthInfo getAuthInfo() {
        return this.contentSession.getAuthInfo();
    }

    public void logout() {
        if (!this.isAlive) {
            return;
        }
        this.isAlive = false;
        this.sessionStats.close();
        try {
            this.contentSession.close();
        }
        catch (IOException e) {
            log.warn("Error while closing connection", (Throwable)e);
        }
    }

    @NotNull
    public IdentifierManager getIdManager() {
        return this.idManager;
    }

    @Nullable
    public NodeDelegate getRootNode() {
        return this.getNode("/");
    }

    @Nullable
    public NodeDelegate getNode(String path) {
        Tree tree = this.root.getTree(path);
        return tree.exists() ? new NodeDelegate(this, tree) : null;
    }

    @Nullable
    public ItemDelegate getItem(String path) {
        String name = PathUtils.getName((String)path);
        if (name.isEmpty()) {
            return this.getRootNode();
        }
        Tree parent = this.root.getTree(PathUtils.getParentPath((String)path));
        Tree child = parent.getChild(name);
        if (child.exists()) {
            return new NodeDelegate(this, child);
        }
        if (parent.hasProperty(name)) {
            return new PropertyDelegate(this, parent, name);
        }
        return null;
    }

    @Nullable
    public NodeDelegate getNodeByIdentifier(String id) {
        Tree tree = this.idManager.getTree(id);
        if (tree == null || !tree.exists()) {
            return null;
        }
        this.treeLookedUpByIdentifier(tree);
        return new NodeDelegate(this, tree);
    }

    protected void treeLookedUpByIdentifier(@NotNull Tree tree) {
    }

    @Nullable
    public PropertyDelegate getProperty(String path) {
        String name;
        Tree parent = this.root.getTree(PathUtils.getParentPath((String)path));
        return parent.hasProperty(name = PathUtils.getName((String)path)) ? new PropertyDelegate(this, parent, name) : null;
    }

    public boolean hasPendingChanges() {
        return this.root.hasPendingChanges();
    }

    public void save(String path) throws RepositoryException {
        this.sessionCounters.saveTime = this.clock.getTime();
        ++this.sessionCounters.saveCount;
        try {
            this.commit(this.root, path);
        }
        catch (CommitFailedException e) {
            RepositoryException repositoryException = SessionDelegate.newRepositoryException(e);
            this.sessionStats.failedSave(repositoryException);
            throw repositoryException;
        }
    }

    public void refresh(boolean keepChanges) {
        this.sessionCounters.refreshTime = this.clock.getTime();
        ++this.sessionCounters.refreshCount;
        if (keepChanges && this.hasPendingChanges()) {
            this.root.rebase();
        } else {
            this.root.refresh();
        }
        if (this.permissionProvider != null && this.refreshPermissionProvider) {
            this.permissionProvider.refresh();
        }
    }

    @NotNull
    public String getWorkspaceName() {
        return this.contentSession.getWorkspaceName();
    }

    public void move(String srcPath, String destPath, boolean transientOp) throws RepositoryException {
        Root moveRoot = transientOp ? this.root : this.contentSession.getLatestRoot();
        Tree dest = moveRoot.getTree(destPath);
        if (dest.exists()) {
            throw new ItemExistsException(destPath);
        }
        String destParentPath = PathUtils.getParentPath((String)destPath);
        Tree destParent = moveRoot.getTree(destParentPath);
        if (!destParent.exists()) {
            throw new PathNotFoundException(PathUtils.getParentPath((String)destPath));
        }
        Tree src = moveRoot.getTree(srcPath);
        if (!src.exists()) {
            throw new PathNotFoundException(srcPath);
        }
        try {
            if (!moveRoot.move(srcPath, destPath)) {
                throw new RepositoryException("Cannot move node at " + srcPath + " to " + destPath);
            }
            if (!transientOp) {
                this.sessionCounters.saveTime = this.clock.getTime();
                ++this.sessionCounters.saveCount;
                this.commit(moveRoot);
                this.refresh(true);
            }
        }
        catch (CommitFailedException e) {
            throw SessionDelegate.newRepositoryException(e);
        }
    }

    @NotNull
    public QueryEngine getQueryEngine() {
        return this.root.getQueryEngine();
    }

    @NotNull
    public PermissionProvider getPermissionProvider() {
        if (this.permissionProvider == null) {
            if (this.root instanceof PermissionAware) {
                this.permissionProvider = ((PermissionAware)this.root).getPermissionProvider();
            } else {
                this.permissionProvider = ((AuthorizationConfiguration)Objects.requireNonNull(this.securityProvider).getConfiguration(AuthorizationConfiguration.class)).getPermissionProvider(this.root, this.getWorkspaceName(), this.getAuthInfo().getPrincipals());
                this.refreshPermissionProvider = true;
            }
        }
        return this.permissionProvider;
    }

    @NotNull
    public Root getRoot() {
        return this.root;
    }

    public String toString() {
        return this.contentSession.toString();
    }

    private void prePerform(@NotNull SessionOperation<?> op, long t0) throws RepositoryException {
        if (this.sessionOpCount == 0) {
            if (!op.isRefresh() && !op.isSave() && !op.isLogout() && this.refreshStrategy.needsRefresh(TimeUnit.SECONDS.convert(t0 - this.sessionCounters.accessTime, TimeUnit.MILLISECONDS))) {
                this.refresh(true);
                this.refreshStrategy.refreshed();
                ++this.updateCount;
            }
            op.checkPreconditions();
        }
    }

    private void postPerform(@NotNull SessionOperation<?> op, long t0) {
        this.sessionCounters.accessTime = t0;
        long dt = TimeUnit.NANOSECONDS.convert(this.clock.getTime() - t0, TimeUnit.MILLISECONDS);
        --this.sessionOpCount;
        if (op.isUpdate()) {
            this.sessionCounters.writeTime = t0;
            ++this.sessionCounters.writeCount;
            this.writeCounter.mark();
            this.writeDuration.update(dt, TimeUnit.NANOSECONDS);
            ++this.updateCount;
        } else {
            this.sessionCounters.readTime = t0;
            ++this.sessionCounters.readCount;
            this.readCounter.mark();
            this.readDuration.update(dt, TimeUnit.NANOSECONDS);
        }
        if (op.isSave()) {
            this.refreshAtNextAccess.refreshAtNextAccess(false);
            this.saveCountRefresh.forceRefresh();
        } else if (op.isRefresh()) {
            this.refreshAtNextAccess.refreshAtNextAccess(false);
            this.saveCountRefresh.refreshed();
        }
    }

    private static <T> void logOperationDetails(ContentSession session, SessionOperation<T> ops) {
        if (readOperationLogger.isTraceEnabled() || writeOperationLogger.isTraceEnabled() || auditLogger.isDebugEnabled()) {
            Logger log = ops.isUpdate() ? writeOperationLogger : readOperationLogger;
            long logId = LOG_COUNTER.incrementAndGet();
            if ((logId & LOG_TRACE_BIT_MASK) == 0L) {
                if ((logId & LOG_TRACE_STACK_BIT_MASK) == 0L) {
                    Exception e = new Exception("count: " + LOG_COUNTER);
                    log.trace("[{}] {}", new Object[]{session, ops, e});
                } else {
                    log.trace("[{}] {}", (Object)session, ops);
                }
            }
            if (!ops.isLogout() && !ops.isRefresh() && !ops.isSave() && ops.isUpdate()) {
                auditLogger.debug("[{}] [{}] {}", new Object[]{session.getAuthInfo().getUserID(), session, ops});
            }
        }
    }

    private static RepositoryException newRepositoryException(CommitFailedException exception) {
        return exception.asRepositoryException();
    }

    public SessionNamespaces getNamespaces() {
        return this.namespaces;
    }

    private static class RefreshNamespaces
    implements RefreshStrategy {
        private final SessionNamespaces namespaces;

        public RefreshNamespaces(SessionNamespaces namespaces) {
            this.namespaces = namespaces;
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            return false;
        }

        @Override
        public void refreshed() {
            this.namespaces.onSessionRefresh();
        }
    }

    private static class SaveCountRefresh
    implements RefreshStrategy {
        private final ThreadLocal<Long> threadSaveCount;
        private long sessionSaveCount;

        public SaveCountRefresh(ThreadLocal<Long> threadSaveCount) {
            this.threadSaveCount = threadSaveCount;
            this.sessionSaveCount = this.getThreadSaveCount();
        }

        public void forceRefresh() {
            this.sessionSaveCount = this.getThreadSaveCount() + 1L;
            this.threadSaveCount.set(this.sessionSaveCount);
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            return this.sessionSaveCount != this.getThreadSaveCount();
        }

        @Override
        public void refreshed() {
            this.sessionSaveCount = this.getThreadSaveCount();
        }

        private long getThreadSaveCount() {
            Long c = this.threadSaveCount.get();
            return c == null ? 0L : c;
        }

        public String toString() {
            return "Refresh after a save on the same thread from a different session";
        }
    }

    private static class RefreshAtNextAccess
    implements RefreshStrategy {
        private boolean refreshAtNextAccess;

        private RefreshAtNextAccess() {
        }

        public void refreshAtNextAccess(boolean refreshAtNextAccess) {
            this.refreshAtNextAccess = refreshAtNextAccess;
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            return this.refreshAtNextAccess;
        }

        @Override
        public void refreshed() {
            this.refreshAtNextAccess = false;
        }

        public String toString() {
            return "Refresh on observation event";
        }
    }

    private static final class WarningLock
    implements Lock {
        private final Lock lock;
        private boolean isUpdate;
        private Exception holderTrace;
        private String holderThread;

        private WarningLock(Lock lock) {
            this.lock = lock;
        }

        public void lock(boolean isUpdate, Object operation) {
            if (!this.lock.tryLock()) {
                this.lock.lock();
                if (this.holderThread != null) {
                    if (this.isUpdate) {
                        WarningLock.warn(log, "Attempted to perform " + operation.toString() + " while thread " + this.holderThread + " was concurrently writing to this session. Blocked until the other thread finished using this session. Please review your code to avoid concurrent use of a session.", this.holderTrace);
                    } else if (log.isDebugEnabled()) {
                        log.debug("Attempted to perform " + operation.toString() + " while thread " + this.holderThread + " was concurrently reading from this session. Blocked until the other thread finished using this session. Please review your code to avoid concurrent use of a session.", (Throwable)this.holderTrace);
                    }
                }
            }
            this.isUpdate = isUpdate;
            if (log.isDebugEnabled()) {
                this.holderTrace = new Exception("Stack trace of concurrent access to session");
            }
            this.holderThread = Thread.currentThread().getName();
        }

        private static void warn(Logger logger, String message, Exception stackTrace) {
            if (stackTrace != null) {
                logger.warn(message, (Throwable)stackTrace);
            } else {
                logger.warn(message);
            }
        }

        public void lock(SessionOperation<?> sessionOperation) {
            this.lock(sessionOperation.isUpdate(), sessionOperation);
        }

        @Override
        public void lock() {
            this.lock.lock();
            this.holderTrace = null;
            this.holderThread = null;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock.lockInterruptibly();
            this.holderTrace = null;
            this.holderThread = null;
        }

        @Override
        public boolean tryLock() {
            if (this.lock.tryLock()) {
                this.holderTrace = null;
                this.holderThread = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (this.lock.tryLock(time, unit)) {
                this.holderTrace = null;
                this.holderThread = null;
                return true;
            }
            return false;
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }

        @Override
        @NotNull
        public Condition newCondition() {
            return this.lock.newCondition();
        }
    }

    private static final class SynchronizedIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private final WarningLock lock;

        SynchronizedIterator(Iterator<T> iterator, WarningLock lock) {
            this.iterator = iterator;
            this.lock = lock;
        }

        @Override
        public boolean hasNext() {
            this.lock.lock(false, "hasNext()");
            try {
                boolean bl = this.iterator.hasNext();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public T next() {
            this.lock.lock(false, "next()");
            try {
                T t = this.iterator.next();
                return t;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void remove() {
            this.lock.lock(true, "remove()");
            try {
                this.iterator.remove();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

