/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.Objects;
import java.util.TreeSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.commons.xml.DocumentViewExporter;
import org.apache.jackrabbit.commons.xml.Exporter;
import org.apache.jackrabbit.commons.xml.ParsingContentHandler;
import org.apache.jackrabbit.commons.xml.SystemViewExporter;
import org.apache.jackrabbit.commons.xml.ToXmlContentHandler;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.security.AccessManager;
import org.apache.jackrabbit.oak.jcr.session.ItemImpl;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.PropertyImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.xml.ImportHandler;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SessionImpl
implements JackrabbitSession {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private SessionContext sessionContext;
    private SessionDelegate sd;
    private final CounterStats sessionCounter;
    private final Object logoutMonitor = new Object();

    public SessionImpl(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.sd = sessionContext.getSessionDelegate();
        this.sessionCounter = sessionContext.getCount(RepositoryStatistics.Type.SESSION_COUNT);
        this.sessionCounter.inc();
        sessionContext.getMeter(RepositoryStatistics.Type.SESSION_LOGIN_COUNTER).mark();
    }

    static void checkIndexOnName(String jcrPath) throws RepositoryException {
        int pos = jcrPath.length() - 1;
        if (pos < 2 || jcrPath.charAt(pos) != ']') {
            return;
        }
        if ("0123456789".indexOf(jcrPath.charAt(--pos)) == -1) {
            return;
        }
        while (--pos >= 0) {
            char ch = jcrPath.charAt(pos);
            if (ch == '[') {
                throw new RepositoryException("Cannot create a new node using a name including an index");
            }
            if ("0123456789".indexOf(ch) != -1) continue;
            return;
        }
    }

    private void checkAlive() throws RepositoryException {
        if (this.sd == null) {
            throw new RepositoryException("This session has been closed.");
        }
        this.sd.checkAlive();
    }

    @NotNull
    private String getOakPathOrThrow(@NotNull String absPath) throws RepositoryException {
        String p = this.sessionContext.getOakPathOrThrow(absPath);
        if (!PathUtils.isAbsolute((String)p)) {
            throw new RepositoryException("Not an absolute path: " + absPath);
        }
        return p;
    }

    @NotNull
    private String getOakPathOrThrowNotFound(@NotNull String absPath) throws PathNotFoundException {
        return this.sessionContext.getOakPathOrThrowNotFound(absPath);
    }

    @Nullable
    private ItemImpl<?> getItemInternal(@NotNull String oakPath) throws RepositoryException {
        this.checkAlive();
        ItemDelegate item = this.sd.getItem(oakPath);
        if (item instanceof NodeDelegate) {
            return NodeImpl.createNode((NodeDelegate)item, this.sessionContext);
        }
        if (item instanceof PropertyDelegate) {
            return new PropertyImpl((PropertyDelegate)item, this.sessionContext);
        }
        return null;
    }

    @Nullable
    public Node getNodeOrNull(final String absPath) throws RepositoryException {
        Objects.requireNonNull(absPath, "parameter 'absPath' must not be null");
        this.checkAlive();
        return this.sd.performNullable(new ReadOperation<Node>("getNodeOrNull"){

            @Override
            public Node performNullable() throws RepositoryException {
                try {
                    return NodeImpl.createNodeOrNull(SessionImpl.this.sd.getNode(SessionImpl.this.getOakPathOrThrow(absPath)), SessionImpl.this.sessionContext);
                }
                catch (PathNotFoundException e) {
                    return null;
                }
            }
        });
    }

    @Nullable
    public Property getPropertyOrNull(String absPath) throws RepositoryException {
        String oakPath;
        this.checkAlive();
        if (Objects.requireNonNull(absPath, "parameter 'absPath' must not be null").equals("/")) {
            return null;
        }
        try {
            oakPath = this.getOakPathOrThrow(absPath);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        return this.sd.performNullable(new ReadOperation<Property>("getPropertyOrNull"){

            @Override
            public Property performNullable() {
                PropertyDelegate pd = SessionImpl.this.sd.getProperty(oakPath);
                if (pd != null) {
                    return new PropertyImpl(pd, SessionImpl.this.sessionContext);
                }
                return null;
            }
        });
    }

    @Nullable
    public Item getItemOrNull(final String absPath) throws RepositoryException {
        Objects.requireNonNull(absPath, "parameter 'absPath' must not be null");
        this.checkAlive();
        return this.sd.performNullable(new ReadOperation<Item>("getItemOrNull"){

            @Override
            public Item performNullable() throws RepositoryException {
                return SessionImpl.this.getItemInternal(SessionImpl.this.getOakPathOrThrow(absPath));
            }
        });
    }

    @Nullable
    public Node getParentOrNull(@NotNull Item item) throws RepositoryException {
        this.checkAlive();
        final ItemImpl itemImpl = SessionImpl.checkItemImpl(item);
        SessionImpl.checkContext(itemImpl, this.sessionContext);
        return this.sd.performNullable(new ReadOperation<Node>("getParentOrNull"){

            @Override
            public Node performNullable() throws RepositoryException {
                return NodeImpl.createNodeOrNull(((ItemDelegate)itemImpl.dlg).getParent(), SessionImpl.this.sessionContext);
            }
        });
    }

    private static void checkContext(@NotNull ItemImpl item, @NotNull SessionContext context) throws RepositoryException {
        if (item.sessionContext != context) {
            throw new RepositoryException("Item '" + item + "' has been obtained through a different Session.");
        }
    }

    @NotNull
    private static ItemImpl checkItemImpl(@NotNull Item item) throws RepositoryException {
        if (item instanceof ItemImpl) {
            return (ItemImpl)item;
        }
        throw new RepositoryException("Invalid item implementation '" + item.getClass().getName() + "'. Expected " + ItemImpl.class.getName());
    }

    @NotNull
    public Repository getRepository() {
        return this.sessionContext.getRepository();
    }

    public String getUserID() {
        return this.sd.getAuthInfo().getUserID();
    }

    public String[] getAttributeNames() {
        TreeSet<String> names = new TreeSet<String>(this.sessionContext.getAttributes().keySet());
        Collections.addAll(names, this.sd.getAuthInfo().getAttributeNames());
        names.add("oak.bound-principals");
        return names.toArray(new String[names.size()]);
    }

    public Object getAttribute(String name) {
        if ("oak.bound-principals".equals(name)) {
            return this.sd.getAuthInfo().getPrincipals();
        }
        Object attribute = this.sd.getAuthInfo().getAttribute(name);
        if (attribute == null) {
            attribute = this.sessionContext.getAttributes().get(name);
        }
        return attribute;
    }

    @NotNull
    public Workspace getWorkspace() {
        return this.sessionContext.getWorkspace();
    }

    @NotNull
    public Session impersonate(Credentials credentials) throws RepositoryException {
        this.checkAlive();
        ImpersonationCredentials impCreds = new ImpersonationCredentials(Objects.requireNonNull(credentials, "parameter 'credentials' must not be null"), this.sd.getAuthInfo());
        return this.getRepository().login((Credentials)impCreds, this.sd.getWorkspaceName());
    }

    @NotNull
    public ValueFactory getValueFactory() throws RepositoryException {
        this.checkAlive();
        return this.sessionContext.getValueFactory();
    }

    @NotNull
    public Node getRootNode() throws RepositoryException {
        this.checkAlive();
        return this.sd.perform(new ReadOperation<Node>("getRootNode"){

            @Override
            @NotNull
            public Node perform() throws RepositoryException {
                NodeDelegate nd = SessionImpl.this.sd.getRootNode();
                if (nd == null) {
                    throw new AccessDeniedException("Root node is not accessible.");
                }
                return NodeImpl.createNode(nd, SessionImpl.this.sessionContext);
            }
        });
    }

    public Node getNode(String absPath) throws RepositoryException {
        Node node = this.getNodeOrNull(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"));
        if (node == null) {
            throw new PathNotFoundException("Node with path " + absPath + " does not exist.");
        }
        return node;
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        return this.getNodeOrNull(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null")) != null;
    }

    @NotNull
    private Node getNodeById(final @NotNull String id) throws RepositoryException {
        this.checkAlive();
        return this.sd.perform(new ReadOperation<Node>("getNodeById"){

            @Override
            @NotNull
            public Node perform() throws RepositoryException {
                try {
                    NodeDelegate nd = SessionImpl.this.sd.getNodeByIdentifier(id);
                    if (nd == null) {
                        throw new ItemNotFoundException("Node with id " + id + " does not exist.");
                    }
                    return NodeImpl.createNode(nd, SessionImpl.this.sessionContext);
                }
                catch (IllegalArgumentException ex) {
                    throw new RepositoryException((Throwable)ex);
                }
            }
        });
    }

    @NotNull
    public Node getNodeByUUID(String uuid) throws RepositoryException {
        return this.getNodeById(Objects.requireNonNull(uuid, "parameter 'uuid' must not be null"));
    }

    @NotNull
    public Node getNodeByIdentifier(String id) throws RepositoryException {
        return this.getNodeById(Objects.requireNonNull(id, "parameter 'id' must not be null"));
    }

    public Property getProperty(String absPath) throws RepositoryException {
        Property property = this.getPropertyOrNull(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"));
        if (property == null) {
            throw new PathNotFoundException(absPath);
        }
        return property;
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.getPropertyOrNull(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null")) != null;
    }

    public Item getItem(String absPath) throws RepositoryException {
        Item item = this.getItemOrNull(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"));
        if (item == null) {
            throw new PathNotFoundException(absPath);
        }
        return item;
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        return this.getItemOrNull(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null")) != null;
    }

    public void move(String srcAbsPath, String destAbsPath) throws RepositoryException {
        this.checkAlive();
        SessionImpl.checkIndexOnName(Objects.requireNonNull(destAbsPath, "parameter 'destAbsPath' must not be null"));
        final String srcOakPath = this.getOakPathOrThrowNotFound(Objects.requireNonNull(srcAbsPath, "parameter 'srcAbsPath' must not be null"));
        final String destOakPath = this.getOakPathOrThrowNotFound(destAbsPath);
        this.sd.performVoid((SessionOperation<Void>)new WriteOperation<Void>("move"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                SessionImpl.this.sd.checkProtectedNode(PathUtils.getParentPath((String)srcOakPath));
                SessionImpl.this.sd.checkProtectedNode(PathUtils.getParentPath((String)destOakPath));
            }

            @Override
            public void performVoid() throws RepositoryException {
                SessionImpl.this.sd.move(srcOakPath, destOakPath, true);
            }
        });
    }

    public void removeItem(final String absPath) throws RepositoryException {
        this.checkAlive();
        final String oakPath = this.getOakPathOrThrowNotFound(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"));
        this.sd.performVoid((SessionOperation<Void>)new WriteOperation<Void>("removeItem"){

            @Override
            public void performVoid() throws RepositoryException {
                ItemDelegate item = SessionImpl.this.sd.getItem(oakPath);
                if (item == null) {
                    throw new PathNotFoundException(absPath);
                }
                if (item.isProtected()) {
                    throw new ConstraintViolationException(item.getPath() + " is protected");
                }
                if (!item.remove()) {
                    throw new RepositoryException(item.getPath() + " could not be removed");
                }
            }
        });
    }

    public void save() throws RepositoryException {
        this.checkAlive();
        this.sd.performVoid((SessionOperation<Void>)new WriteOperation<Void>("save"){

            @Override
            public void performVoid() throws RepositoryException {
                SessionImpl.this.sd.save(null);
            }

            @Override
            public boolean isSave() {
                return true;
            }
        });
    }

    public void refresh(final boolean keepChanges) throws RepositoryException {
        this.checkAlive();
        this.sd.performVoid((SessionOperation<Void>)new WriteOperation<Void>("refresh"){

            @Override
            public void performVoid() {
                SessionImpl.this.sd.refresh(keepChanges);
            }

            @Override
            public boolean isRefresh() {
                return true;
            }
        });
    }

    public boolean hasPendingChanges() throws RepositoryException {
        this.checkAlive();
        return this.sd.hasPendingChanges();
    }

    public boolean isLive() {
        return this.sd != null && this.sd.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        Object object = this.logoutMonitor;
        synchronized (object) {
            if (this.isLive()) {
                this.sessionCounter.dec();
                try {
                    this.sd.performVoid(new SessionOperation<Void>("logout"){

                        @Override
                        public void performVoid() {
                            SessionImpl.this.sessionContext.dispose();
                            SessionImpl.this.sd.logout();
                        }

                        @Override
                        public boolean isLogout() {
                            return true;
                        }
                    });
                }
                catch (RepositoryException e) {
                    throw new RuntimeException("Unexpected exception thrown by operation 'logout'", e);
                }
                finally {
                    this.sd = null;
                    this.sessionContext = null;
                }
            }
        }
    }

    @NotNull
    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws RepositoryException {
        return new ImportHandler(Objects.requireNonNull(parentAbsPath, "parameter 'parentAbsPath' must not be null"), this.sessionContext, uuidBehavior, false);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, RepositoryException {
        try {
            ContentHandler handler = this.getImportContentHandler(Objects.requireNonNull(parentAbsPath, "parameter 'parentAbsPath' must not be null"), uuidBehavior);
            new ParsingContentHandler(handler).parse(in);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new InvalidSerializedDataException("XML parse error", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private synchronized void export(String path, Exporter exporter) throws SAXException, RepositoryException {
        Item item = this.getItem(path);
        if (!item.isNode()) {
            throw new PathNotFoundException("XML export is not defined for properties: " + path);
        }
        exporter.export((Node)item);
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
        this.export(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"), (Exporter)new SystemViewExporter((Session)this, Objects.requireNonNull(contentHandler, "parameter 'contentHandler' must not be null"), !noRecurse, !skipBinary));
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ToXmlContentHandler handler = new ToXmlContentHandler(Objects.requireNonNull(out, "parameter 'out' must not be null"));
            this.export(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"), (Exporter)new SystemViewExporter((Session)this, (ContentHandler)handler, !noRecurse, !skipBinary));
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing system view XML", (Throwable)e);
        }
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
        this.export(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"), (Exporter)new DocumentViewExporter((Session)this, Objects.requireNonNull(contentHandler, "parameter 'contentHandler' must not be null"), !noRecurse, !skipBinary));
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ToXmlContentHandler handler = new ToXmlContentHandler(Objects.requireNonNull(out, "parameter 'out' must not be null"));
            this.export(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"), (Exporter)new DocumentViewExporter((Session)this, (ContentHandler)handler, !noRecurse, !skipBinary));
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing document view XML", (Throwable)e);
        }
    }

    public void addLockToken(String lt) {
        try {
            this.getWorkspace().getLockManager().addLockToken(Objects.requireNonNull(lt, "parameter 'lt' must not be null"));
        }
        catch (RepositoryException e) {
            log.warn("Unable to add lock token " + lt + " to session", (Throwable)e);
        }
    }

    @NotNull
    public String[] getLockTokens() {
        try {
            return this.getWorkspace().getLockManager().getLockTokens();
        }
        catch (RepositoryException e) {
            log.warn("Unable to retrieve lock tokens from session", (Throwable)e);
            return new String[0];
        }
    }

    public void removeLockToken(String lt) {
        try {
            this.getWorkspace().getLockManager().removeLockToken(Objects.requireNonNull(lt, "parameter 'lt' must not be null"));
        }
        catch (RepositoryException e) {
            log.warn("Unable to remove lock token " + lt + " from session", (Throwable)e);
        }
    }

    public boolean hasPermission(String absPath, final String actions) throws RepositoryException {
        this.checkAlive();
        final String oakPath = this.getOakPathOrThrow(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"));
        Objects.requireNonNull(actions, "parameter 'actions' must not be null");
        return this.sd.perform(new ReadOperation<Boolean>("hasPermission"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return SessionImpl.this.sessionContext.getAccessManager().hasPermissions(oakPath, actions);
            }
        });
    }

    public void checkPermission(String absPath, String actions) throws RepositoryException {
        if (!this.hasPermission(Objects.requireNonNull(absPath, "parameter 'absPath' must not be null"), Objects.requireNonNull(actions, "parameter 'actions' must not be null"))) {
            throw new AccessControlException("Access denied.");
        }
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        Objects.requireNonNull(methodName, "parameter 'methodName' must not be null");
        Objects.requireNonNull(target, "parameter 'target' must not be null");
        this.checkAlive();
        AccessManager accessMgr = this.sessionContext.getAccessManager();
        if (target instanceof ItemImpl) {
            Object dlg = ((ItemImpl)target).dlg;
            if (((ItemDelegate)dlg).isProtected()) {
                return false;
            }
            boolean isNode = ((ItemImpl)target).isNode();
            NodeImpl parent = (NodeImpl)(isNode ? target : ((ItemImpl)target).getParent());
            if (!parent.internalIsCheckedOut()) {
                return false;
            }
            boolean hasLocking = this.sessionContext.getRepository().getDescriptorValue("option.locking.supported").getBoolean();
            if (hasLocking && parent.isLocked()) {
                return false;
            }
            long permission = 0L;
            if (isNode) {
                Tree tree = ((NodeDelegate)dlg).getTree();
                if ("addNode".equals(methodName)) {
                    String relPath = SessionImpl.getFirstArgument(arguments);
                    if (relPath != null) {
                        String path = PathUtils.concat((String)tree.getPath(), (String)this.sessionContext.getOakPathOrThrow(relPath));
                        return accessMgr.hasPermissions(path, "add_node") && !this.isMountedReadOnly(path);
                    }
                    log.warn("Cannot verify capability to '{}' due to missing or invalid arguments, required a valid relative path.", (Object)methodName);
                    return false;
                }
                if ("setPrimaryType".equals(methodName) || "addMixin".equals(methodName) || "removeMixin".equals(methodName)) {
                    permission = 512L;
                } else if ("orderBefore".equals(methodName)) {
                    if (tree.isRoot()) {
                        return false;
                    }
                    permission = 16384L;
                    tree = tree.getParent();
                } else if ("setProperty".equals(methodName)) {
                    permission = 4L;
                } else if ("remove".equals(methodName)) {
                    permission = 64L;
                }
                return accessMgr.hasPermissions(tree, null, permission) && !this.isMountedReadOnly(tree.getPath());
            }
            if ("setValue".equals(methodName)) {
                permission = 8L;
            } else if ("remove".equals(methodName)) {
                permission = 16L;
            }
            NodeDelegate parentDelegate = ((ItemDelegate)dlg).getParent();
            if (parentDelegate != null) {
                return accessMgr.hasPermissions(parentDelegate.getTree(), ((PropertyDelegate)dlg).getPropertyState(), permission) && !this.isMountedReadOnly(parentDelegate.getPath());
            }
            return accessMgr.hasPermissions(((ItemDelegate)dlg).getPath(), permission == 8L ? "set_property" : "remove") && !this.isMountedReadOnly(((ItemDelegate)dlg).getPath());
        }
        if (target instanceof AccessControlManager && SessionImpl.isPolicyWriteMethod(methodName)) {
            if (!SessionImpl.hasArguments(arguments)) {
                log.warn("Cannot verify capability to '{}' due to missing arguments.", (Object)methodName);
                return false;
            }
            String path = SessionImpl.getFirstArgument(arguments);
            if (path == null) {
                return this.getAccessControlManager().hasPrivileges(null, AccessControlUtils.privilegesFromNames((Session)this, (String[])new String[]{"jcr:modifyAccessControl"}));
            }
            String oakPath = this.getOakPathOrThrow(path);
            return !this.isMountedReadOnly(oakPath) && accessMgr.hasPermissions(oakPath, "modify_access_control");
        }
        return true;
    }

    private static boolean hasArguments(@Nullable Object[] arguments) {
        return arguments != null && arguments.length > 0;
    }

    @Nullable
    private static String getFirstArgument(@Nullable Object[] arguments) {
        if (arguments != null && arguments.length > 0) {
            Object arg = arguments[0];
            return arg == null ? null : arg.toString();
        }
        return null;
    }

    private static boolean isPolicyWriteMethod(@NotNull String methodName) {
        return "setPolicy".equals(methodName) || "removePolicy".equals(methodName);
    }

    private boolean isMountedReadOnly(String path) {
        MountInfoProvider mip = this.sessionContext.getMountInfoProvider();
        return mip != null && mip.getMountByPath(path).isReadOnly();
    }

    @NotNull
    public AccessControlManager getAccessControlManager() throws RepositoryException {
        return this.sessionContext.getAccessControlManager();
    }

    @NotNull
    public RetentionManager getRetentionManager() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Retention Management is not supported.");
    }

    public void setNamespacePrefix(String prefix, String uri) throws RepositoryException {
        this.sessionContext.getNamespaces().setNamespacePrefix(Objects.requireNonNull(prefix, "parameter 'prefix' must not be null"), Objects.requireNonNull(uri, "parameter 'uri' must not be null"));
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.sessionContext.getNamespaces().getNamespacePrefixes();
    }

    public String getNamespaceURI(String prefix) throws RepositoryException {
        return this.sessionContext.getNamespaces().getNamespaceURI(Objects.requireNonNull(prefix, "parameter 'prefix' must not be null"));
    }

    public String getNamespacePrefix(String uri) throws RepositoryException {
        return this.sessionContext.getNamespaces().getNamespacePrefix(Objects.requireNonNull(uri, "parameter 'uri' must not be null"));
    }

    public boolean hasPermission(@NotNull String absPath, String ... actions) throws RepositoryException {
        return this.hasPermission(absPath, Text.implode((String[])actions, (String)","));
    }

    @NotNull
    public PrincipalManager getPrincipalManager() throws RepositoryException {
        return this.sessionContext.getPrincipalManager();
    }

    @NotNull
    public UserManager getUserManager() throws RepositoryException {
        return this.sessionContext.getUserManager();
    }

    public String toString() {
        if (this.isLive()) {
            return this.sd.getContentSession().toString();
        }
        return "null";
    }

    @NotNull
    public String getExpandedName(@NotNull Item item) throws RepositoryException {
        try {
            ItemImpl itemImpl = SessionImpl.checkItemImpl(item);
            return itemImpl.sessionContext.getExpandedJcrName(itemImpl.getOakName());
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Namespace exception " + e.getMessage());
        }
    }

    @NotNull
    public String getExpandedPath(@NotNull Item item) throws RepositoryException {
        try {
            ItemImpl itemImpl = SessionImpl.checkItemImpl(item);
            return itemImpl.sessionContext.getExpandedJcrPath(itemImpl.getOakPath());
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Namespace exception " + e.getMessage());
        }
    }

    private abstract class WriteOperation<T>
    extends SessionOperation<T> {
        protected WriteOperation(String name) {
            super(name, true);
        }

        @Override
        public void checkPreconditions() throws RepositoryException {
            SessionImpl.this.checkAlive();
        }
    }

    private abstract class ReadOperation<T>
    extends SessionOperation<T> {
        protected ReadOperation(String name) {
            super(name);
        }

        @Override
        public void checkPreconditions() throws RepositoryException {
            SessionImpl.this.checkAlive();
        }
    }
}

