/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.security.AccessManager;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.plugins.lock.LockConstants;
import org.apache.jackrabbit.oak.plugins.memory.GenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiGenericPropertyState;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;
import org.apache.jackrabbit.util.Text;

public class WorkspaceDelegate {
    private final SessionContext context;

    public WorkspaceDelegate(SessionContext context) {
        this.context = (SessionContext)Preconditions.checkNotNull((Object)context);
    }

    public void copy(String srcPath, String destPath) throws RepositoryException {
        SessionDelegate sessionDelegate = this.context.getSessionDelegate();
        AccessManager accessManager = this.context.getAccessManager();
        Root root = sessionDelegate.getContentSession().getLatestRoot();
        Tree dest = root.getTree(destPath);
        if (dest.exists()) {
            throw new ItemExistsException(destPath);
        }
        Tree destParent = dest.getParent();
        if (!destParent.exists()) {
            throw new PathNotFoundException(destParent.getPath());
        }
        Tree src = root.getTree(srcPath);
        if (src.isRoot()) {
            throw new RepositoryException("Cannot copy the root node");
        }
        if (!src.exists()) {
            throw new PathNotFoundException(srcPath);
        }
        accessManager.checkPermissions(destPath, Permissions.getString((long)512L));
        String userId = sessionDelegate.getAuthInfo().getUserID();
        new WorkspaceCopy(src, destParent, Text.getName((String)destPath)).perform(root, userId);
        sessionDelegate.refresh(true);
    }

    private static final class WorkspaceCopy {
        private final Map<String, String> translated = Maps.newHashMap();
        private final Tree source;
        private final Tree destParent;
        private final String destName;

        public WorkspaceCopy(@Nonnull Tree source, @Nonnull Tree destParent, @Nonnull String destName) {
            this.source = source;
            this.destParent = destParent;
            this.destName = destName;
        }

        public void perform(@Nonnull Root root, @Nonnull String userId) throws RepositoryException {
            try {
                Tree typeRoot = root.getTree("/jcr:system/jcr:nodeTypes");
                this.copy(this.source, this.destParent, this.destName, typeRoot, userId);
                this.updateReferences(this.source, this.destParent.getChild(this.destName));
                HashMap<String, String> copyInfo = new HashMap<String, String>();
                copyInfo.put("copy-source", this.source.getPath());
                if (TreeUtil.isNodeType((Tree)this.source, (String)"mix:versionable", (Tree)typeRoot)) {
                    String sourceBaseVersionId = (String)this.source.getProperty("jcr:baseVersion").getValue(Type.STRING);
                    copyInfo.put("jcr:copiedFrom", sourceBaseVersionId);
                }
                root.commit((Map)ImmutableMap.copyOf(copyInfo));
            }
            catch (CommitFailedException e) {
                throw e.asRepositoryException();
            }
        }

        private void copy(Tree source, Tree destParent, String destName, Tree typeRoot, String userId) throws RepositoryException {
            String primaryType = TreeUtil.getPrimaryTypeName((Tree)source);
            Tree dest = TreeUtil.addChild((Tree)destParent, (String)destName, (String)primaryType, (Tree)typeRoot, (String)userId);
            for (PropertyState property : source.getProperties()) {
                String propName = property.getName();
                if ("jcr:mixinTypes".equals(propName)) {
                    for (String mixin : (Iterable)property.getValue(Type.NAMES)) {
                        TreeUtil.addMixin((Tree)dest, (String)mixin, (Tree)typeRoot, (String)userId);
                    }
                    continue;
                }
                if ("jcr:uuid".equals(propName)) {
                    String sourceId = (String)property.getValue(Type.STRING);
                    String newId = UUIDUtils.generateUUID();
                    dest.setProperty("jcr:uuid", (Object)newId, Type.STRING);
                    if (this.translated.containsKey(sourceId)) continue;
                    this.translated.put(sourceId, newId);
                    continue;
                }
                if ("jcr:primaryType".equals(propName) || VersionConstants.VERSION_PROPERTY_NAMES.contains(propName) || LockConstants.LOCK_PROPERTY_NAMES.contains(propName)) continue;
                dest.setProperty(property);
            }
            for (Tree child : source.getChildren()) {
                this.copy(child, dest, child.getName(), typeRoot, userId);
            }
        }

        private void updateReferences(Tree src, Tree dest) throws RepositoryException {
            for (PropertyState prop : src.getProperties()) {
                if (!this.isReferenceType(prop) || VersionConstants.VERSION_PROPERTY_NAMES.contains(prop.getName())) continue;
                this.updateProperty(prop, dest);
            }
            for (Tree child : src.getChildren()) {
                this.updateReferences(child, dest.getChild(child.getName()));
            }
        }

        private boolean isReferenceType(PropertyState property) {
            Type type = property.getType();
            return type == Type.REFERENCE || type == Type.REFERENCES || type == Type.WEAKREFERENCE || type == Type.WEAKREFERENCES;
        }

        private void updateProperty(PropertyState prop, Tree dest) {
            boolean multi = prop.isArray();
            boolean weak = prop.getType() == Type.WEAKREFERENCE || prop.getType() == Type.WEAKREFERENCES;
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i < prop.count(); ++i) {
                String id = weak ? (String)prop.getValue(Type.WEAKREFERENCE, i) : (String)prop.getValue(Type.REFERENCE, i);
                this.translateId(id, ids);
            }
            PropertyState p = multi ? (weak ? MultiGenericPropertyState.weakreferenceProperty((String)prop.getName(), ids) : MultiGenericPropertyState.referenceProperty((String)prop.getName(), ids)) : (weak ? GenericPropertyState.weakreferenceProperty((String)prop.getName(), (String)((String)ids.get(0))) : GenericPropertyState.referenceProperty((String)prop.getName(), (String)((String)ids.get(0))));
            dest.setProperty(p);
        }

        private void translateId(String id, List<String> ids) {
            String newId = this.translated.get(id);
            if (newId != null) {
                ids.add(newId);
            } else {
                ids.add(id);
            }
        }
    }
}

