/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.xml;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Stack;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.xml.BufferedStringValue;
import org.apache.jackrabbit.oak.jcr.xml.StringValue;
import org.apache.jackrabbit.oak.jcr.xml.TargetImportHandler;
import org.apache.jackrabbit.oak.namepath.JcrNameParser;
import org.apache.jackrabbit.oak.spi.xml.Importer;
import org.apache.jackrabbit.oak.spi.xml.NodeInfo;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DocViewImportHandler
extends TargetImportHandler {
    private static final Logger log = LoggerFactory.getLogger(DocViewImportHandler.class);
    private final Stack<NodeInfo> stack = new Stack();
    private BufferedStringValue textHandler;

    DocViewImportHandler(Importer importer, SessionContext sessionContext) {
        super(importer, sessionContext);
    }

    private Iterable<String> parseNames(String value) throws SAXException {
        String[] names = value.split("\\p{Space}+");
        ArrayList qnames = Lists.newArrayListWithCapacity((int)names.length);
        for (String name : names) {
            try {
                qnames.add(new TargetImportHandler.NameInfo(this, name).getRepoQualifiedName());
            }
            catch (RepositoryException e) {
                throw new SAXException("Invalid name: " + name, (Exception)((Object)e));
            }
        }
        return qnames;
    }

    private void appendCharacters(char[] ch, int start, int length) throws SAXException {
        if (this.textHandler == null) {
            this.textHandler = new BufferedStringValue(this.sessionContext.getValueFactory(), this.currentNamePathMapper(), false);
        }
        try {
            this.textHandler.append(ch, start, length);
        }
        catch (IOException ioe) {
            String msg = "internal error while processing internal buffer data";
            log.error(msg, (Throwable)ioe);
            throw new SAXException(msg, ioe);
        }
    }

    private void processCharacters() throws SAXException {
        block8: {
            try {
                if (this.textHandler == null || this.textHandler.length() <= 0L) break block8;
                try (Reader reader = this.textHandler.reader();){
                    int ch;
                    while ((ch = reader.read()) != -1 && ch <= 32) {
                    }
                    if (ch == -1) {
                        log.debug("ignoring pure whitespace character data...");
                        this.textHandler.dispose();
                        this.textHandler = null;
                        return;
                    }
                }
                NodeInfo node = new NodeInfo(this.getJcrName("http://www.jcp.org/jcr/1.0", "xmltext"), null, null, null);
                ArrayList<PropInfo> props = new ArrayList<PropInfo>();
                props.add(new PropInfo(this.getJcrName("http://www.jcp.org/jcr/1.0", "xmlcharacters"), 1, (TextValue)this.textHandler));
                this.importer.startNode(node, props);
                this.importer.endNode(node);
                this.textHandler.dispose();
                this.textHandler = null;
            }
            catch (IOException ioe) {
                String msg = "internal error while processing internal buffer data";
                log.error(msg, (Throwable)ioe);
                throw new SAXException(msg, ioe);
            }
            catch (RepositoryException re) {
                throw new SAXException((Exception)((Object)re));
            }
        }
    }

    private String getJcrName(String uri, String name) throws RepositoryException {
        return this.sessionContext.getSession().getNamespacePrefix(uri) + ':' + name;
    }

    private TargetImportHandler.NameInfo processName(TargetImportHandler.NameInfo nameInfo) throws RepositoryException {
        String decodedLocalName = ISO9075.decode((String)nameInfo.getLocalName());
        TargetImportHandler.NameInfo decodedNameInfo = new TargetImportHandler.NameInfo(this, nameInfo.getDocPrefix(), decodedLocalName);
        if (!decodedLocalName.equals(nameInfo.getLocalName())) {
            try {
                JcrNameParser.checkName((String)decodedNameInfo.getRepoQualifiedName(), (boolean)true);
            }
            catch (ConstraintViolationException e) {
                log.warn("encountered illegal decoded name '" + decodedLocalName + '\'', (Throwable)e);
                return nameInfo;
            }
        }
        return decodedNameInfo;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.processCharacters();
        try {
            TargetImportHandler.NameInfo nameInfo = new TargetImportHandler.NameInfo(this, qName);
            nameInfo = this.processName(nameInfo);
            String id = null;
            String nodeTypeName = null;
            Iterable<String> mixinTypes = null;
            ArrayList<PropInfo> props = new ArrayList<PropInfo>(atts.getLength());
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getURI(i).equals("http://www.w3.org/2000/xmlns/")) continue;
                TargetImportHandler.NameInfo propNameInfo = this.processName(new TargetImportHandler.NameInfo(this, atts.getQName(i)));
                String attrValue = atts.getValue(i);
                if ("http://www.jcp.org/jcr/1.0".equals(propNameInfo.getNamespaceUri()) && "primaryType".equals(propNameInfo.getLocalName())) {
                    if (attrValue.isEmpty()) continue;
                    nodeTypeName = attrValue;
                    continue;
                }
                if ("http://www.jcp.org/jcr/1.0".equals(propNameInfo.getNamespaceUri()) && "mixinTypes".equals(propNameInfo.getLocalName())) {
                    mixinTypes = this.parseNames(attrValue);
                    continue;
                }
                if ("http://www.jcp.org/jcr/1.0".equals(propNameInfo.getNamespaceUri()) && "uuid".equals(propNameInfo.getLocalName())) {
                    if (attrValue.isEmpty()) continue;
                    id = attrValue;
                    continue;
                }
                StringValue tv = new StringValue(attrValue, this.sessionContext.getValueFactory(), this.currentNamePathMapper());
                props.add(new PropInfo(propNameInfo.getRepoQualifiedName(), 0, (TextValue)tv));
            }
            NodeInfo node = new NodeInfo(nameInfo.getRepoQualifiedName(), nodeTypeName, mixinTypes, id);
            this.importer.startNode(node, props);
            this.stack.push(node);
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.appendCharacters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.appendCharacters(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.processCharacters();
        NodeInfo node = this.stack.peek();
        try {
            this.importer.endNode(node);
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
        this.stack.pop();
    }
}

